#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Peter Singhofen & F. McKinnie
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def is_number(s):
  try:
    float(s)
    return True
  except ValueError:
    return False

def csv_format(s):
  if s is None:
    return ''.encode('utf-8')
  if is_number(s):
    s = str(s)
    return s.encode('utf-8')
    
  #Changed to decode if bytes for Python 3
  if isinstance(s, bytes):
    s=s.decode('utf-8')

  outstr=['"']
  for c in s:

    if c=='\\':
      outstr.append('\\\\')
    elif c=='\n':
      outstr.append('\\n')
    elif c=='\r':
      #intentionally do nothing
      x=1
    elif c=='"':
      outstr.append('\\"')      
    else:
      outstr.append(c)

  outstr.append('"')
  outstr = ''.join(outstr)
  outstr = outstr.encode('utf-8')
  return outstr

def csv_writerow(csv_file, row):
  i=0

  while i<len(row):    
    if i>0: csv_file.write(','.encode('utf-8'))

    csv_file.write(csv_format(row[i]))
    i=i+1
  csv_file.write('\r\n'.encode('utf-8'))
  return

def trim_trailing_spaces(lst):
  x=len(lst)-1
  while x>=0:
    if lst[x]==' ':
      del lst[x]
    else:
      return
    x=x-1
  return

def csv_parseline(line):
  row=[]
  fld=[]
  esc=False
  inq=False
  nws=False
  nomore=False
  hadquote=False
  for c in line:
    if esc==True:
       esc=False
       if c=='n':
         if nomore==False: fld.append('\n')
       else:
         if nomore==False: fld.append(c)
    else:
      if c=='"':
        nws=True
        if inq==True:
          inq=False
          nomore=True
        else:
          inq=True
          hadquote=True
      elif c=='\\':
        esc=True
        nws=True
      elif c==',':
        if inq==True:
          if nomore==False: fld.append(',')
          nws=True
        else:
          if hadquote==False: trim_trailing_spaces(fld)
          row.append(''.join(fld))
          inq=False
          esc=False
          nws=False
          nomore=False
          hadquote=False
          fld=[]
      elif c==' ':
        if nws==True:
          if nomore==False: fld.append(' ')
      elif c!='\n':
        nws=True
        if nomore==False: fld.append(c)
  if hadquote==False: trim_trailing_spaces(fld)
  row.append(''.join(fld))
  return row     











