#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def ReferencePoint_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow

    
    ####################################################################
    #Write feature data to CSV          
    ####################################################################

    try:
        infc = "Reference_Element_Point"
        outfc = outpath + slash + stem + "_RE_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)
        shapefieldname = desc.ShapeFieldName

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ID",
             "ParentID",
             'Name',
             'Comment',
             'ShapeX',
             'ShapeY',
             'ShapeZ',
             'TextX',
             'TextY',
             'TextZ']
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            #
            for row in rows:

                #Only write out data for points whose scenario exists
                if row.Scenario in ScDict:

                    #Assign ID and ParentID
                    GUID = ScDict[row.SCENARIO][0]
                    
                    # Create the geometry object 'feat'
                    #
                    feat = row.getValue(shapefieldname)
                    pnt = feat.getPart()

                    #Define Comment
                    Comment = row.Comment
                    
                    #Write x, y coordinates of current point to CSV
                    a = [row.ICPR_GUID,
                         GUID,
                         row.Name,
                         Comment,
                         pnt.X,
                         pnt.Y,
                         "",
                         pnt.X,
                         pnt.Y,
                         ""]                    
                
                
                    csv_writerow(f,a)
        del rows
        
    except:
        
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
