#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def RatingCurveTable_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    #Code Changes for rating curves (Description, GDB Domain, ICPR4 Code)
    Rating_Code = [('Upstream Stage', 0, 0),('Family of Curves', 1, 3),
                   ('Time', 2, 1), ('Head', 3, 2)]

    try:
        infc = "ICPR4_RatingCurveOpTable"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_RatingCurveTable.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Name',
             'Type',
             'Comment']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            RatingCurveDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = ScDict[row.Scenario][0]

                    #Change Code
                    Code_Index = [x[1] for x in Rating_Code].index(row.Type)
                    Code = Rating_Code[Code_Index][2]

                    #Define Comment
                    Comment = row.Comment
                        
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         Code,
                         Comment]

                    Rating_Data = (row.ICPR_GUID, row.Name)
                    RatingCurveDict[row.Name]=Rating_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table point data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_RatingCurveOpTable_PTS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_RatingCurveTable_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'X',
             'Y',
             'Z']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = RatingCurveDict[row.NAME][0]
                    
                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.X,
                         row.Y,
                         row.Z]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages() 
######################################################################################################
######################################################################################################
