#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

#           OF_Region module
######################################################################################################
######################################################################################################

def OF_Region_write_file(outpath, stem, ScDict, OF_Processed):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Create attribute table CSV
    ####################################################################

    #Region Info Tuple
    OFRegionDict = {}

    try:

        infc = "OF_Region"
        
        #Define output location
        outfc = outpath + slash + stem + "_OverlandFlowRegion.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        #Add XY Data for label
        shapeName = arcpy.Describe(infc).shapeFieldName

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "TextX",
             "TextY",
             "TextZ",
             "Comment",
             'MinTriangulationAngle',
             'MinTriangulationArea',
             'CellSize_DiamondLayer',
             'CellSize_HoneycombLayer',
             'Surface_Ground',
             'Ground_UseSingleElevation',
             'GroundElevation',
             'Surface_InitialStage',
             'InitialStage_UseSingleElevation',
             'InitialStageElevation',
             'MapLayer_RoughnessZone',
             'UseSingleRoughnessZone',
             'RoughnessZone',
             'MapLayer_SoilZone',
             'UseSingleSoilZone',
             'SoilZone',
             'MapLayer_LandCoverZone',
             'UseSingleLandCoverZone',
             'LandCoverZone',
             'MapLayer_RainfallZone',
             'UseSingleRainfallZone',
             'RainfallZone',
             'UseRegionAsMappedBasinFeature',
             'MapLayer_MappedBasin',
             'UseSingleMappedBasin',
             'MappedBasin',
             'MapLayer_InfiltrationMethod',
             'UseSingleInfiltrationMethod',
             'InfiltrationMethod',
             'IncludeEvapotranspiration',
             'MapLayer_ReferenceET',
             'UseSingleReferenceETStation',
             'ReferenceETStation',
             'MapLayer_CropCoefZone',
             'UseSingleCropCoefZone',
             'CropCoefZone',
             'MaxTriangulationArea',
             'BoundaryPointSpacing']       
        

        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

           
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = ScDict[row.Scenario][0]

                    #Define Comment
                    Comment = row.Comment

                    #Determine Label Position
                    pnts = row.getValue(shapeName)
                    pnt = pnts.labelPoint
                    
                    PntX = pnt.X
                    PntY = pnt.Y 

                    ##Default parameters used for "MinTriangulationAngle","MinTriangulationArea","CellSize_DiamondLayer", "CellSize_HoneycombLayer"
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         PntX,
                         PntY,
                         "",
                         Comment,
                         row.MinTriangulationAngle,
                         row.MinTriangulationArea,
                         row.CellSize_DiamondLayer,
                         row.CellSize_HoneycombLayer,
                         row.Surface_Ground,
                         row.Ground_UseSingleElevation,
                         row.GroundElevation,
                         row.Surface_InitialStage,
                         row.InitialStage_UseSingleElevation,
                         row.InitialStageElevation,
                         row.MapLayer_RoughnessZone,
                         row.UseSingleRoughnessZone,
                         row.RoughnessZone,
                         row.MapLayer_SoilZone,
                         row.UseSingleSoilZone,
                         row.SoilZone,
                         row.MapLayer_LandCoverZone,
                         row.UseSingleLandCoverZone,
                         row.LandCoverZone,
                         row.MapLayer_RainfallZone,
                         row.UseSingleRainfallZone,
                         row.RainfallZone,
                         row.UseRegionAsMappedBasinFeature,
                         row.MapLayer_MappedBasin,
                         row.UseSingleMappedBasin,
                         row.MappedBasin,
                         row.MapLayer_InfiltrationMethod,
                         row.UseSingleInfiltrationMethod,
                         row.InfiltrationMethod,
                         row.IncludeEvapotranspiration,
                         row.MapLayer_ReferenceET,
                         row.UseSingleReferenceETStation,
                         row.ReferenceETStation,
                         row.MapLayer_CropCoefZone,
                         row.UseSingleCropCoefZone,
                         row.CropCoefZone,
                         row.MaxTriangulationArea,
                         row.BoundaryPointSpacing]

                    #Store region data in tuple
                    OF_Region_Data = (row.ICPR_GUID, row.Name)
                    OFRegionDict[row.Name]=OF_Region_Data
                        
                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()

        del rows

    except:
        arcpy.GetMessages()  
    
    ####################################################################
    #Create coordinates CSV
    ####################################################################

    if OF_Processed == True:
        
        try:
            
            infc = "OF_Region"
            
            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
            except:            
                pass
            
            outfc = outpath + slash + stem + "_OverlandFlowRegion_Point.csv"
           

            # Identify the input feature class to describe
            #
            desc = arcpy.Describe(infc)
            shapefieldname = desc.ShapeFieldName
           
            # Create search cursor
            #
            rows = arcpy.SearchCursor(infc)

            # Write headers to CSV
            a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
            
            with open(outfc,'wb') as f:
                csv_writerow(f,a)   

                # Enter for loop for each feature/row
                for row in rows:

                    try:

                        #Determine Parent ID
                        GUID = OFRegionDict[row.Name][0]
                    
                        # Create the geometry object
                        #
                        feat = row.getValue(shapefieldname)
                        partnum = 0

                        # Count the number of points in the current multipart feature
                        #
                        partcount = feat.partCount

                        #Total number of points in feature    
                        pointcount = feat.pointCount
                        
                        # Enter while loop for each part in the feature (if a singlepart feature
                        # this will occur only once)
                        #
                        while partnum < partcount:
                            # Print the part number
                            #
                            part = feat.getPart(partnum)
                            pnt = part.next()
                            pntcount = 0
                    
                            # Enter while loop for each vertex
                            #
                            while pnt:
                                #Write x, y coordinates of current point to CSV
                                a = [GUID, "{"+str(uuid.uuid4())+"}", pntcount, pnt.X, pnt.Y, ""]

                                #Only write points up the last point, which is excluded            
                                if pntcount < pointcount-1:
                                    csv_writerow(f,a)
                                            
                                pnt = part.next()
                                pntcount = pntcount + 1
                    
                                # If pnt is null, either the part is finished or there is an 
                                #   interior ring
                                #
                                if not pnt: 
                                    pnt = part.next()
                                    if pnt:
                                        print("Interior Ring:")
                            partnum = partnum + 1

                    except:
                        arcpy.GetMessages()

            del rows

        except:
            arcpy.GetMessages()


    #############################################################################################
    #Write out returned values (row.ICPR_GUID, row.Name)         
    #############################################################################################
    try:

        return OFRegionDict

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
