#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def MappedBasin_write_file(outpath, ScDict, stem, BasinDict):
    #Add forward slash for file path

    slash = "\\"
    import arcpy
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV
    ####################################################################

    try:

        infc = "ICPR_BASIN"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        #Define output location.
        outfc = outpath + slash +stem +  "_MappedBasin.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Node",
             "HydrographMethod",
             "InfiltrationMethod",
             "TimeOfConcentration",
             "MaxAllowableQ",
             "TimeShift",
             "UnitHydrograph",
             "PeakingFactor",
             "Comment",
             "ShapeX",
             "ShapeY",
             "ShapeZ",
             "TextX",
             "TextY",
             "TextZ",
             "ISPLACED",
             "WQ_WQOption",
             "WQ_Comment",
             "WQ_ShapeX",
             "WQ_ShapeY",
             "WQ_ShapeZ",
             "WQ_IsPlaced"]

        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:

                #Assign ID and ParentID
                GUID = ScDict[row.SCENARIO][0]

                BasinType = BasinDict[row.Name][3]

                #Define Comment
                Comment = row.COMMENT
                Comment_WQ = row.WQ_Comment

                #Check if has geometry
                try:
                    if row.ShapeX is None or row.ShapeY is None:
                        pnts = row.getValue(shapeName)
                        pnt = pnts.labelPoint

                        PntX = pnt.X
                        PntY = pnt.Y

                    else:

                        PntX = row.ShapeX
                        PntY = row.ShapeY

                    IsPlaced = row.ISPLACED

                #If geometry doesn't exist
                except:

                    PntX = row.ShapeX
                    PntY = row.ShapeY
                    IsPlaced = row.ISPLACED

                #Write out data for mapped basins only
                if BasinType == int(1):

                    a = [GUID,
                         row.ICPR_GUID,
                         row.NAME,
                         row.NODENAME,
                         row.TYPE,
                         row.INFILTRATION_METHOD,
                         row.TC,
                         row.MAXQ,
                         row.TIMESHIFT,
                         row.UNITHYD,
                         row.PEAKFACTOR,
                         Comment,
                         PntX,
                         PntY,
                         "",
                         PntX,
                         PntY,
                         "",
                         IsPlaced,
                         row.WQ_WQOption,
                         Comment_WQ,
                         row.WQ_ShapeX,
                         row.WQ_ShapeY,
                         row.WQ_ShapeZ,
                         row.WQ_IsPlaced]

                    csv_writerow(f,a)

        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
