#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_WQ_write_file(outpath, stem, LinkDict):
    #Add forward slash for file path

    slash = "\\"
    import arcpy
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV
    ####################################################################

    try:
        infc = "ICPR4_Link_WQ"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        #Define output location.
        outfc = outpath + slash + stem+ "_Link_WQ.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Constituent",
             "PosRemovalEfficiency",
             "NegRemovalEfficiency",
             "UseDfltIrrConcentration",
             "IrreducibleConcentration"]

        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:

                #Only write data where link name is populated
                if row.Link_Name is not None:

                    #Determine Parent GUID for child table 

                    arcpy.AddMessage(LinkDict)                
                    GUID = LinkDict[row.Link_Name][1]

                    a = [GUID,
                         row.ICPR_GUID,
                         row.Constituent,
                         row.PosRemovalEfficiency,
                         row.NegRemovalEfficiency,
                         row.UseDfltIrrConcentration,
                         row.IrreducibleConcentration]

                    csv_writerow(f,a)



        del rows
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
