#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_RatingCurve_write_file(outpath, stem, LinkDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_RATINGCURVE"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location.
        outfc = outpath + slash + stem + "_Link_RatingCurve_RatingCurveTable.csv"
        outfc2 = outpath + slash + stem + "_Link_RatingCurve.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to Link_RatingCurve CSV
        a2 = ["ParentID","ID"]
        with open(outfc2,'wb') as f2:
            csv_writerow(f2,a2)

            # Write headers to Link_RatingCurve_RatingCurveTable CSV
            a = ["ParentID",
                 "ID",
                 "RatingCurveTable",
                 "ElevationOn",
                 "Node_ElevationOn",
                 "ElevationOff",
                 "Node_ElevationOff"]
            
            with open(outfc,'wb') as f:
                csv_writerow(f,a)

                #Initialize GUIDs Value
                GUID1 = "Blank"
                
                # Enter for loop for each feature/row
                for row in rows:

                    #Only write data where link name is populated
                    if row.NAME is not None:

                        try:

                            #Check link code
                            LinkCode = LinkDict[row.NAME][2]
                            
                            if int(LinkCode) == int(27):

                                #Determine Parent GUID for child table
                                GUID = LinkDict[row.NAME][1]
                                ID = "{"+str(uuid.uuid4())+"}"

                                if GUID != GUID1:
                                    a2 = [GUID, ID]
                                    GUID1 = GUID
                                    ID_New = ID
                                    
                                    csv_writerow(f2,a2)
                                    
                                else:
                                    a2 = [GUID, ID_New]                     


                                a = [ID_New,
                                     "{"+str(uuid.uuid4())+"}",
                                     row.RATINGCURVE,
                                     row.ELEV_ON,
                                     row.ELEV_ON_NODE,
                                     row.ELEV_OFF,
                                     row.ELEV_OFF_NODE]
                                
                                csv_writerow(f,a)

                        except:
                            arcpy.GetMessages()

        del rows
    except:
        arcpy.GetMessages()        
######################################################################################################
######################################################################################################
