#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_FrenchDrain_write_file(outpath, stem, LinkDict, PipeGeomCode):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_EXFILTRATIONTRENCH"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Link_FrenchDrain.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "OverlandFlowRegion",
             "GroundwaterRegion",
             "MeshScalingFactor",
             "TrenchLength",
             "TrenchWidth",
             "TrenchHeight",
             "TrenchDepthBelowInvert",
             "TrenchGravelPorosity",
             "DampeningThreshold",
             "FHWACulvertCode",
             "EntranceLossCoef",
             "ExitLossCoef",
             "BendLossCoef",
             "BendLocation",
             "EnergySwitch",
             "PipeLength",
             "UsPipeInvert",
             "DsPipeInvert",
             "ManningsN",
             "PipeGeometry",
             "PipeMaxDepth",
             "PipeMaxWidth",
             "PipeFillet",
             "PipeCrossSection"]
             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
      
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR link name specified
                if row.NAME is not None:

                    try:
                    
                        #Check link code
                        LinkCode = LinkDict[row.NAME][2]

                        #Only process links included in this module
                        if int(LinkCode) == int(28):

                            #Determine Parent GUID
                            GUID = LinkDict[row.NAME][1]

                            #Set ICPR4 geometry code
                            Geom_index = [x[1] for x in PipeGeomCode].index(row.PipeGeometry)
                            Geom = PipeGeomCode[Geom_index][2]
                            
                            #Strip out null where calculations are performed and set to 0
                            #Max Span
                            try:
                                MaxWidth = round(row.PipeMaxWidth/12.,4)
                            except:
                                MaxWidth = 0                        
                            #Max Rise
                            try:
                                MaxDepth = round(row.PipeMaxDepth/12.,4)
                            except:
                                MaxDepth = 0

                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.OverlandFlowRegion,
                                 row.GroundwaterRegion,
                                 row.MeshScalingFactor,
                                 row.TRENCHLENGTH_MS,
                                 row.TRENCHWIDTH_MS,
                                 row.TRENCHHEIGHT_MS,
                                 row.TrenchDepthBelowInvert,
                                 row.GRAVELPOROSITY_VAL,
                                 row.DampeningThreshold,
                                 row.FHWACulvertCode,
                                 row.EntranceLossCoef,
                                 row.ExitLossCoef,
                                 row.BendLossCoef,
                                 row.BendLocation,
                                 row.EnergySwitch,
                                 row.PipeLength,
                                 row.UsPipeInvert,
                                 row.DsPipeInvert,
                                 row.ManningsN,
                                 Geom,
                                 MaxDepth,
                                 MaxWidth,
                                 row.PipeFillet,
                                 row.PipeCrossSection]
                                
                            
                            csv_writerow(f,a)
                    
                    except:
                        arcpy.GetMessages()

        del rows
                
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
