#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_Breach_write_file(outpath, stem, LinkDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_BREACH"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Link_Breach.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "DampeningThreshold",
             "TriggerElevation",
             "BreachDuration",
             "TopElevation",
             "BottomElevation",
             "FinalBottomWidth",
             "LeftSideSlope",
             "RightSideSlope",
             "WeirType",
             "WeirDischargeCoef",
             "PowerCoef"]

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
      
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR link name specified
                if row.NAME is not None:

                    try:
                    
                        #Check link code
                        LinkCode = LinkDict[row.NAME][2]

                        #Only process links included in this module
                        if int(LinkCode) == int(26):

                            #Determine Parent GUID
                            GUID = LinkDict[row.NAME][1]             

                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.DAMPENING_THRESHOLD,
                                 row.WSURFELEV_MS,
                                 row.DURATION_VAL,
                                 row.TOPELEV_MS,
                                 row.BOTTOMELEV_MS,
                                 row.BOTTOMWIDTH_MS,
                                 row.LEFTSIDESLOPE_MS,
                                 row.RIGHTSIDESLOPE_MS,
                                 row.EQUATION_DESC,
                                 row.WEIRCOEF_VAL,
                                 row.POWERCOEF_VAL]  
                            
                            csv_writerow(f,a)

                    except:
                        arcpy.GetMessages()
        del rows
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
