#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def GW_Breakline_write_file(outpath, stem, GWRegionDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write Breakline attribute table data to CSV          
    ####################################################################
    
    try:
                
        infc = "GW_Breakline"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem+ "_Feature_GW_Breakline.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Empty LinkInfo tuple
        LinkInfo = []
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Comment",
             "TextX",
             "TextY",
             "TextZ",
             "Interpolate",
             "Apply3D"]
             
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = GWRegionDict[row.GroundwaterRegion][0]

                    #Calculate text location at midpoint of link
                    midpoint = row.shape.positionAlongLine(0.50,True).firstPoint
                    TextX = midpoint.X
                    TextY = midpoint.Y

                    #Define Comment
                    Comment = row.Comment                

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         Comment,
                         TextX,
                         TextY,
                         "",
                         row.Interpolate,
                         row.Apply3D]

                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)
                
        del rows
        
    except:

        arcpy.GetMessages()

    ####################################################################
    #Create CSV for link coordinates
    ####################################################################

    try:
        
        infc = "GW_Breakline"
        outfc = outpath + slash + stem + "_Feature_GW_Breakline_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)
        
        shapefieldname = desc.ShapeFieldName

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                #Verify OF region exists in GDB before writing out data            
                if row.GroundwaterRegion in GWRegionDict:
                
                    # Create the geometry object
                    #
                    feat = row.getValue(shapefieldname)
                    partnum = 0

                    # Count the number of points in the current multipart feature
                    #
                    partcount = feat.partCount

                    # Enter while loop for each part in the feature (if a singlepart feature
                    # this will occur only once)
                    #
                    while partnum < partcount:
                        # Print the part number
                        #
                        part = feat.getPart(partnum)
                        pnt = part.next()
                        pntcount = 0
                
                        # Enter while loop for each vertex
                        #
                        while pnt:
                            #Write x, y, Z coordinates of current point to CSV
                            #
                            a = [row.ICPR_GUID, "{"+str(uuid.uuid4())+"}", pntcount,  pnt.X, pnt.Y, pnt.Z]
                            csv_writerow(f,a)
                                        
                            pnt = part.next()
                            pntcount = pntcount + 1
                
                            # If pnt is null, either the part is finished or there is an 
                            #   interior ring
                            #
                            if not pnt: 
                                pnt = part.next()
                                if pnt:
                                    print("Interior Ring:")
                        partnum = partnum + 1

        del rows
                    
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
