#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_Simulations(infc1, Merge, Filestem, ScenDict):
##########################################################################################################################
#Manual Basin - Update attribute table data and no geometry data
##########################################################################################################################
    try:
    
        #Output
        outfc = "ICPR4_Simulation"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Simulation.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features

        fields = ['IID',
                  'ICPR_GUID',
                  'Name',
                  'RunMode',
                  'HotStartSimulation',
                  'StartTime_Year',
                  'StartTime_Month',
                  'StartTime_Day',
                  'StartTime_Hour',
                  'EndTime_Year',
                  'EndTime_Month',
                  'EndTime_Day',
                  'EndTime_Hour',
                  'HotStartTime_Year',
                  'HotStartTime_Month',
                  'HotStartTime_Day',
                  'HotStartTime_Hour',
                  'MinCalcTime_Hydrology',
                  'MinCalcTime_SurfHydraulics',
                  'MinCalcTime_Groundwater',
                  'MaxCalcTime_SurfHydraulics',
                  'Comment',
                  'SaveRestart',
                  'RainfallSet',
                  'PM_ReferenceETSet',
                  'UnitHydrographSet',
                  'BoundaryStageSet',
                  'ExternalHydrographSet',
                  'CurveNumberSet',
                  'GreenAmptSet',
                  'RichardsEquationSet',
                  'ImperviousSet',
                  'RoughnessSet',
                  'PM_CropCoefSet',
                  'FillablePorositySet',
                  'ConductivitySet',
                  'LeakageSet',
                  'TimeMarching',
                  'MaxIterations',
                  'OverRelaxWeightFactor',
                  'dZTolerance',
                  'Max_dZ',
                  'LinkOptimizerTolerance',
                  'EdgeLengthOption',
                  'EdgeLengthFactor',
                  'DefaultDampThresh_2D',
                  'MinNodeSurfaceArea_2D',
                  'EnergySwitch_2D',
                  'IARecoveryTime',
                  'IncludeETManualBasins',
                  'RainfallOption_ManualBasin',
                  'RainfallOption_OFRegion',
                  'RainfallName',
                  'RainfallAmount',
                  'StormDuration',
                  'DefaultDampThresh_1D',
                  'MinNodeSurfaceArea_1D',
                  'EnergySwitch_1D',
                  'Scenario',
                  'EMCConstituentSet',
                  'Ia_S']                  

                  
        #List index
        GDB_IID = fields.index('IID')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Name = fields.index('Name')
        GDB_RunMode = fields.index('RunMode')
        GDB_HotStartSimulation = fields.index('HotStartSimulation')
        GDB_StartTime_Year = fields.index('StartTime_Year')
        GDB_StartTime_Month = fields.index('StartTime_Month')
        GDB_StartTime_Day = fields.index('StartTime_Day')
        GDB_StartTime_Hour = fields.index('StartTime_Hour')
        GDB_EndTime_Year = fields.index('EndTime_Year')
        GDB_EndTime_Month = fields.index('EndTime_Month')
        GDB_EndTime_Day = fields.index('EndTime_Day')
        GDB_EndTime_Hour = fields.index('EndTime_Hour')
        GDB_HotStartTime_Year = fields.index('HotStartTime_Year')
        GDB_HotStartTime_Month = fields.index('HotStartTime_Month')
        GDB_HotStartTime_Day = fields.index('HotStartTime_Day')
        GDB_HotStartTime_Hour = fields.index('HotStartTime_Hour')
        GDB_MinCalcTime_Hydrology = fields.index('MinCalcTime_Hydrology')
        GDB_MinCalcTime_SurfHydraulics = fields.index('MinCalcTime_SurfHydraulics')
        GDB_MinCalcTime_Groundwater = fields.index('MinCalcTime_Groundwater')
        GDB_MaxCalcTime_SurfHydraulics = fields.index('MaxCalcTime_SurfHydraulics')
        GDB_Comment = fields.index('Comment')
        GDB_SaveRestart = fields.index('SaveRestart')
        GDB_RainfallSet = fields.index('RainfallSet')
        GDB_PM_ReferenceETSet = fields.index('PM_ReferenceETSet')
        GDB_UnitHydrographSet = fields.index('UnitHydrographSet')
        GDB_BoundaryStageSet = fields.index('BoundaryStageSet')
        GDB_ExternalHydrographSet = fields.index('ExternalHydrographSet')
        GDB_CurveNumberSet = fields.index('CurveNumberSet')
        GDB_GreenAmptSet = fields.index('GreenAmptSet')
        GDB_RichardsEquationSet = fields.index('RichardsEquationSet')
        GDB_ImperviousSet = fields.index('ImperviousSet')
        GDB_RoughnessSet = fields.index('RoughnessSet')
        GDB_PM_CropCoefSet = fields.index('PM_CropCoefSet')
        GDB_FillablePorositySet = fields.index('FillablePorositySet')
        GDB_ConductivitySet = fields.index('ConductivitySet')
        GDB_LeakageSet = fields.index('LeakageSet')
        GDB_TimeMarching = fields.index('TimeMarching')
        GDB_MaxIterations = fields.index('MaxIterations')
        GDB_OverRelaxWeightFactor = fields.index('OverRelaxWeightFactor')
        GDB_dZTolerance = fields.index('dZTolerance')
        GDB_Max_dZ = fields.index('Max_dZ')
        GDB_LinkOptimizerTolerance = fields.index('LinkOptimizerTolerance')
        GDB_EdgeLengthOption = fields.index('EdgeLengthOption')
        GDB_EdgeLengthFactor = fields.index('EdgeLengthFactor')
        GDB_DefaultDampThresh_2D = fields.index('DefaultDampThresh_2D')
        GDB_MinNodeSurfaceArea_2D = fields.index('MinNodeSurfaceArea_2D')
        GDB_EnergySwitch_2D = fields.index('EnergySwitch_2D')
        GDB_IARecoveryTime = fields.index('IARecoveryTime')
        GDB_IncludeETManualBasins = fields.index('IncludeETManualBasins')
        GDB_RainfallOption_ManualBasin = fields.index('RainfallOption_ManualBasin')
        GDB_RainfallOption_OFRegion = fields.index('RainfallOption_OFRegion')
        GDB_RainfallName = fields.index('RainfallName')
        GDB_RainfallAmount = fields.index('RainfallAmount')
        GDB_StormDuration = fields.index('StormDuration')
        GDB_DefaultDampThresh_1D = fields.index('DefaultDampThresh_1D')
        GDB_MinNodeSurfaceArea_1D = fields.index('MinNodeSurfaceArea_1D')
        GDB_EnergySwitch_1D = fields.index('EnergySwitch_1D')
        GDB_Scenario = fields.index('Scenario')
        GDB_EMCConstituentSet = fields.index('EMCConstituentSet')
        GBD_Ia_S = fields.index('Ia_S')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:        

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_IID = header_row.index("IID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Execute = header_row.index("Execute")
                        CSV_RunMode = header_row.index("RunMode")
                        CSV_HotStartSimulation = header_row.index("HotStartSimulation")
                        CSV_StartTime_Year = header_row.index("StartTime_Year")
                        CSV_StartTime_Month = header_row.index("StartTime_Month")
                        CSV_StartTime_Day = header_row.index("StartTime_Day")
                        CSV_StartTime_Hour = header_row.index("StartTime_Hour")
                        CSV_EndTime_Year = header_row.index("EndTime_Year")
                        CSV_EndTime_Month = header_row.index("EndTime_Month")
                        CSV_EndTime_Day = header_row.index("EndTime_Day")
                        CSV_EndTime_Hour = header_row.index("EndTime_Hour")
                        CSV_HotStartTime_Year = header_row.index("HotStartTime_Year")
                        CSV_HotStartTime_Month = header_row.index("HotStartTime_Month")
                        CSV_HotStartTime_Day = header_row.index("HotStartTime_Day")
                        CSV_HotStartTime_Hour = header_row.index("HotStartTime_Hour")
                        CSV_MinCalcTime_Hydrology = header_row.index("MinCalcTime_Hydrology")
                        CSV_MinCalcTime_SurfHydraulics = header_row.index("MinCalcTime_SurfHydraulics")
                        CSV_MinCalcTime_Groundwater = header_row.index("MinCalcTime_Groundwater")
                        CSV_MaxCalcTime_SurfHydraulics = header_row.index("MaxCalcTime_SurfHydraulics")
                        CSV_Comment = header_row.index("Comment")
                        CSV_SaveRestart = header_row.index("SaveRestart")
                        CSV_RainfallSet = header_row.index("RainfallSet")
                        CSV_PM_ReferenceETSet = header_row.index("PM_ReferenceETSet")
                        CSV_UnitHydrographSet = header_row.index("UnitHydrographSet")
                        CSV_BoundaryStageSet = header_row.index("BoundaryStageSet")
                        CSV_ExternalHydrographSet = header_row.index("ExternalHydrographSet")
                        CSV_CurveNumberSet = header_row.index("CurveNumberSet")
                        CSV_GreenAmptSet = header_row.index("GreenAmptSet")
                        CSV_RichardsEquationSet = header_row.index("RichardsEquationSet")
                        CSV_ImperviousSet = header_row.index("ImperviousSet")
                        CSV_RoughnessSet = header_row.index("RoughnessSet")
                        CSV_PM_CropCoefSet = header_row.index("PM_CropCoefSet")
                        CSV_FillablePorositySet = header_row.index("FillablePorositySet")
                        CSV_ConductivitySet = header_row.index("ConductivitySet")
                        CSV_LeakageSet = header_row.index("LeakageSet")
                        CSV_TimeMarching = header_row.index("TimeMarching")
                        CSV_MaxIterations = header_row.index("MaxIterations")
                        CSV_OverRelaxWeightFactor = header_row.index("OverRelaxWeightFactor")
                        CSV_dZTolerance = header_row.index("dZTolerance")
                        CSV_Max_dZ = header_row.index("Max_dZ")
                        CSV_LinkOptimizerTolerance = header_row.index("LinkOptimizerTolerance")
                        CSV_EdgeLengthOption = header_row.index("EdgeLengthOption")
                        CSV_EdgeLengthFactor = header_row.index("EdgeLengthFactor")
                        CSV_DefaultDampThresh_2D = header_row.index("DefaultDampThresh_2D")
                        CSV_MinNodeSurfaceArea_2D = header_row.index("MinNodeSurfaceArea_2D")
                        CSV_EnergySwitch_2D = header_row.index("EnergySwitch_2D")
                        CSV_IARecoveryTime = header_row.index("IARecoveryTime")
                        CSV_IncludeETManualBasins = header_row.index("IncludeETManualBasins")
                        CSV_RichEqSolution = header_row.index("RichEqSolution")
                        CSV_RainfallOption_ManualBasin = header_row.index("RainfallOption_ManualBasin")
                        CSV_RainfallOption_OFRegion = header_row.index("RainfallOption_OFRegion")
                        CSV_RainfallName = header_row.index("RainfallName")
                        CSV_RainfallAmount = header_row.index("RainfallAmount")
                        CSV_StormDuration = header_row.index("StormDuration")
                        CSV_DefaultDampThresh_1D = header_row.index("DefaultDampThresh_1D")
                        CSV_MinNodeSurfaceArea_1D = header_row.index("MinNodeSurfaceArea_1D")
                        CSV_EnergySwitch_1D = header_row.index("EnergySwitch_1D")
                        CSV_EMCConstituentSet = header_row.index("EMCConstituentSet")
                        CSV_Ia_S = header_row.index("Ia_S")

                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_IID] = int(data[CSV_IID])
                        data[CSV_Execute] = int(data[CSV_Execute])
                        data[CSV_RunMode] = int(data[CSV_RunMode])
                        data[CSV_StartTime_Year] = int(data[CSV_StartTime_Year])
                        data[CSV_StartTime_Month] = int(data[CSV_StartTime_Month])
                        data[CSV_StartTime_Day] = int(data[CSV_StartTime_Day])
                        data[CSV_EndTime_Year] = int(data[CSV_EndTime_Year])
                        data[CSV_StartTime_Month] = int(data[CSV_StartTime_Month])
                        data[CSV_EndTime_Day] = int(data[CSV_EndTime_Day])
                        data[CSV_HotStartTime_Year] = int(data[CSV_HotStartTime_Year])
                        data[CSV_HotStartTime_Month] = int(data[CSV_HotStartTime_Month])
                        data[CSV_HotStartTime_Day] = int(data[CSV_HotStartTime_Day])
                        data[CSV_SaveRestart] = int(data[CSV_SaveRestart])
                        data[CSV_TimeMarching] = int(data[CSV_TimeMarching])
                        data[CSV_MaxIterations] = int(data[CSV_MaxIterations])
                        data[CSV_EdgeLengthOption] = int(data[CSV_EdgeLengthOption])
                        data[CSV_EnergySwitch_2D] = int(data[CSV_EnergySwitch_2D])
                        data[CSV_IncludeETManualBasins] = int(data[CSV_IncludeETManualBasins])
                        data[CSV_RainfallOption_ManualBasin] = int(data[CSV_RainfallOption_ManualBasin])
                        data[CSV_RainfallOption_OFRegion] = int(data[CSV_RainfallOption_OFRegion])
                        data[CSV_EnergySwitch_1D] = int(data[CSV_EnergySwitch_1D])
                        data[CSV_StartTime_Hour] = float(data[CSV_StartTime_Hour])
                        data[CSV_EndTime_Hour] = float(data[CSV_EndTime_Hour])
                        data[CSV_HotStartTime_Hour] = float(data[CSV_HotStartTime_Hour])
                        data[CSV_MinCalcTime_Hydrology] = float(data[CSV_MinCalcTime_Hydrology])
                        data[CSV_MinCalcTime_SurfHydraulics] = float(data[CSV_MinCalcTime_SurfHydraulics])
                        data[CSV_MinCalcTime_Groundwater] = float(data[CSV_MinCalcTime_Groundwater])
                        data[CSV_MaxCalcTime_SurfHydraulics] = float(data[CSV_MaxCalcTime_SurfHydraulics])
                        data[CSV_OverRelaxWeightFactor] = float(data[CSV_OverRelaxWeightFactor])
                        data[CSV_dZTolerance] = float(data[CSV_dZTolerance])
                        data[CSV_Max_dZ] = float(data[CSV_Max_dZ])
                        data[CSV_LinkOptimizerTolerance] = float(data[CSV_LinkOptimizerTolerance])
                        data[CSV_EdgeLengthFactor] = float(data[CSV_EdgeLengthFactor])
                        data[CSV_DefaultDampThresh_2D] = float(data[CSV_DefaultDampThresh_2D])
                        data[CSV_MinNodeSurfaceArea_2D] = float(data[CSV_MinNodeSurfaceArea_2D])
                        data[CSV_IARecoveryTime] = float(data[CSV_IARecoveryTime])
                        data[CSV_RainfallAmount] = float(data[CSV_RainfallAmount])
                        data[CSV_StormDuration] = float(data[CSV_StormDuration])
                        data[CSV_DefaultDampThresh_1D] = float(data[CSV_DefaultDampThresh_1D])
                        data[CSV_MinNodeSurfaceArea_1D] = float(data[CSV_MinNodeSurfaceArea_1D])
                        data[CSV_Ia_S] = float(data[CSV_Ia_S])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpate:

                                row[GDB_IID] = data[CSV_IID]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_RunMode] = data[CSV_RunMode]
                                row[GDB_HotStartSimulation] = data[CSV_HotStartSimulation]
                                row[GDB_StartTime_Year] = data[CSV_StartTime_Year]
                                row[GDB_StartTime_Month] = data[CSV_StartTime_Month]
                                row[GDB_StartTime_Day] = data[CSV_StartTime_Day]
                                row[GDB_StartTime_Hour] = data[CSV_StartTime_Hour]
                                row[GDB_EndTime_Year] = data[CSV_EndTime_Year]
                                row[GDB_EndTime_Month] = data[CSV_EndTime_Month]
                                row[GDB_EndTime_Day] = data[CSV_EndTime_Day]
                                row[GDB_EndTime_Hour] = data[CSV_EndTime_Hour]
                                row[GDB_HotStartTime_Year] = data[CSV_HotStartTime_Year]
                                row[GDB_HotStartTime_Month] = data[CSV_HotStartTime_Month]
                                row[GDB_HotStartTime_Day] = data[CSV_HotStartTime_Day]
                                row[GDB_HotStartTime_Hour] = data[CSV_HotStartTime_Hour]
                                row[GDB_MinCalcTime_Hydrology] = data[CSV_MinCalcTime_Hydrology]
                                row[GDB_MinCalcTime_SurfHydraulics] = data[CSV_MinCalcTime_SurfHydraulics]
                                row[GDB_MinCalcTime_Groundwater] = data[CSV_MinCalcTime_Groundwater]
                                row[GDB_MaxCalcTime_SurfHydraulics] = data[CSV_MaxCalcTime_SurfHydraulics]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_SaveRestart] = data[CSV_SaveRestart]
                                row[GDB_RainfallSet] = data[CSV_RainfallSet]
                                row[GDB_PM_ReferenceETSet] = data[CSV_PM_ReferenceETSet]
                                row[GDB_UnitHydrographSet] = data[CSV_UnitHydrographSet]
                                row[GDB_BoundaryStageSet] = data[CSV_BoundaryStageSet]
                                row[GDB_ExternalHydrographSet] = data[CSV_ExternalHydrographSet]
                                row[GDB_CurveNumberSet] = data[CSV_CurveNumberSet]
                                row[GDB_GreenAmptSet] = data[CSV_GreenAmptSet]
                                row[GDB_RichardsEquationSet] = data[CSV_RichardsEquationSet]
                                row[GDB_ImperviousSet] = data[CSV_ImperviousSet]
                                row[GDB_RoughnessSet] = data[CSV_RoughnessSet]
                                row[GDB_PM_CropCoefSet] = data[CSV_PM_CropCoefSet]
                                row[GDB_FillablePorositySet] = data[CSV_FillablePorositySet]
                                row[GDB_ConductivitySet] = data[CSV_ConductivitySet]
                                row[GDB_LeakageSet] = data[CSV_LeakageSet]
                                row[GDB_TimeMarching] = data[CSV_TimeMarching]
                                row[GDB_MaxIterations] = data[CSV_MaxIterations]
                                row[GDB_OverRelaxWeightFactor] = data[CSV_OverRelaxWeightFactor]
                                row[GDB_dZTolerance] = data[CSV_dZTolerance]
                                row[GDB_Max_dZ] = data[CSV_Max_dZ]
                                row[GDB_LinkOptimizerTolerance] = data[CSV_LinkOptimizerTolerance]
                                row[GDB_EdgeLengthOption] = data[CSV_EdgeLengthOption]
                                row[GDB_EdgeLengthFactor] = data[CSV_EdgeLengthFactor]
                                row[GDB_DefaultDampThresh_2D] = data[CSV_DefaultDampThresh_2D]
                                row[GDB_MinNodeSurfaceArea_2D] = data[CSV_MinNodeSurfaceArea_2D]
                                row[GDB_EnergySwitch_2D] = data[CSV_EnergySwitch_2D]
                                row[GDB_IARecoveryTime] = data[CSV_IARecoveryTime]
                                row[GDB_IncludeETManualBasins] = data[CSV_IncludeETManualBasins]
                                row[GDB_RainfallOption_ManualBasin] = data[CSV_RainfallOption_ManualBasin]
                                row[GDB_RainfallOption_OFRegion] = data[CSV_RainfallOption_OFRegion]
                                row[GDB_RainfallName] = data[CSV_RainfallName]
                                row[GDB_RainfallAmount] = data[CSV_RainfallAmount]
                                row[GDB_StormDuration] = data[CSV_StormDuration]
                                row[GDB_DefaultDampThresh_1D] = data[CSV_DefaultDampThresh_1D]
                                row[GDB_MinNodeSurfaceArea_1D] = data[CSV_MinNodeSurfaceArea_1D]
                                row[GDB_EnergySwitch_1D] = data[CSV_EnergySwitch_1D]        
                                row[GDB_Scenario] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_EMCConstituentSet] = data[CSV_EMCConstituentSet] 
                                row[GBD_Ia_S] = data[CSV_Ia_S]
                                                                                   
                                #update row
                                cursorUpate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpate                           
                                

                        #Add new data
                        else:
                              
                            IID = data[CSV_IID]
                            ICPR_GUID = data[CSV_ID]
                            Name = data[CSV_Name]
                            RunMode = data[CSV_RunMode]
                            HotStartSimulation = data[CSV_HotStartSimulation]
                            StartTime_Year = data[CSV_StartTime_Year]
                            StartTime_Month = data[CSV_StartTime_Month]
                            StartTime_Day = data[CSV_StartTime_Day]
                            StartTime_Hour = data[CSV_StartTime_Hour]
                            EndTime_Year = data[CSV_EndTime_Year]
                            EndTime_Month = data[CSV_EndTime_Month]
                            EndTime_Day = data[CSV_EndTime_Day]
                            EndTime_Hour = data[CSV_EndTime_Hour]
                            HotStartTime_Year = data[CSV_HotStartTime_Year]
                            HotStartTime_Month = data[CSV_HotStartTime_Month]
                            HotStartTime_Day = data[CSV_HotStartTime_Day]
                            HotStartTime_Hour = data[CSV_HotStartTime_Hour]
                            MinCalcTime_Hydrology = data[CSV_MinCalcTime_Hydrology]
                            MinCalcTime_SurfHydraulics = data[CSV_MinCalcTime_SurfHydraulics]
                            MinCalcTime_Groundwater = data[CSV_MinCalcTime_Groundwater]
                            MaxCalcTime_SurfHydraulics = data[CSV_MaxCalcTime_SurfHydraulics]
                            Comment = data[CSV_Comment]
                            SaveRestart = data[CSV_SaveRestart]
                            RainfallSet = data[CSV_RainfallSet]
                            PM_ReferenceETSet = data[CSV_PM_ReferenceETSet]
                            UnitHydrographSet = data[CSV_UnitHydrographSet]
                            BoundaryStageSet = data[CSV_BoundaryStageSet]
                            ExternalHydrographSet = data[CSV_ExternalHydrographSet]
                            CurveNumberSet = data[CSV_CurveNumberSet]
                            GreenAmptSet = data[CSV_GreenAmptSet]
                            RichardsEquationSet = data[CSV_RichardsEquationSet]
                            ImperviousSet = data[CSV_ImperviousSet]
                            RoughnessSet = data[CSV_RoughnessSet]
                            PM_CropCoefSet = data[CSV_PM_CropCoefSet]
                            FillablePorositySet = data[CSV_FillablePorositySet]
                            ConductivitySet = data[CSV_ConductivitySet]
                            LeakageSet = data[CSV_LeakageSet]
                            TimeMarching = data[CSV_TimeMarching]
                            MaxIterations = data[CSV_MaxIterations]
                            OverRelaxWeightFactor = data[CSV_OverRelaxWeightFactor]
                            dZTolerance = data[CSV_dZTolerance]
                            Max_dZ = data[CSV_Max_dZ]
                            LinkOptimizerTolerance = data[CSV_LinkOptimizerTolerance]
                            EdgeLengthOption = data[CSV_EdgeLengthOption]
                            EdgeLengthFactor = data[CSV_EdgeLengthFactor]
                            DefaultDampThresh_2D = data[CSV_DefaultDampThresh_2D]
                            MinNodeSurfaceArea_2D = data[CSV_MinNodeSurfaceArea_2D]
                            EnergySwitch_2D = data[CSV_EnergySwitch_2D]
                            IARecoveryTime = data[CSV_IARecoveryTime]
                            IncludeETManualBasins = data[CSV_IncludeETManualBasins]
                            RainfallOption_ManualBasin = data[CSV_RainfallOption_ManualBasin]
                            RainfallOption_OFRegion = data[CSV_RainfallOption_OFRegion]
                            RainfallName = data[CSV_RainfallName]
                            RainfallAmount = data[CSV_RainfallAmount]
                            StormDuration = data[CSV_StormDuration]
                            DefaultDampThresh_1D = data[CSV_DefaultDampThresh_1D]
                            MinNodeSurfaceArea_1D = data[CSV_MinNodeSurfaceArea_1D]
                            EnergySwitch_1D = data[CSV_EnergySwitch_1D]        
                            Scenario = ScenDict[data[CSV_ParentID]][1]
                            EMCConstituentSet = data[CSV_EMCConstituentSet]
                            Ia_S = data[CSV_Ia_S]

                            In_Data = (IID,
                                       ICPR_GUID,
                                       Name,
                                       RunMode,
                                       HotStartSimulation,
                                       StartTime_Year,
                                       StartTime_Month,
                                       StartTime_Day,
                                       StartTime_Hour,
                                       EndTime_Year,
                                       EndTime_Month,
                                       EndTime_Day,
                                       EndTime_Hour,
                                       HotStartTime_Year,
                                       HotStartTime_Month,
                                       HotStartTime_Day,
                                       HotStartTime_Hour,
                                       MinCalcTime_Hydrology,
                                       MinCalcTime_SurfHydraulics,
                                       MinCalcTime_Groundwater,
                                       MaxCalcTime_SurfHydraulics,
                                       Comment,
                                       SaveRestart,
                                       RainfallSet,
                                       PM_ReferenceETSet,
                                       UnitHydrographSet,
                                       BoundaryStageSet,
                                       ExternalHydrographSet,
                                       CurveNumberSet,
                                       GreenAmptSet,
                                       RichardsEquationSet,
                                       ImperviousSet,
                                       RoughnessSet,
                                       PM_CropCoefSet,
                                       FillablePorositySet,
                                       ConductivitySet,
                                       LeakageSet,
                                       TimeMarching,
                                       MaxIterations,
                                       OverRelaxWeightFactor,
                                       dZTolerance,
                                       Max_dZ,
                                       LinkOptimizerTolerance,
                                       EdgeLengthOption,
                                       EdgeLengthFactor,
                                       DefaultDampThresh_2D,
                                       MinNodeSurfaceArea_2D,
                                       EnergySwitch_2D,
                                       IARecoveryTime,
                                       IncludeETManualBasins,
                                       RainfallOption_ManualBasin,
                                       RainfallOption_OFRegion,
                                       RainfallName,
                                       RainfallAmount,
                                       StormDuration,
                                       DefaultDampThresh_1D,
                                       MinNodeSurfaceArea_1D,
                                       EnergySwitch_1D,
                                       Scenario,
                                       EMCConstituentSet,
                                       Ia_S)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                
        #Cycle through all data to delete values if required
        try:        
            if Merge == False:
                
                cursor = arcpy.da.UpdateCursor(outfc, fields)
                
                for row in cursor:
                    
                    if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                        cursor.deleteRow()

                del cursor

        except:
            
            arcpy.GetMessages()

    ##########################################################################################################################
    #Groundwater - Update attribute table data
    ##########################################################################################################################
        try:
            
            #Output
            outfc = "ICPR4_SimOutputGroundwater"    

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Sim_Output_TInc_Groundwater.csv"        
            

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
                
            except:
                
                pass
            
            #Delete table data to repopulate
            try:
                arcpy.DeleteRows_management(outfc)
            except:
                pass
            
            #Fields for update of existing elements/features
            fields = ['Year',
                      'Month',
                      'Day',
                      'Hour',
                      'TimeIncrement',
                      'Simulation',
                      'ICPR_GUID']                  

                      
            #List index
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_Hour = fields.index('Hour')
            GDB_TimeIncrement = fields.index('TimeIncrement')
            GDB_Simulation = fields.index('Simulation')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            #Get path to implement edit session
            ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
            desc = arcpy.Describe(outfc)
            path = desc.path
            del desc
        
            with arcpy.da.Editor(path)as edit:

                #Read CSV Data           
                with open(infc,'r') as csv_file:
                    first = True
                    cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                    for line in csv_file:
                        if first== True:
                            first = False

                            header_row = iccsv.csv_parseline(line)
                            
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Year = header_row.index("Year")
                            CSV_Month = header_row.index("Month")
                            CSV_Day = header_row.index("Day")
                            CSV_Hour = header_row.index("Hour")
                            CSV_TimeIncrement = header_row.index("TimeIncrement")
                            
                        else:
                            
                            data = iccsv.csv_parseline(line)

                            #Data
                            data[CSV_Year] =  int(data[CSV_Year])
                            data[CSV_Month] =  int(data[CSV_Month])
                            data[CSV_Day] =  int(data[CSV_Day])
                            data[CSV_Hour] =  float(data[CSV_Hour])
                            data[CSV_TimeIncrement] =  float(data[CSV_TimeIncrement])
                            
                            #Create where clause
                            expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                        
                            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                 
                            #Determine is cursor is empty
                            i = 0
                            for row in cursorUpdate:
                                i = i + 1
                                if i >=1:
                                    break
                                    
                            #Reset cursor
                            cursorUpdate.reset()

                            #If cursor has data update data
                            if i!=0:

                                for row in cursorUpdate:

                                    #Assign Name
                                    try:                                
                                        row[GDB_Simulation] = AddDict[data[CSV_ParentID]][1]

                                    except:
                                        row[GDB_Simulation] = UpDict[data[CSV_ParentID]][1]
                                        
                                    row[GDB_Year] = data[CSV_Year]
                                    row[GDB_Month] = data[CSV_Month]
                                    row[GDB_Day] = data[CSV_Day]
                                    row[GDB_Hour] = data[CSV_Hour]
                                    row[GDB_TimeIncrement] = data[CSV_TimeIncrement]
                                    row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                       
                                    #update row
                                    cursorUpdate.updateRow(row)

                                del cursorUpdate                           
                                    

                            #Add new data
                            else:
                                
                                #Assign Name
                                try:                                
                                    Simulation = AddDict[data[CSV_ParentID]][1]

                                except:
                                    Simulation = UpDict[data[CSV_ParentID]][1]
                                    
                                Year = data[CSV_Year]
                                Month = data[CSV_Month]
                                Day = data[CSV_Day]
                                Hour = data[CSV_Hour]
                                TimeIncrement = data[CSV_TimeIncrement]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = (Year,
                                           Month,
                                           Day,
                                           Hour,
                                           TimeIncrement,
                                           Simulation,
                                           ICPR_GUID)   

                                #Insert new record                        
                                cursorInsert.insertRow(In_Data)          
                    del cursorInsert
                            
        except:

            arcpy.GetMessages()

    ##########################################################################################################################
    #Hydrology - Update attribute table data
    ##########################################################################################################################
        try:
            
            #Output
            outfc = "ICPR4_SimOutputHydrology"    

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Sim_Output_TInc_Hydrology.csv"        
            

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
                
            except:
                
                pass
            
            #Delete table data to repopulate
            try:
                arcpy.DeleteRows_management(outfc)
            except:
                pass
            
            #Fields for update of existing elements/features
            fields = ['Year',
                      'Month',
                      'Day',
                      'Hour',
                      'TimeIncrement',
                      'Simulation',
                      'ICPR_GUID']                  

                      
            #List index
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_Hour = fields.index('Hour')
            GDB_TimeIncrement = fields.index('TimeIncrement')
            GDB_Simulation = fields.index('Simulation')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Get path to implement edit session
            ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
            desc = arcpy.Describe(outfc)
            path = desc.path
            del desc
        
            with arcpy.da.Editor(path)as edit:

                #Read CSV Data           
                with open(infc,'r') as csv_file:
                    first = True
                    cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                    for line in csv_file:
                        if first== True:
                            first = False

                            header_row = iccsv.csv_parseline(line)
                            
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Year = header_row.index("Year")
                            CSV_Month = header_row.index("Month")
                            CSV_Day = header_row.index("Day")
                            CSV_Hour = header_row.index("Hour")
                            CSV_TimeIncrement = header_row.index("TimeIncrement")
                            
                        else:
                            
                            data = iccsv.csv_parseline(line)

                            #Data
                            data[CSV_Year] =  int(data[CSV_Year])
                            data[CSV_Month] =  int(data[CSV_Month])
                            data[CSV_Day] =  int(data[CSV_Day])
                            data[CSV_Hour] =  float(data[CSV_Hour])
                            data[CSV_TimeIncrement] =  float(data[CSV_TimeIncrement])
                            
                            #Create where clause
                            expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                        
                            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                 
                            #Determine is cursor is empty
                            i = 0
                            for row in cursorUpdate:
                                i = i + 1
                                if i >=1:
                                    break
                                    
                            #Reset cursor
                            cursorUpdate.reset()

                            #If cursor has data update data
                            if i!=0:

                                for row in cursorUpdate:

                                    #Assign Name
                                    try:                                
                                        row[GDB_Simulation] = AddDict[data[CSV_ParentID]][1]

                                    except:
                                        row[GDB_Simulation] = UpDict[data[CSV_ParentID]][1]
                                        
                                    row[GDB_Year] = data[CSV_Year]
                                    row[GDB_Month] = data[CSV_Month]
                                    row[GDB_Day] = data[CSV_Day]
                                    row[GDB_Hour] = data[CSV_Hour]
                                    row[GDB_TimeIncrement] = data[CSV_TimeIncrement]
                                    row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                       
                                    #update row
                                    cursorUpdate.updateRow(row)

                                del cursorUpdate                           
                                    

                            #Add new data
                            else:
                                
                                #Assign Name
                                try:                                
                                    Simulation = AddDict[data[CSV_ParentID]][1]

                                except:
                                    Simulation = UpDict[data[CSV_ParentID]][1]
                                    
                                Year = data[CSV_Year]
                                Month = data[CSV_Month]
                                Day = data[CSV_Day]
                                Hour = data[CSV_Hour]
                                TimeIncrement = data[CSV_TimeIncrement]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = (Year,
                                           Month,
                                           Day,
                                           Hour,
                                           TimeIncrement,
                                           Simulation,
                                           ICPR_GUID)   

                                #Insert new record                        
                                cursorInsert.insertRow(In_Data)          
                    del cursorInsert
                            
        except:

            arcpy.GetMessages()

    ##########################################################################################################################
    #Restart - Update attribute table data
    ##########################################################################################################################
        try:
            
            #Output
            outfc = "ICPR4_SimOutputRestart"    

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Sim_Output_TInc_RestartFile.csv"        
            

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
                
            except:
                
                pass
            
            #Delete table data to repopulate
            try:
                arcpy.DeleteRows_management(outfc)
            except:
                pass
            
            #Fields for update of existing elements/features
            fields = ['Year',
                      'Month',
                      'Day',
                      'Hour',
                      'TimeIncrement',
                      'Simulation',
                      'ICPR_GUID']                  

                      
            #List index
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_Hour = fields.index('Hour')
            GDB_TimeIncrement = fields.index('TimeIncrement')
            GDB_Simulation = fields.index('Simulation')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Get path to implement edit session
            ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
            desc = arcpy.Describe(outfc)
            path = desc.path
            del desc
            
            with arcpy.da.Editor(path)as edit:

                #Read CSV Data           
                with open(infc,'r') as csv_file:
                    first = True
                    cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                    for line in csv_file:
                        if first== True:
                            first = False

                            header_row = iccsv.csv_parseline(line)
                            
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Year = header_row.index("Year")
                            CSV_Month = header_row.index("Month")
                            CSV_Day = header_row.index("Day")
                            CSV_Hour = header_row.index("Hour")
                            CSV_TimeIncrement = header_row.index("TimeIncrement")
                            
                        else:
                            
                            data = iccsv.csv_parseline(line)

                            #Data
                            data[CSV_Year] =  int(data[CSV_Year])
                            data[CSV_Month] =  int(data[CSV_Month])
                            data[CSV_Day] =  int(data[CSV_Day])
                            data[CSV_Hour] =  float(data[CSV_Hour])
                            data[CSV_TimeIncrement] =  float(data[CSV_TimeIncrement])
                            
                            #Create where clause
                            expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                        
                            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                 
                            #Determine is cursor is empty
                            i = 0
                            for row in cursorUpdate:
                                i = i + 1
                                if i >=1:
                                    break
                                    
                            #Reset cursor
                            cursorUpdate.reset()

                            #If cursor has data update data
                            if i!=0:

                                for row in cursorUpdate:

                                    #Assign Name
                                    try:                                
                                        row[GDB_Simulation] = AddDict[data[CSV_ParentID]][1]

                                    except:
                                        row[GDB_Simulation] = UpDict[data[CSV_ParentID]][1]
                                        
                                    row[GDB_Year] = data[CSV_Year]
                                    row[GDB_Month] = data[CSV_Month]
                                    row[GDB_Day] = data[CSV_Day]
                                    row[GDB_Hour] = data[CSV_Hour]
                                    row[GDB_TimeIncrement] = data[CSV_TimeIncrement]
                                    row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                       
                                    #update row
                                    cursorUpdate.updateRow(row)

                                del cursorUpdate                           
                                    

                            #Add new data
                            else:
                                
                                #Assign Name
                                try:                                
                                    Simulation = AddDict[data[CSV_ParentID]][1]

                                except:
                                    Simulation = UpDict[data[CSV_ParentID]][1]
                                    
                                Year = data[CSV_Year]
                                Month = data[CSV_Month]
                                Day = data[CSV_Day]
                                Hour = data[CSV_Hour]
                                TimeIncrement = data[CSV_TimeIncrement]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = (Year,
                                           Month,
                                           Day,
                                           Hour,
                                           TimeIncrement,
                                           Simulation,
                                           ICPR_GUID)   

                                #Insert new record                        
                                cursorInsert.insertRow(In_Data)          
                    del cursorInsert
                            
        except:

            arcpy.GetMessages()

    ##########################################################################################################################
    #Surface Hydraulics - Update attribute table data
    ##########################################################################################################################
        try:
            
            #Output
            outfc = "ICPR4_SimOutputSurfHydraulics"    

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Sim_Output_TInc_SurfHydraulics.csv"        
            

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
                
            except:
                
                pass
            
            #Delete table data to repopulate
            try:
                arcpy.DeleteRows_management(outfc)
            except:
                pass
            
            #Fields for update of existing elements/features
            fields = ['Year',
                      'Month',
                      'Day',
                      'Hour',
                      'TimeIncrement',
                      'Simulation',
                      'ICPR_GUID']                  

                      
            #List index
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_Hour = fields.index('Hour')
            GDB_TimeIncrement = fields.index('TimeIncrement')
            GDB_Simulation = fields.index('Simulation')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Get path to implement edit session
            ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
            desc = arcpy.Describe(outfc)
            path = desc.path
            del desc
            
            with arcpy.da.Editor(path)as edit:

                #Read CSV Data           
                with open(infc,'r') as csv_file:
                    first = True
                    cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                    for line in csv_file:
                        if first== True:
                            first = False

                            header_row = iccsv.csv_parseline(line)
                            
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Year = header_row.index("Year")
                            CSV_Month = header_row.index("Month")
                            CSV_Day = header_row.index("Day")
                            CSV_Hour = header_row.index("Hour")
                            CSV_TimeIncrement = header_row.index("TimeIncrement")
                            
                        else:
                            
                            data = iccsv.csv_parseline(line)

                            #Data
                            data[CSV_Year] =  int(data[CSV_Year])
                            data[CSV_Month] =  int(data[CSV_Month])
                            data[CSV_Day] =  int(data[CSV_Day])
                            data[CSV_Hour] =  float(data[CSV_Hour])
                            data[CSV_TimeIncrement] =  float(data[CSV_TimeIncrement])
                            
                            #Create where clause
                            expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                        
                            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                 
                            #Determine is cursor is empty
                            i = 0
                            for row in cursorUpdate:
                                i = i + 1
                                if i >=1:
                                    break
                                    
                            #Reset cursor
                            cursorUpdate.reset()

                            #If cursor has data update data
                            if i!=0:

                                for row in cursorUpdate:

                                    #Assign Name
                                    try:                                
                                        row[GDB_Simulation] = AddDict[data[CSV_ParentID]][1]

                                    except:
                                        row[GDB_Simulation] = UpDict[data[CSV_ParentID]][1]
                                        
                                    row[GDB_Year] = data[CSV_Year]
                                    row[GDB_Month] = data[CSV_Month]
                                    row[GDB_Day] = data[CSV_Day]
                                    row[GDB_Hour] = data[CSV_Hour]
                                    row[GDB_TimeIncrement] = data[CSV_TimeIncrement]
                                    row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                       
                                    #update row
                                    cursorUpdate.updateRow(row)

                                del cursorUpdate                           
                                    

                            #Add new data
                            else:
                                
                                #Assign Name
                                try:                                
                                    Simulation = AddDict[data[CSV_ParentID]][1]

                                except:
                                    Simulation = UpDict[data[CSV_ParentID]][1]
                                    
                                Year = data[CSV_Year]
                                Month = data[CSV_Month]
                                Day = data[CSV_Day]
                                Hour = data[CSV_Hour]
                                TimeIncrement = data[CSV_TimeIncrement]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = (Year,
                                           Month,
                                           Day,
                                           Hour,
                                           TimeIncrement,
                                           Simulation,
                                           ICPR_GUID)   

                                #Insert new record                        
                                cursorInsert.insertRow(In_Data)          
                    del cursorInsert
                            
        except:

            arcpy.GetMessages()
            
            
    except:
        arcpy.GetMessages()
