#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_Roughness(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
            
        #Output
        outfc = "ICPR4_ROUGHNESS_SET"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RoughnessSet.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Name',
                  'Comment',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Comment = fields.index('Comment')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            Comment = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (Name,
                                       Comment,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                    
    except:

        arcpy.GetMessages()

            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_ROUGHNESS_ZONES"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RoughnessSet_Roughness.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['RoughnessZone',
                      'ShallowManningsN',
                      'DeepManningsN',
                      'DepthRange',
                      'DampeningThreshold',
                      'AreaReductionFactor',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_RoughnessZone = fields.index('RoughnessZone')
            GDB_ShallowManningsN = fields.index('ShallowManningsN')
            GDB_DeepManningsN = fields.index('DeepManningsN')
            GDB_DepthRange = fields.index('DepthRange')
            GDB_DampeningThreshold = fields.index('DampeningThreshold')
            GDB_AreaReductionFactor = fields.index('AreaReductionFactor')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")                        
                        CSV_RoughnessZone = header_row.index("RoughnessZone")
                        CSV_ShallowManningsN = header_row.index("ShallowManningsN")
                        CSV_DeepManningsN = header_row.index("DeepManningsN")
                        CSV_DepthRange = header_row.index("DepthRange")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_AreaReductionFactor = header_row.index("AreaReductionFactor")
                        
                    else:

                        data = iccsv.csv_parseline(line)

                        #Data
                        data[CSV_ShallowManningsN] = float(data[CSV_ShallowManningsN])
                        data[CSV_DeepManningsN] = float(data[CSV_DeepManningsN])
                        data[CSV_DepthRange] = float(data[CSV_DepthRange])
                        data[CSV_AreaReductionFactor] = float(data[CSV_AreaReductionFactor])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]

                        RoughnessZone = data[CSV_RoughnessZone]
                        ShallowManningsN = data[CSV_ShallowManningsN]
                        DeepManningsN = data[CSV_DeepManningsN]
                        DepthRange = data[CSV_DepthRange]
                        DampeningThreshold = data[CSV_DampeningThreshold]
                        AreaReductionFactor = data[CSV_AreaReductionFactor]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (RoughnessZone,
                                   ShallowManningsN,
                                   DeepManningsN,
                                   DepthRange,
                                   DampeningThreshold,
                                   AreaReductionFactor,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert

        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
