#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_OF_CCV(infc1, Merge, Filestem, OF_AddDict, OF_UpDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
            
        #Output
        outfc = "OF_ChannelControlVolume"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_ChannelControlVolume.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Name',
                  'Node',
                  'Comment',
                  'OverlandFlowRegion',
                  'Interpolate',
                  'ICPR_GUID']      
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Node = fields.index('Node')
        GDB_Comment = fields.index('Comment')
        GDB_OverlandFlowRegion = fields.index('OverlandFlowRegion')
        GDB_Interpolate = fields.index('Interpolate')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                            
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Node = header_row.index("Node")
                        CSV_Interpolate = header_row.index("Interpolate")
                        CSV_Comment = header_row.index("Comment")

                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Data Types
                        data[CSV_Interpolate] = int(data[CSV_Interpolate])
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Node] = data[CSV_Node]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_Interpolate] = data[CSV_Interpolate]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #Region Name
                                try:
                                    row[GDB_OverlandFlowRegion] = OF_AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_OverlandFlowRegion] = OF_UpDict[data[CSV_ParentID]][1]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name],row[GDB_OverlandFlowRegion]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            Node = data[CSV_Node]
                            Comment = data[CSV_Comment]
                            Interpolate = data[CSV_Interpolate]
                            ICPR_GUID = data[CSV_ID]

                            #Region Name
                            try:
                                OverlandFlowRegion = OF_AddDict[data[CSV_ParentID]][1]
                            except:
                                OverlandFlowRegion = OF_UpDict[data[CSV_ParentID]][1]

                            In_Data = (Name,
                                       Node,
                                       Comment,
                                       OverlandFlowRegion,
                                       Interpolate,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name],OverlandFlowRegion]          
                del cursorInsert
            
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:
        
        #Output
        outfc = "OF_ChannelControlVolume"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_ChannelControlVolume_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:
        
            #Flags for feature geometry data
            Pnts_done = False
            Pnts = []
            Guid_Old = None
            GeomDict = {}#geometry dicationary            
            
            with open(infc,'r') as csv_file:
                first = True
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex = header_row.index("Vertex")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        Guid_New = data[CSV_ParentID]
                        
                        #Initialize old GUID.  Only happens during the first pass.
                        if Guid_Old == None:
                            Guid_Old = data[CSV_ParentID]
                        
                        #Check if point array is done
                        if Guid_Old != Guid_New:                                                     
                            
                            GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                            Guid_Old = Guid_New #Reset old GUID
                            Pnts = [] #Empty array
                            
                            
                        
                        #Create point
                        pnt = (data[CSV_X],data[CSV_Y])
                        Pnts.append(pnt)                                
        
            #Add last record to dictionary
            GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.           
            
        except:
        
            arcpy.GetMessages()
        
        #Write geometry data to feature class           
        fields = ['ICPR_GUID',
                  'Shape@']

        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPE = fields.index('Shape@')
        
        cursorUpdate = arcpy.da.UpdateCursor(outfc,fields)       
        for row in cursorUpdate:
            try:
                Guid = row[GDB_ICPR_GUID]
                Geom = GeomDict[Guid]
                
                #add geometry
                row[GDB_SHAPE] = Geom
                cursorUpdate.updateRow(row)
                
            except:
                continue

        del cursorUpdate

    except:
        arcpy.GetMessages()

###############
#COVE LINES
###############
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
            
        #Output
        outfc = "OF_Cove"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_ChannelControlVolume_Cove.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete existing information
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Fields for update of existing elements/features
        fields = ['ControlVolumeName',
                  'OverlandFlowRegion',
                  'CoveName',
                  'ICPR_GUID']

        #Create dictionary
        CoveDict = {}
                  
        #List index
        GDB_ControlVolumeName = fields.index('ControlVolumeName')
        GDB_OverlandFlowRegion = fields.index('OverlandFlowRegion')
        GDB_CoveName = fields.index('CoveName')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:
            #Read CSV Data    
            
            with open(infc,'r') as csv_file:
                first = True                
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                            
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")                
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex_From = header_row.index("Vertex_From")
                        CSV_Vertex_To = header_row.index("Vertex_To")
                        CSV_Link_Connection_X = header_row.index("Link_Connection_X")
                        CSV_Link_Connection_Y = header_row.index("Link_Connection_Y")
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Data Types
                        data[CSV_Vertex_From] = int(data[CSV_Vertex_From])
                        data[CSV_Vertex_To] = int(data[CSV_Vertex_To])
                        data[CSV_Link_Connection_X] = float(data[CSV_Link_Connection_X])
                        data[CSV_Link_Connection_Y] = float(data[CSV_Link_Connection_Y])
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                #Cove name identical to GUID for unique name
                                row[GDB_CoveName] = data[CSV_ID]
                                row[GDB_ICPR_GUID] = data[CSV_ID]


                                #Region Name
                                try:
                                    row[GDB_OverlandFlowRegion] = AddDict[data[CSV_ParentID]][2]
                                except:
                                    row[GDB_OverlandFlowRegion] = UpDict[data[CSV_ParentID]][2]

                                #Control Volume Name
                                try:
                                    row[GDB_ControlVolumeName] = AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_ControlVolumeName] = UpDict[data[CSV_ParentID]][1]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Cove Dictionary
                                CoveDict[data[CSV_ID]] = [data[CSV_ParentID],
                                                          data[CSV_Link_Connection_X],
                                                          data[CSV_Link_Connection_Y],
                                                          data[CSV_Vertex_From],
                                                          data[CSV_Vertex_To],
                                                          data[CSV_ID]] 
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            #Cove name identical to GUID for unique name
                            CoveName = data[CSV_ID]
                            ICPR_GUID = data[CSV_ID]

                            #Region Name
                            try:
                                OverlandFlowRegion = AddDict[data[CSV_ParentID]][2]                        
                            except:                        
                                OverlandFlowRegion = UpDict[data[CSV_ParentID]][2]

                            #Control Volume Name
                            try:
                                ControlVolumeName = AddDict[data[CSV_ParentID]][1]
                            except:
                                ControlVolumeName = UpDict[data[CSV_ParentID]][1]

                            In_Data = (ControlVolumeName,
                                       OverlandFlowRegion,
                                       CoveName,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Cove Dictionary
                            CoveDict[data[CSV_ID]] = [data[CSV_ParentID],
                                                      data[CSV_Link_Connection_X],
                                                      data[CSV_Link_Connection_Y],
                                                      data[CSV_Vertex_From],
                                                      data[CSV_Vertex_To],
                                                      data[CSV_ID]]      
                del cursorInsert
        
    except:

        arcpy.GetMessages()            

############################################################################################################################
###Populated Geometry
############################################################################################################################
    try:
        
        #Output
        outfc = "OF_Cove"    

        #Input
        infc = "OF_ChannelControlVolume" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            arcpy.SelectLayerByAttribute_management(OF_ChannelControlVolume, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:
            
            #Append spatial data
            fields = ['ICPR_GUID',
                      'Shape@']

            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            GDB_SHAPE = fields.index('Shape@')          

            Coves = CoveDict.keys()

            for Cove in Coves:
                
                expression = "ICPR_GUID" + " = " + "'" + CoveDict[Cove][0] + "'"

                #Vertex Number
                i = 0

                #Create point list
                Pnts = []
                for row in arcpy.da.SearchCursor(infc,fields,
                                                 where_clause = expression,
                                                 sql_clause = (None, 'ORDER BY ICPR_GUID')):
                    for part in row[1]:
                        for pnt in part:

                            x = pnt.X
                            y = pnt.Y
                            InData = (i,x,y)
                            Pnts.append(InData)
                            i = i + 1
                    
                if CoveDict[Cove][3] < CoveDict[Cove][4]:

                    #Empty Point List
                    FPnts = []
                    
                    for row in Pnts:

                        if row[0]>=CoveDict[Cove][3] and row[0]<= CoveDict[Cove][4]:

                            XY = (row[1],row[2])
                            FPnts.append(XY)

                else:
                    
                    #Empty Point List
                    SPnts = []
                    EPnts = []
                    FPnts = []
                                        
                    for row in Pnts:
                        #Start List
                        if row[0]>=CoveDict[Cove][3]:

                            XY = (row[1],row[2])
                            SPnts.append(XY)
                            
                        #End List
                        if row[0] <= CoveDict[Cove][4]:

                            XY = (row[1],row[2])
                            EPnts.append(XY)

                    FPnts = SPnts + EPnts

                #Add spatial data to Cove Lines
                expression = "ICPR_GUID" + " = " + "'" + CoveDict[Cove][5] + "'"
                cursorUpdate = arcpy.da.UpdateCursor(outfc,fields,
                                               where_clause = expression,
                                               sql_clause = (None, 'ORDER BY ICPR_GUID'))                
                for row in cursorUpdate:
                    
                    row[1] = FPnts
                    #update if geometry data is valid
                    try:
                        cursorUpdate.updateRow(row)
                    except:
                        pass
                    
                del cursorUpdate
        except:
            arcpy.GetMessages()
                
    except:
        arcpy.GetMessages()


###############
#COVE Points
###############
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
            
        #Output
        outfc = "OF_Cove_Point"         
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete existing information
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Fields for update of existing elements/features
        fields = ['CoveName',
                  'ICPR_GUID',
                  'Shape@']                 
                  
        cursorInsert = arcpy.da.InsertCursor(outfc, fields)          

        for key in CoveDict:

            CoveName = CoveDict[key][5]
            ICPR_GUID = CoveName
            X = float(CoveDict[key][1])
            Y = float(CoveDict[key][2])
            Shape = (X,Y)
                           
            
            In_Data = (CoveName,
                       ICPR_GUID,
                       Shape)   

            #Insert new record                        
            cursorInsert.insertRow(In_Data) 
   
        del cursorInsert
    
    except:

        arcpy.GetMessages()            

                
                            
  
