#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_OFWeirs(infc1, Merge, Filestem, OF_AddDict, OF_UpDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_OF_Weir"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_Weir.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Name',
                  'WeirType',
                  'WeirDischargeCoef',
                  'HorizontalOffset',
                  'Comment',
                  'IsUpstreamRight',
                  'OverlandFlowRegion',
                  'ICPR_GUID',
                  'TextX',
                  'TextY',
                  'TextZ']                  
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_WeirType = fields.index('WeirType')
        GDB_WeirDischargeCoef = fields.index('WeirDischargeCoef')
        GDB_HorizontalOffset = fields.index('HorizontalOffset')
        GDB_Comment = fields.index('Comment')
        GDB_IsUpstreamRight = fields.index('IsUpstreamRight')
        GDB_OverlandFlowRegion = fields.index('OverlandFlowRegion')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_TextX = fields.index('TextX')
        GDB_TextY = fields.index('TextY')
        GDB_TextZ = fields.index('TextZ')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_WeirType = header_row.index("WeirType")
                        CSV_WeirDischargeCoef = header_row.index("WeirDischargeCoef")
                        CSV_HorizontalOffset = header_row.index("HorizontalOffset")              
                        CSV_Comment = header_row.index("Comment")
                        CSV_IsUpstreamRight = header_row.index("IsUpstreamRight")
                        CSV_TextX = header_row.index("TextX")
                        CSV_TextY = header_row.index("TextY")
                        CSV_TextZ = header_row.index("TextZ")
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)

                        #data
                        data[CSV_WeirType] = int(data[CSV_WeirType])
                        data[CSV_WeirDischargeCoef] = float(data[CSV_WeirDischargeCoef])
                        data[CSV_HorizontalOffset] = float(data[CSV_HorizontalOffset])
                        data[CSV_IsUpstreamRight] = int(data[CSV_IsUpstreamRight])
                        data[CSV_TextX] = float(data[CSV_TextX])
                        data[CSV_TextY] = float(data[CSV_TextY])
                        data[CSV_TextZ] = float(data[CSV_TextZ])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_WeirType] = data[CSV_WeirType]
                                row[GDB_WeirDischargeCoef] = data[CSV_WeirDischargeCoef]
                                row[GDB_HorizontalOffset] = data[CSV_HorizontalOffset]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_IsUpstreamRight] = data[CSV_IsUpstreamRight]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_TextX] = data[CSV_TextX]
                                row[GDB_TextY] = data[CSV_TextY]
                                row[GDB_TextZ] = data[CSV_TextZ]

                                #Region Name
                                try:
                                    row[GDB_OverlandFlowRegion] = OF_AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_OverlandFlowRegion] = OF_UpDict[data[CSV_ParentID]][1]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            WeirType = data[CSV_WeirType]
                            WeirDischargeCoef = data[CSV_WeirDischargeCoef]
                            HorizontalOffset = data[CSV_HorizontalOffset]
                            Comment = data[CSV_Comment]
                            IsUpstreamRight = data[CSV_IsUpstreamRight]
                            ICPR_GUID = data[CSV_ID]
                            TextX = data[CSV_TextX]
                            TextY = data[CSV_TextY]
                            TextZ = data[CSV_TextZ]

                            #Region Name
                            try:
                                OverlandFlowRegion = OF_AddDict[data[CSV_ParentID]][1]
                            except:
                                OverlandFlowRegion = OF_UpDict[data[CSV_ParentID]][1]

                            In_Data = (Name,
                                       WeirType,
                                       WeirDischargeCoef,
                                       HorizontalOffset,
                                       Comment,
                                       IsUpstreamRight,
                                       OverlandFlowRegion,
                                       ICPR_GUID,
                                       TextX,
                                       TextY,
                                       TextZ)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]          
                del cursorInsert
                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Weir Center Line Point
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_OF_Weir_Point"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_Weir_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Append new/updated data
        fields = ['Name',
                  'Vertex',
                  'X',
                  'Y',
                  'VerticalOffset',
                  'ElevCalcMethod',
                  'ICPR_GUID']

        GDB_Name = fields.index('Name')
        GDB_Vertex = fields.index('Vertex')
        GDB_X = fields.index('X')
        GDB_Y = fields.index('Y')
        GDB_VerticalOffset = fields.index('VerticalOffset')
        GDB_ElevCalcMethod = fields.index('ElevCalcMethod')            
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
       
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Vertex = header_row.index("Vertex")
                    CSV_X = header_row.index("X")
                    CSV_Y = header_row.index("Y")
                    CSV_VerticalOffset = header_row.index("VerticalOffset")
                    CSV_ElevCalcMethod = header_row.index("ElevCalcMethod")

                else:
                    data = iccsv.csv_parseline(line)
                    Vertex = data[CSV_Vertex]
                    X = data[CSV_X]
                    Y = data[CSV_Y]
                    VerticalOffset = data[CSV_VerticalOffset]
                    ElevCalcMethod = data[CSV_ElevCalcMethod]
                    ICPR_GUID = data[CSV_ID]

                    #Name
                    try:
                        Name = AddDict[data[CSV_ParentID]][1]
                    except:
                        Name = UpDict[data[CSV_ParentID]][1]

                    In_Data = (Name,
                               Vertex,
                               X,
                               Y,
                               VerticalOffset,
                               ElevCalcMethod,
                               ICPR_GUID)   

                    #Insert new record if geometry is valid
                    try:
                        cursorInsert.insertRow(In_Data)
                    except:
                        pass
         
            del cursorInsert
            
    except:
        arcpy.GetMessages()

##########################################################################################################################
#Left Line Point
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_OF_Weir_LeftPoint"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_Weir_LeftPoint.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Append new/updated data
        fields = ['Name',
                  'Vertex',
                  'X',
                  'Y',
                  'ICPR_GUID']

        GDB_Name = fields.index('Name')
        GDB_Vertex = fields.index('Vertex')
        GDB_X = fields.index('X')
        GDB_Y = fields.index('Y')           
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Vertex = header_row.index("Vertex")
                    CSV_X = header_row.index("X")
                    CSV_Y = header_row.index("Y")

                else:
                    
                    data = iccsv.csv_parseline(line)
                    
                    Vertex = data[CSV_Vertex]
                    X = data[CSV_X]
                    Y = data[CSV_Y]
                    ICPR_GUID = data[CSV_ID]

                    #Name
                    try:
                        Name = AddDict[data[CSV_ParentID]][1]
                    except:
                        Name = UpDict[data[CSV_ParentID]][1]

                    In_Data = (Name,
                               Vertex,
                               X,
                               Y,
                               ICPR_GUID)   

                    #Insert new record if geometry is valid
                    try:
                        cursorInsert.insertRow(In_Data)
                    except:
                        pass
         
            del cursorInsert
            
    except:
        arcpy.GetMessages()

##########################################################################################################################
#Right Line Point
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_OF_Weir_RightPoint"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_Weir_RightPoint.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Append new/updated data
        fields = ['Name',
                  'Vertex',
                  'X',
                  'Y',
                  'ICPR_GUID']

        GDB_Name = fields.index('Name')
        GDB_Vertex = fields.index('Vertex')
        GDB_X = fields.index('X')
        GDB_Y = fields.index('Y')           
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Vertex = header_row.index("Vertex")
                    CSV_X = header_row.index("X")
                    CSV_Y = header_row.index("Y")

                else:
                    
                    data = iccsv.csv_parseline(line)
     
                    Vertex = data[CSV_Vertex]
                    X = data[CSV_X]
                    Y = data[CSV_Y]
                    ICPR_GUID = data[CSV_ID]

                    #Name
                    try:
                        Name = AddDict[data[CSV_ParentID]][1]
                    except:
                        Name = UpDict[data[CSV_ParentID]][1]

                    In_Data = (Name,
                               Vertex,
                               X,
                               Y,
                               ICPR_GUID)   

                    #Insert new record if geometry is valud
                    try:
                        cursorInsert.insertRow(In_Data)
                    except:
                        pass
         
            del cursorInsert
        
    except:
        arcpy.GetMessages()
