#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_OFBreakpoint(infc1, Merge, Filestem, OF_AddDict, OF_UpDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "OF_BreakPoint"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_OF_Breakpoint.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features

        fields = ['Name',
                  'Comment',
                  'OverlandFlowRegion',
                  'ICPR_GUID',
                  'Shape@',
                  'Apply3D']  
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Comment = fields.index('Comment')
        GDB_OverlandFlowRegion = fields.index('OverlandFlowRegion')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Shape = fields.index('Shape@')
        GDB_Apply3D = fields.index('Apply3D')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")             
                        CSV_Comment = header_row.index("Comment")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        CSV_Z = header_row.index("Z")
                        CSV_Apply3D = header_row.index("Apply3D")

                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Data Types
                        data[CSV_X] = float(data[CSV_X])
                        data[CSV_Y] = float(data[CSV_Y])
                        data[CSV_Z] = float(data[CSV_Z])
                        data[CSV_Apply3D] = int(data[CSV_Apply3D])
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Shape] = (data[CSV_X],data[CSV_Y],data[CSV_Z])
                                row[GDB_Apply3D] = data[CSV_Apply3D]

                                #Region Name
                                try:
                                    row[GDB_OverlandFlowRegion] = OF_AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_OverlandFlowRegion] = OF_UpDict[data[CSV_ParentID]][1]
                                
                                #update row if geometry is valid
                                try:
                                    cursorUpdate.updateRow(row)
                                except:
                                    pass
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            Comment = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]
                            Shape = (data[CSV_X],data[CSV_Y],data[CSV_Z])
                            Apply3D = data[CSV_Apply3D]

                            #Region Name
                            try:
                                OverlandFlowRegion = OF_AddDict[data[CSV_ParentID]][1]
                            except:
                                OverlandFlowRegion = OF_UpDict[data[CSV_ParentID]][1]

                            In_Data = (Name,
                                       Comment,
                                       OverlandFlowRegion,
                                       ICPR_GUID,
                                       Shape,
                                       Apply3D)   

                            #Insert new record if geometry is valid
                            try:
                                cursorInsert.insertRow(In_Data)
                            except:
                                pass
                            
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]          
                del cursorInsert
                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()
