#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_GWDrainLine(infc1, Merge, Filestem, GW_AddDict, GW_UpDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "GW_Drainline"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_GW_Drain_Line.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ["Name",
                  "Node",
                  "Depth_Elevation_1",
                  "Depth_Elevation_2",
                  "Vertical_Placement_Option",
                  "Conductance",
                  "Limiting_head",
                  "Comment",
                  "ICPR_GUID",
                  "GroundwaterRegion"]                  
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Node = fields.index('Node')
        GDB_Depth_Elevation_1 = fields.index('Depth_Elevation_1')
        GDB_Depth_Elevation_2 = fields.index('Depth_Elevation_2')
        GDB_Vertical_Placement_Option = fields.index('Vertical_Placement_Option')
        GDB_Conductance = fields.index('Conductance')
        GDB_Limiting_head = fields.index('Limiting_head')
        GDB_Comment = fields.index('Comment')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_GroundwaterRegion = fields.index('GroundwaterRegion')     

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Node = header_row.index("Node")
                        CSV_DepthOrElev1 = header_row.index("DepthOrElev1")
                        CSV_DepthOrElev2 = header_row.index("DepthOrElev2")
                        CSV_VertPlaceOption = header_row.index("VertPlaceOption")
                        CSV_Conductance = header_row.index("Conductance")
                        CSV_LimitingHead = header_row.index("LimitingHead")
                        CSV_Comment = header_row.index("Comment")                    
                        
                    else:
          
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #Data
                        data[CSV_DepthOrElev1] = float(data[CSV_DepthOrElev1])
                        data[CSV_DepthOrElev2] = float(data[CSV_DepthOrElev2])
                        data[CSV_VertPlaceOption] = int(data[CSV_VertPlaceOption])
                        data[CSV_Conductance] = float(data[CSV_Conductance])
                        data[CSV_LimitingHead] = float(data[CSV_LimitingHead])                    

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Node] = data[CSV_Node]
                                row[GDB_Depth_Elevation_1] = data[CSV_DepthOrElev1]
                                row[GDB_Depth_Elevation_2] = data[CSV_DepthOrElev2]
                                row[GDB_Vertical_Placement_Option] = data[CSV_VertPlaceOption]
                                row[GDB_Conductance] = data[CSV_Conductance]
                                row[GDB_Limiting_head] = data[CSV_LimitingHead]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #Region Name
                                try:
                                    row[GDB_GroundwaterRegion] = GW_AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_GroundwaterRegion] = GW_UpDict[data[CSV_ParentID]][1]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                                                    
                            Name = data[CSV_Name]
                            Node = data[CSV_Node]
                            Depth_Elevation_1 = data[CSV_DepthOrElev1]
                            Depth_Elevation_2 = data[CSV_DepthOrElev2]
                            Vertical_Placement_Option = data[CSV_VertPlaceOption]
                            Conductance = data[CSV_Conductance]
                            Limiting_head = data[CSV_LimitingHead]
                            Comment = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            #Region Name
                            try:
                                GroundwaterRegion = GW_AddDict[data[CSV_ParentID]][1]
                            except:
                                GroundwaterRegion = GW_UpDict[data[CSV_ParentID]][1]

                            In_Data = (Name,
                                       Node,
                                       Depth_Elevation_1,
                                       Depth_Elevation_2,
                                       Vertical_Placement_Option,
                                       Conductance,
                                       Limiting_head,
                                       Comment,
                                       ICPR_GUID,
                                       GroundwaterRegion)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)                                    
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]
                del cursorInsert
                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:        
        #Output
        outfc = "GW_Drainline"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_GW_Drain_Line_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:
            
            #Flags for feature geometry data
            Pnts_done = False
            Pnts = []
            Guid_Old = None
            GeomDict = {}#geometry dicationary
            
            
            with open(infc,'r') as csv_file:
                first = True
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex = header_row.index("Vertex")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        Guid_New = data[CSV_ParentID]
                        
                        #Initialize old GUID.  Only happens during the first pass.
                        if Guid_Old == None:
                            Guid_Old = data[CSV_ParentID]
                        
                        #Check if point array is done
                        if Guid_Old != Guid_New:                                                     
                            
                            GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                            Guid_Old = Guid_New #Reset old GUID
                            Pnts = [] #Empty array
                            
                            
                        
                        #Create point
                        pnt = (data[CSV_X],data[CSV_Y])
                        Pnts.append(pnt)                                
        
            #Add last record to dictionary
            GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.            
            
        except:
        
            arcpy.GetMessages()
        
        #Write geometry data to feature class           
        fields = ['ICPR_GUID',
                  'Shape@']

        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPE = fields.index('Shape@')
        
        cursorUpdate = arcpy.da.UpdateCursor(outfc,fields)       
        for row in cursorUpdate:
            try:
                Guid = row[GDB_ICPR_GUID]
                Geom = GeomDict[Guid]
                
                #add geometry
                row[GDB_SHAPE] = Geom
                cursorUpdate.updateRow(row)
                
            except:
                continue

        del cursorUpdate
            
    except:
        arcpy.GetMessages()

