#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_FillablePorosity(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
            
        #Output
        outfc = "ICPR4_FILLABLE_POROSITY_SET"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "FillablePorositySet.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'COMMENT',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:        

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            NAME = data[CSV_Name]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       COMMENT,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_FILLABLE_POROSITY_ZONES"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "FillablePorositySet_FillablePorosity.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['FillablePorosityZone',
                      'FillablePorosity_BelowGround',
                      'FillablePorosity_AboveGround',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_FillablePorosityZone = fields.index('FillablePorosityZone')
            GDB_FillablePorosity_BelowGround = fields.index('FillablePorosity_BelowGround')
            GDB_FillablePorosity_AboveGround = fields.index('FillablePorosity_AboveGround')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:
                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")                        
                        CSV_FillablePorosityZone = header_row.index("FillablePorosityZone")
                        CSV_FillablePorosity_BelowGround = header_row.index("FillablePorosity_BelowGround")
                        CSV_FillablePorosity_AboveGround = header_row.index("FillablePorosity_AboveGround")
                        
                    else:

                        data = iccsv.csv_parseline(line)

                        data[CSV_FillablePorosity_BelowGround] = float(data[CSV_FillablePorosity_BelowGround])
                        data[CSV_FillablePorosity_AboveGround] = float(data[CSV_FillablePorosity_AboveGround])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]
                            
                        FillablePorosityZone = data[CSV_FillablePorosityZone]
                        FillablePorosity_BelowGround = data[CSV_FillablePorosity_BelowGround]
                        FillablePorosity_AboveGround = data[CSV_FillablePorosity_AboveGround]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (FillablePorosityZone,
                                   FillablePorosity_BelowGround,
                                   FillablePorosity_AboveGround,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)  
                        
                del cursorInsert

        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
