#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_EMC(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:

        #Output
        outfc = "ICPR4_EMC_Constituent_Set"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "EMCConstituentSet.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'COMMENT',
                  'ICPR_GUID']


        #List index
        GDB_NAME = fields.index('NAME')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"

                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate


                        #Add new data
                        else:

                            NAME = data[CSV_Name]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       COMMENT,
                                       ICPR_GUID)

                            #Insert new record
                            cursorInsert.insertRow(In_Data)


                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                del cursorInsert

    except:

        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:

        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:
        #Output
        outfc = "ICPR4_EMC_Constituent"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "EMCConstituentSet_Constituent.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['Constituent',
                      'DefCon_LandCoverZones',
                      'DefCon_TimeStageNodes',
                      'DefCon_InitialNodeVolume',
                      'DefCon_ExternalHydrographs',
                      'DefCon_BaseFlow',
                      'DefCon_GroundwaterInflow',
                      'IrreducibleConcentration',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_Constituent = fields.index('Constituent')
            GDB_DefCon_LandCoverZones = fields.index('DefCon_LandCoverZones')
            GDB_DefCon_TimeStageNodes = fields.index('DefCon_TimeStageNodes')
            GDB_DefCon_InitialNodeVolume = fields.index('DefCon_InitialNodeVolume')
            GDB_DefCon_ExternalHydrographs = fields.index('DefCon_ExternalHydrographs')
            GDB_DefCon_BaseFlow = fields.index('DefCon_BaseFlow')
            GDB_DefCon_GroundwaterInflow = fields.index('DefCon_GroundwaterInflow')
            GDB_IrreducibleConcentration = fields.index('IrreducibleConcentration')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Create new Dictionary
            Dict = {}

            with open(infc,'r') as csv_file:

                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Constituent = header_row.index("Constituent")
                        CSV_DefCon_LandCoverZones = header_row.index("DefCon_LandCoverZones")
                        CSV_DefCon_TimeStageNodes = header_row.index("DefCon_TimeStageNodes")
                        CSV_DefCon_InitialNodeVolume = header_row.index("DefCon_InitialNodeVolume")
                        CSV_DefCon_ExternalHydrographs = header_row.index("DefCon_ExternalHydrographs")
                        CSV_DefCon_BaseFlow = header_row.index("DefCon_BaseFlow")
                        CSV_DefCon_GroundwaterInflow = header_row.index("DefCon_GroundwaterInflow")                        
                        CSV_IrreducibleConcentration = header_row.index("IrreducibleConcentration")

                    else:

                        data = iccsv.csv_parseline(line)

                        data[CSV_DefCon_LandCoverZones] = float(data[CSV_DefCon_LandCoverZones])
                        data[CSV_DefCon_TimeStageNodes] = float(data[CSV_DefCon_TimeStageNodes])
                        data[CSV_DefCon_InitialNodeVolume] = float(data[CSV_DefCon_InitialNodeVolume])
                        data[CSV_DefCon_ExternalHydrographs] = float(data[CSV_DefCon_ExternalHydrographs])
                        data[CSV_DefCon_BaseFlow] = float(data[CSV_DefCon_BaseFlow])
                        data[CSV_DefCon_GroundwaterInflow] = float(data[CSV_DefCon_GroundwaterInflow])                        
                        data[CSV_IrreducibleConcentration] = float(data[CSV_IrreducibleConcentration])

                        #Populate Name
                        try:
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]

                        Constituent = data[CSV_Constituent]
                        DefCon_LandCoverZones = data[CSV_DefCon_LandCoverZones]
                        DefCon_TimeStageNodes = data[CSV_DefCon_TimeStageNodes]
                        DefCon_InitialNodeVolume = data[CSV_DefCon_InitialNodeVolume]
                        DefCon_ExternalHydrographs = data[CSV_DefCon_ExternalHydrographs]
                        DefCon_BaseFlow = data[CSV_DefCon_BaseFlow]
                        DefCon_GroundwaterInflow = data[CSV_DefCon_GroundwaterInflow]
                        IrreducibleConcentration = data[CSV_IrreducibleConcentration]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (Constituent,
                                   DefCon_LandCoverZones,
                                   DefCon_TimeStageNodes,
                                   DefCon_InitialNodeVolume,
                                   DefCon_ExternalHydrographs,
                                   DefCon_BaseFlow,
                                   DefCon_GroundwaterInflow,
                                   IrreducibleConcentration,
                                   SET_NAME,
                                   ICPR_GUID)

                        #Insert new record
                        cursorInsert.insertRow(In_Data)                
                        Dict[ICPR_GUID] = [Constituent,SET_NAME]
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()


##########################################################################################################################
#Populated Child Table 2
##########################################################################################################################
    try:
        #Output
        outfc = "ICPR4_EMC_Constituent_Pnts"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "EMCConstituentSet_Constituent_EMC.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['Constituent',
                      'LandCoverZone',
                      'EMC',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_Constituent = fields.index('Constituent')
            GDB_LandCoverZone = fields.index('LandCoverZone')
            GDB_EMC = fields.index('EMC')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            with open(infc,'r') as csv_file:

                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_LandCoverZone = header_row.index("LandCoverZone")
                        CSV_EMC = header_row.index("EMC")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Data
                        data[CSV_EMC] = float(data[CSV_EMC])

                        #Populate Name
                        try:
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            Constituent = Dict[data[CSV_ParentID]][0]
                        except:
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            Constituent = Dict[data[CSV_ParentID]][0]

                        LandCoverZone = data[CSV_LandCoverZone]
                        EMC = data[CSV_EMC]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (Constituent,
                                   LandCoverZone,
                                   EMC,
                                   SET_NAME,
                                   ICPR_GUID)

                        #Insert new record
                        cursorInsert.insertRow(In_Data)
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()
