#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_Basins(infc1, Merge, Filestem, ScenDict):
##########################################################################################################################
#Manual Basin - Update attribute table data and no geometry data
##########################################################################################################################
    try:
    
        #Output
        outfc = "ICPR_BASIN" 

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "ManualBasin.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'NODENAME',
                  'UNITHYD',
                  'TYPE',
                  'PEAKFACTOR',
                  'TC',
                  'TIMESHIFT',
                  'MAXQ',
                  'INFILTRATION_METHOD',
                  'ISPLACED',
                  'BASIN_TYPE',
                  'ShapeX',
                  'ShapeY',
                  'SCENARIO',
                  'COMMENT',
                  'ICPR_GUID',
                  "WQ_WQOption",
                  "WQ_Comment",
                  "WQ_ShapeX",
                  "WQ_ShapeY",
                  "WQ_ShapeZ",                  
                  "WQ_IsPlaced"]                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_NODENAME = fields.index('NODENAME')
        GDB_UNITHYD = fields.index('UNITHYD')
        GDB_TYPE = fields.index('TYPE')
        GDB_PEAKFACTOR = fields.index('PEAKFACTOR')
        GDB_TC = fields.index('TC')
        GDB_TIMESHIFT = fields.index('TIMESHIFT')
        GDB_MAXQ = fields.index('MAXQ')
        GDB_INFILTRATION_METHOD = fields.index('INFILTRATION_METHOD')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_BASIN_TYPE = fields.index('BASIN_TYPE')
        GDB_ShapeX = fields.index('ShapeX')
        GDB_ShapeY = fields.index('ShapeY')        
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_WQ_WQOption =fields.index('WQ_WQOption')
        GDB_WQ_Comment =fields.index('WQ_Comment')
        GDB_WQ_ShapeX =fields.index('WQ_ShapeX')
        GDB_WQ_ShapeY =fields.index('WQ_ShapeY')
        GDB_WQ_ShapeZ =fields.index('WQ_ShapeZ')
        GDB_WQ_IsPlaced =fields.index('WQ_IsPlaced')
        

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Node = header_row.index("Node")
                        CSV_HydrographMethod = header_row.index("HydrographMethod")
                        CSV_InfiltrationMethod = header_row.index("InfiltrationMethod")
                        CSV_TimeOfConcentration = header_row.index("TimeOfConcentration")
                        CSV_MaxAllowableQ = header_row.index("MaxAllowableQ")
                        CSV_TimeShift = header_row.index("TimeShift")
                        CSV_UnitHydrograph = header_row.index("UnitHydrograph")
                        CSV_PeakingFactor = header_row.index("PeakingFactor")
                        CSV_Comment = header_row.index("Comment")
                        CSV_ShapeX = header_row.index("ShapeX")
                        CSV_ShapeY = header_row.index("ShapeY")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                        CSV_WQ_WQOption = header_row.index("WQ_WQOption")
                        CSV_WQ_Comment = header_row.index("WQ_Comment")
                        CSV_WQ_ShapeX = header_row.index("WQ_ShapeX")
                        CSV_WQ_ShapeY = header_row.index("WQ_ShapeY")
                        CSV_WQ_ShapeZ = header_row.index("WQ_ShapeZ")
                        CSV_WQ_IsPlaced = header_row.index("WQ_IsPlaced")
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_HydrographMethod] = int(data[CSV_HydrographMethod])
                        data[CSV_TimeOfConcentration] = float(data[CSV_TimeOfConcentration])
                        data[CSV_MaxAllowableQ] = float(data[CSV_MaxAllowableQ])
                        data[CSV_TimeShift] = float(data[CSV_TimeShift])
                        data[CSV_PeakingFactor] = float(data[CSV_PeakingFactor])
                        data[CSV_ShapeX] = float(data[CSV_ShapeX])
                        data[CSV_ShapeY] = float(data[CSV_ShapeY])
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        data[CSV_WQ_WQOption] = int(data[CSV_WQ_WQOption])
                        data[CSV_WQ_ShapeX] = float(data[CSV_WQ_ShapeX])
                        data[CSV_WQ_ShapeY] = float(data[CSV_WQ_ShapeY])
                        data[CSV_WQ_ShapeZ] = float(data[CSV_WQ_ShapeZ])
                        data[CSV_WQ_IsPlaced] = int(data[CSV_WQ_IsPlaced])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_NODENAME] = data[CSV_Node]
                                row[GDB_UNITHYD] = data[CSV_UnitHydrograph]
                                row[GDB_TYPE] = data[CSV_HydrographMethod]
                                row[GDB_PEAKFACTOR] = data[CSV_PeakingFactor]
                                row[GDB_TC] = data[CSV_TimeOfConcentration]
                                row[GDB_TIMESHIFT] = data[CSV_TimeShift]
                                row[GDB_MAXQ] = data[CSV_MaxAllowableQ]
                                row[GDB_INFILTRATION_METHOD] = data[CSV_InfiltrationMethod]
                                row[GDB_ISPLACED] = data[CSV_IsPlaced]
                                row[GDB_BASIN_TYPE] = 0
                                row[GDB_ShapeX] = data[CSV_ShapeX]
                                row[GDB_ShapeY] = data[CSV_ShapeY]        
                                row[GDB_SCENARIO] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_WQ_WQOption] = data[CSV_WQ_WQOption]
                                row[GDB_WQ_Comment] = data[CSV_WQ_Comment]
                                row[GDB_WQ_ShapeX] = data[CSV_WQ_ShapeX]
                                row[GDB_WQ_ShapeY] = data[CSV_WQ_ShapeY]
                                row[GDB_WQ_ShapeZ] = data[CSV_WQ_ShapeZ]
                                row[GDB_WQ_IsPlaced] = data[CSV_WQ_IsPlaced]
                                                                                   
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                              
                            NAME = data[CSV_Name]
                            NODENAME = data[CSV_Node]
                            UNITHYD = data[CSV_UnitHydrograph]
                            TYPE = data[CSV_HydrographMethod]
                            PEAKFACTOR = data[CSV_PeakingFactor]
                            TC = data[CSV_TimeOfConcentration]
                            TIMESHIFT = data[CSV_TimeShift]
                            MAXQ = data[CSV_MaxAllowableQ]
                            INFILTRATION_METHOD = data[CSV_InfiltrationMethod]
                            ISPLACED = data[CSV_IsPlaced]
                            BASIN_TYPE = 0
                            ShapeX = data[CSV_ShapeX]
                            ShapeY = data[CSV_ShapeY]        
                            SCENARIO = ScenDict[data[CSV_ParentID]][1]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]                        
                            WQ_WQOption = data[CSV_WQ_WQOption]
                            WQ_Comment = data[CSV_WQ_Comment]
                            WQ_ShapeX = data[CSV_WQ_ShapeX]
                            WQ_ShapeY = data[CSV_WQ_ShapeY]
                            WQ_ShapeZ = data[CSV_WQ_ShapeZ]                 
                            WQ_IsPlaced = data[CSV_WQ_IsPlaced]

                            In_Data = (NAME,
                                       NODENAME,
                                       UNITHYD,
                                       TYPE,
                                       PEAKFACTOR,
                                       TC,
                                       TIMESHIFT,
                                       MAXQ,
                                       INFILTRATION_METHOD,
                                       ISPLACED,
                                       BASIN_TYPE,
                                       ShapeX,
                                       ShapeY,
                                       SCENARIO,
                                       COMMENT,
                                       ICPR_GUID,
                                       WQ_WQOption,
                                       WQ_Comment,
                                       WQ_ShapeX,
                                       WQ_ShapeY,
                                       WQ_ShapeZ,                  
                                       WQ_IsPlaced)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                
    except:

        arcpy.GetMessages()
        
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and row[GDB_BASIN_TYPE] == 0:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Manual Sub-Basin - Update attribute table data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_ManualBasin_SubBasin"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "ManualBasin_SubBasin.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass
        
        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'Area',
                  'LandCoverZone',
                  'SoilZone',
                  'RainfallName',
                  'CropCoefZone',
                  'ReferenceETStation',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_Area = fields.index('Area')
        GDB_LandCoverZone = fields.index('LandCoverZone')
        GDB_SoilZone = fields.index('SoilZone')
        GDB_RainfallName = fields.index('RainfallName')
        GDB_CropCoefZone = fields.index('CropCoefZone')
        GDB_ReferenceETStation = fields.index('ReferenceETStation')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Area = header_row.index("Area")
                        CSV_LandCoverZone = header_row.index("LandCoverZone")
                        CSV_SoilZone = header_row.index("SoilZone")
                        CSV_RainfallName = header_row.index("RainfallName")
                        CSV_CropCoefZone = header_row.index("CropCoefZone")
                        CSV_ReferenceETStation = header_row.index("ReferenceETStation")

                    else:
                        
                        data = iccsv.csv_parseline(line)

                        #Data
                        data[CSV_Area] =  float(data[CSV_Area])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                #Assign Name
                                try:
                                    
                                    row[GDB_NAME] = AddDict[data[CSV_ParentID]][1]

                                except:
                                    row[GDB_NAME] = UpDict[data[CSV_ParentID]][1]
                                    
                                row[GDB_Area] = data[CSV_Area]
                                row[GDB_LandCoverZone] = data[CSV_LandCoverZone]
                                row[GDB_SoilZone] = data[CSV_SoilZone]
                                row[GDB_RainfallName] = data[CSV_RainfallName]
                                row[GDB_CropCoefZone] = data[CSV_CropCoefZone]
                                row[GDB_ReferenceETStation] = data[CSV_ReferenceETStation]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                   
                                #update row
                                cursorUpdate.updateRow(row)

                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                        
                            #Assign Name
                            try:
                                
                                NAME = AddDict[data[CSV_ParentID]][1]

                            except:
                                NAME = UpDict[data[CSV_ParentID]][1]
                                
                            Area = data[CSV_Area]
                            LandCoverZone = data[CSV_LandCoverZone]
                            SoilZone = data[CSV_SoilZone]
                            RainfallName = data[CSV_RainfallName]
                            CropCoefZone = data[CSV_CropCoefZone]
                            ReferenceETStation = data[CSV_ReferenceETStation]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       Area,
                                       LandCoverZone,
                                       SoilZone,
                                       RainfallName,
                                       CropCoefZone,
                                       ReferenceETStation,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)          
                del cursorInsert
                        
    except:

        arcpy.GetMessages()

##########################################################################################################################
#Mapped Basin - Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR_BASIN"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "MappedBasin.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'NODENAME',
                  'UNITHYD',
                  'TYPE',
                  'PEAKFACTOR',
                  'TC',
                  'TIMESHIFT',
                  'MAXQ',
                  'INFILTRATION_METHOD',
                  'ISPLACED',
                  'BASIN_TYPE',
                  'SCENARIO',
                  'COMMENT',
                  'ICPR_GUID',
                  'ShapeX',
                  'ShapeY',
                  "WQ_WQOption",
                  "WQ_Comment",
                  "WQ_ShapeX",
                  "WQ_ShapeY",
                  "WQ_ShapeZ",                  
                  "WQ_IsPlaced"]                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_NODENAME = fields.index('NODENAME')
        GDB_UNITHYD = fields.index('UNITHYD')
        GDB_TYPE = fields.index('TYPE')
        GDB_PEAKFACTOR = fields.index('PEAKFACTOR')
        GDB_TC = fields.index('TC')
        GDB_TIMESHIFT = fields.index('TIMESHIFT')
        GDB_MAXQ = fields.index('MAXQ')
        GDB_INFILTRATION_METHOD = fields.index('INFILTRATION_METHOD')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_BASIN_TYPE = fields.index('BASIN_TYPE')     
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_ShapeX = fields.index('ShapeX')
        GDB_ShapeY = fields.index('ShapeY')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_WQ_WQOption = fields.index('WQ_WQOption')
        GDB_WQ_Comment = fields.index('WQ_Comment')
        GDB_WQ_ShapeX = fields.index('WQ_ShapeX')
        GDB_WQ_ShapeY = fields.index('WQ_ShapeY')
        GDB_WQ_ShapeZ = fields.index('WQ_ShapeZ')
        GDB_WQ_IsPlaced = fields.index('WQ_IsPlaced')
        


        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Node = header_row.index("Node")
                        CSV_HydrographMethod = header_row.index("HydrographMethod")
                        CSV_TimeOfConcentration = header_row.index("TimeOfConcentration")
                        CSV_MaxAllowableQ = header_row.index("MaxAllowableQ")
                        CSV_TimeShift = header_row.index("TimeShift")
                        CSV_UnitHydrograph = header_row.index("UnitHydrograph")
                        CSV_PeakingFactor = header_row.index("PeakingFactor")
                        CSV_Comment = header_row.index("Comment")
                        CSV_ShapeX = header_row.index("ShapeX")
                        CSV_ShapeY = header_row.index("ShapeY")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                        CSV_WQ_WQOption = header_row.index("WQ_WQOption")
                        CSV_WQ_Comment = header_row.index("WQ_Comment")
                        CSV_WQ_ShapeX = header_row.index("WQ_ShapeX")
                        CSV_WQ_ShapeY = header_row.index("WQ_ShapeY")
                        CSV_WQ_ShapeZ = header_row.index("WQ_ShapeZ")                    
                        CSV_WQ_IsPlaced = header_row.index("WQ_IsPlaced")
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_HydrographMethod] = int(data[CSV_HydrographMethod])
                        data[CSV_TimeOfConcentration] = float(data[CSV_TimeOfConcentration])
                        data[CSV_MaxAllowableQ] = float(data[CSV_MaxAllowableQ])
                        data[CSV_TimeShift] = float(data[CSV_TimeShift])
                        data[CSV_PeakingFactor] = float(data[CSV_PeakingFactor])
                        data[CSV_ShapeX] = float(data[CSV_ShapeX])
                        data[CSV_ShapeY] = float(data[CSV_ShapeY])
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        data[CSV_WQ_WQOption] = int(data[CSV_WQ_WQOption])
                        data[CSV_WQ_ShapeX] = float(data[CSV_WQ_ShapeX])
                        data[CSV_WQ_ShapeY] = float(data[CSV_WQ_ShapeY])
                        data[CSV_WQ_ShapeZ] = float(data[CSV_WQ_ShapeZ])
                        data[CSV_WQ_IsPlaced] = int(data[CSV_WQ_IsPlaced])
                        
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        
                        #Only update geometry for valide ArcGIS project.
                        try:
                            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                        except:
                            pass
                        
                        
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_NODENAME] = data[CSV_Node]
                                row[GDB_UNITHYD] = data[CSV_UnitHydrograph]
                                row[GDB_TYPE] = data[CSV_HydrographMethod]
                                row[GDB_PEAKFACTOR] = data[CSV_PeakingFactor]
                                row[GDB_TC] = data[CSV_TimeOfConcentration]
                                row[GDB_TIMESHIFT] = data[CSV_TimeShift]
                                row[GDB_MAXQ] = data[CSV_MaxAllowableQ]
                                row[GDB_INFILTRATION_METHOD] = None
                                row[GDB_BASIN_TYPE] = 1      
                                row[GDB_SCENARIO] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_ISPLACED] = data[CSV_IsPlaced]
                                row[GDB_ShapeX] = data[CSV_ShapeX]
                                row[GDB_ShapeY] = data[CSV_ShapeY]
                                row[CSV_WQ_WQOption] = data[CSV_WQ_WQOption]
                                row[CSV_WQ_Comment] = data[CSV_WQ_Comment]
                                row[CSV_WQ_ShapeX] = data[CSV_WQ_ShapeX]
                                row[CSV_WQ_ShapeY] = data[CSV_WQ_ShapeY]
                                row[CSV_WQ_ShapeZ] = data[CSV_WQ_ShapeZ]
                                row[CSV_WQ_IsPlaced] = data[CSV_WQ_IsPlaced]
                                                                                   
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                              
                            NAME = data[CSV_Name]
                            NODENAME = data[CSV_Node]
                            UNITHYD = data[CSV_UnitHydrograph]
                            TYPE = data[CSV_HydrographMethod]
                            PEAKFACTOR = data[CSV_PeakingFactor]
                            TC = data[CSV_TimeOfConcentration]
                            TIMESHIFT = data[CSV_TimeShift]
                            MAXQ = data[CSV_MaxAllowableQ]
                            INFILTRATION_METHOD = None
                            ISPLACED = data[CSV_IsPlaced]
                            BASIN_TYPE = 1      
                            SCENARIO = ScenDict[data[CSV_ParentID]][1]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]
                            ShapeX = data[CSV_ShapeX]
                            ShapeY = data[CSV_ShapeY]
                            WQ_WQOption = data[CSV_WQ_WQOption]
                            WQ_Comment = data[CSV_WQ_Comment]
                            WQ_ShapeX = data[CSV_WQ_ShapeX]
                            WQ_ShapeY = data[CSV_WQ_ShapeY]
                            WQ_ShapeZ = data[CSV_WQ_ShapeZ]                 
                            WQ_IsPlaced = data[CSV_WQ_IsPlaced]
                            

                            In_Data = (NAME,
                                       NODENAME,
                                       UNITHYD,
                                       TYPE,
                                       PEAKFACTOR,
                                       TC,
                                       TIMESHIFT,
                                       MAXQ,
                                       INFILTRATION_METHOD,
                                       ISPLACED,
                                       BASIN_TYPE,
                                       SCENARIO,
                                       COMMENT,
                                       ICPR_GUID,
                                       ShapeX,
                                       ShapeY,
                                       WQ_WQOption,
                                       WQ_Comment,
                                       WQ_ShapeX,
                                       WQ_ShapeY,
                                       WQ_ShapeZ,                  
                                       WQ_IsPlaced)   

                            #Insert new record
                            #Only add data with valid geometry for ArcGIS
                            try:
                                cursorInsert.insertRow(In_Data)
                            
                            except:
                                pass
                            
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and row[GDB_BASIN_TYPE] == 1:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Simple Basin - Update attribute table data and no geometry data
##########################################################################################################################
    try:
    
        #Output
        outfc = "ICPR_BASIN"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "SimpleBasin.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'NODENAME',
                  'UNITHYD',
                  'TYPE',
                  'PEAKFACTOR',
                  'TC',
                  'TIMESHIFT',
                  'MAXQ',
                  'INFILTRATION_METHOD',
                  'ISPLACED',
                  'BASIN_TYPE',
                  'ShapeX',
                  'ShapeY',
                  'SCENARIO',
                  'COMMENT',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_NODENAME = fields.index('NODENAME')
        GDB_UNITHYD = fields.index('UNITHYD')
        GDB_TYPE = fields.index('TYPE')
        GDB_PEAKFACTOR = fields.index('PEAKFACTOR')
        GDB_TC = fields.index('TC')
        GDB_TIMESHIFT = fields.index('TIMESHIFT')
        GDB_MAXQ = fields.index('MAXQ')
        GDB_INFILTRATION_METHOD = fields.index('INFILTRATION_METHOD')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_BASIN_TYPE = fields.index('BASIN_TYPE')
        GDB_ShapeX = fields.index('ShapeX')
        GDB_ShapeY = fields.index('ShapeY')        
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Node = header_row.index("Node")
                        CSV_HydrographMethod = header_row.index("HydrographMethod")
                        CSV_InfiltrationMethod = header_row.index("InfiltrationMethod")
                        CSV_TimeOfConcentration = header_row.index("TimeOfConcentration")
                        CSV_MaxAllowableQ = header_row.index("MaxAllowableQ")
                        CSV_TimeShift = header_row.index("TimeShift")
                        CSV_UnitHydrograph = header_row.index("UnitHydrograph")
                        CSV_PeakingFactor = header_row.index("PeakingFactor")
                        CSV_Comment = header_row.index("Comment")
                        CSV_ShapeX = header_row.index("ShapeX")
                        CSV_ShapeY = header_row.index("ShapeY")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_HydrographMethod] = int(data[CSV_HydrographMethod])
                        data[CSV_TimeOfConcentration] = float(data[CSV_TimeOfConcentration])
                        data[CSV_MaxAllowableQ] = float(data[CSV_MaxAllowableQ])
                        data[CSV_TimeShift] = float(data[CSV_TimeShift])
                        data[CSV_PeakingFactor] = float(data[CSV_PeakingFactor])
                        data[CSV_ShapeX] = float(data[CSV_ShapeX])
                        data[CSV_ShapeY] = float(data[CSV_ShapeY])
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_NODENAME] = data[CSV_Node]
                                row[GDB_UNITHYD] = data[CSV_UnitHydrograph]
                                row[GDB_TYPE] = data[CSV_HydrographMethod]
                                row[GDB_PEAKFACTOR] = data[CSV_PeakingFactor]
                                row[GDB_TC] = data[CSV_TimeOfConcentration]
                                row[GDB_TIMESHIFT] = data[CSV_TimeShift]
                                row[GDB_MAXQ] = data[CSV_MaxAllowableQ]
                                row[GDB_INFILTRATION_METHOD] = data[CSV_InfiltrationMethod]
                                row[GDB_ISPLACED] = data[CSV_IsPlaced]
                                row[GDB_BASIN_TYPE] = int(2)
                                row[GDB_ShapeX] = data[CSV_ShapeX]
                                row[GDB_ShapeY] = data[CSV_ShapeY]        
                                row[GDB_SCENARIO] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                                                                   
                                #update row with valid ArcGIS geometry
                                try:
                                    cursorUpdate.updateRow(row)
                                except:
                                    pass
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                              
                            NAME = data[CSV_Name]
                            NODENAME = data[CSV_Node]
                            UNITHYD = data[CSV_UnitHydrograph]
                            TYPE = data[CSV_HydrographMethod]
                            PEAKFACTOR = data[CSV_PeakingFactor]
                            TC = data[CSV_TimeOfConcentration]
                            TIMESHIFT = data[CSV_TimeShift]
                            MAXQ = data[CSV_MaxAllowableQ]
                            INFILTRATION_METHOD = data[CSV_InfiltrationMethod]
                            ISPLACED = data[CSV_IsPlaced]
                            BASIN_TYPE = 2
                            ShapeX = data[CSV_ShapeX]
                            ShapeY = data[CSV_ShapeY]        
                            SCENARIO = ScenDict[data[CSV_ParentID]][1]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       NODENAME,
                                       UNITHYD,
                                       TYPE,
                                       PEAKFACTOR,
                                       TC,
                                       TIMESHIFT,
                                       MAXQ,
                                       INFILTRATION_METHOD,
                                       ISPLACED,
                                       BASIN_TYPE,
                                       ShapeX,
                                       ShapeY,
                                       SCENARIO,
                                       COMMENT,
                                       ICPR_GUID)   

                            #Insert new record with valid geometry
                            try:
                                cursorInsert.insertRow(In_Data)
                            except:
                                pass
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and row[GDB_BASIN_TYPE] == 2:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Simple Sub-Basin - Update attribute table data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_Simple_Basin"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "SimpleBasin.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass
        
        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Fields for update of existing elements/features
        fields = ['Name',
                  'Area',
                  'CurveNumber',
                  'PctImpervious',
                  'PctDCIA',
                  'PctDirect',
                  'Rainfall_Name']                  

                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Area = fields.index('Area')
        GDB_CurveNumber = fields.index('CurveNumber')
        GDB_PctImpervious = fields.index('PctImpervious')
        GDB_PctDCIA = fields.index('PctDCIA')
        GDB_PctDirect = fields.index('PctDirect')
        GDB_Rainfall_Name = fields.index('Rainfall_Name')
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_Name = header_row.index("Name")
                        CSV_Area = header_row.index("Area")
                        CSV_CurveNumber = header_row.index("CurveNumber")
                        CSV_PctImpervious = header_row.index("PctImpervious")
                        CSV_PctDCIA = header_row.index("PctDCIA")
                        CSV_PctDirect = header_row.index("PctDirect")
                        CSV_Rainfall_Name = header_row.index("RainfallName")

                    else:
                        
                        data = iccsv.csv_parseline(line)

                        #Data
                        data[CSV_Area] =  float(data[CSV_Area])
                        data[CSV_CurveNumber] =  float(data[CSV_CurveNumber])
                        data[CSV_PctImpervious] =  float(data[CSV_PctImpervious])
                        data[CSV_PctDCIA] =  float(data[CSV_PctDCIA])
                        data[CSV_PctDirect] =  float(data[CSV_PctDirect])

                        Name = data[CSV_Name]                        
                        Area = data[CSV_Area]
                        CurveNumber = data[CSV_CurveNumber]
                        PctImpervious = data[CSV_PctImpervious]
                        PctDCIA = data[CSV_PctDCIA]
                        PctDirect = data[CSV_PctDirect]
                        Rainfall_Name = data[CSV_Rainfall_Name]
                        
                        LandCoverZone = data[CSV_LandCoverZone]
                        SoilZone = data[CSV_SoilZone]
                        RainfallName = data[CSV_RainfallName]
                        CropCoefZone = data[CSV_CropCoefZone]
                        ReferenceETStation = data[CSV_ReferenceETStation]
                        Rainfall_Name = data[CSV_Rainfall_Name]

                        In_Data = (Name,
                                   Area,
                                   CurveNumber,
                                   PctImpervious,
                                   PctDCIA,
                                   PctDirect,
                                   Rainfall_Name)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)          
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR_BASIN"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "basins.dxf" + "\\" + "Polyline"
        fout1 = infc1 + "\\" + Filestem + "_" + "Basins_Temp.shp"
        fout = infc1 + "\\" + Filestem + "_" + "Basins.shp"
        labels = infc1 + "\\" + Filestem + "_" + "Basins.dxf" + "\\" + "TextPoint"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass   

        #Delete Shapefile if it exists
        try:
            arcpy.Delete_management(in_data=fout1, data_type="ShapeFile")
        except:
            pass
        try:
            arcpy.Delete_management(in_data=fout, data_type="ShapeFile")
        except:
            pass
            

        #Create Shapfile
        arcpy.management.FeatureToPolygon(in_features=infc,
                                          out_feature_class=fout1,
                                          cluster_tolerance=None,
                                          attributes="ATTRIBUTES",
                                          label_features=labels)

        #Dissolve Multipart Features
        arcpy.Dissolve_management(in_features=fout1,
                                  out_feature_class=fout,
                                  dissolve_field="Text",
                                  statistics_fields="",
                                  multi_part="MULTI_PART",
                                  unsplit_lines="DISSOLVE_LINES")

        #Delete temp shapefile
        try:
            arcpy.Delete_management(in_features=fout1, data_type="ShapeFile")
        except:
            pass            
        
        

        #Delete if merge is false otherwise merge
        try:

            #Append data
            fields = ['NAME',
                      'Shape@']

            fields2 = ['Text',
                      'Shape@']

            Scursor = arcpy.da.SearchCursor(fout,fields2)
            #geometry dictionary
            BasinGeomDict = {}
            
            #build dictionary of basin geometries
            for row in Scursor:
                Name = Scursor[0]
                Geom = Scursor[1]
                BasinGeomDict[Name] = Geom               
            
            del Scursor
            #Create update cursor
            #Update Cursor                            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:
            
                try:
                    Geom = BasinGeomDict[row[0]]
                    
                    row[1] = Geom #Assing new geometry
                    
                    #Only updates valid geometry data.
                    cursorUpdate.updateRow(row)
                    
                except:
                    continue
                
            del cursorUpdate

            #Delete Shapefile
            try:
                arcpy.Delete_management(in_data=fout1, data_type="ShapeFile")
            except:
                pass


        except:            
            arcpy.GetMessages()
            
    except:            
        arcpy.GetMessages()




