#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Cross Section module
##########################################################################################################################
def UpdateXsecs(infc1, Merge, Filestem, ScenDict):


##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR_XSECT"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'ISPLACED',
                  'LID',
                  'XSECT_TYPE',
                  'SCENARIO',
                  'Comment',
                  'SHAPE_ISCLOSED',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_LID = fields.index('LID')
        GDB_XSECT_TYPE = fields.index('XSECT_TYPE')
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_Comment = fields.index('Comment')
        GDB_SHAPE_ISCLOSED = fields.index('SHAPE_ISCLOSED')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:
        
            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False                
                        header_row = iccsv.csv_parseline(line)
                        
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Type = header_row.index("Type")
                        CSV_Lid = header_row.index("Lid")
                        CSV_Comment = header_row.index("Comment")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                        CSV_ShapeIsClosed = header_row.index("ShapeIsClosed")     
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        data[CSV_ShapeIsClosed] = int(data[CSV_ShapeIsClosed])
                        data[CSV_Type] = int(data[CSV_Type])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_XSECT_TYPE] = data[CSV_Type]
                                row[GDB_LID] = data[CSV_Lid]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_ISPLACED] = data[CSV_IsPlaced]
                                row[GDB_SHAPE_ISCLOSED] = data[CSV_ShapeIsClosed]
                                row[GDB_XSECT_TYPE] = data[CSV_Type]
                                
                                #Scenario Name
                                row[GDB_SCENARIO] = ScenDict[data[CSV_ParentID]][1]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],data[CSV_Type],data[CSV_IsPlaced]]
                                
                            del cursorUpdate

                        #Add new data
                        else:
                            
                            ICPR_GUID = data[CSV_ID]
                            NAME = data[CSV_Name]
                            XSECT_TYPE = data[CSV_Type]
                            LID = data[CSV_Lid]
                            Comment = data[CSV_Comment]
                            ISPLACED = data[CSV_IsPlaced]
                            SHAPE_ISCLOSED = data[CSV_ShapeIsClosed]
                            TYPE = data[CSV_Type]
                            
                            #Scenario Name
                            SCENARIO = ScenDict[data[CSV_ParentID]][1]

                            In_Data = (NAME,
                                       ISPLACED,
                                       LID,
                                       XSECT_TYPE,
                                       SCENARIO,
                                       Comment,
                                       SHAPE_ISCLOSED,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)                                         
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],data[CSV_Type],data[CSV_IsPlaced]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()


    #Add remaining data for channel cross-sections
    try:
        
        #Output
        outfc = "ICPR_XSECT"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Channel.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'CONVEYANCE_METHOD',
                  'LSTATION_OVERBANK',
                  'RSTATION_OVERBANK',
                  'XSECT_TYPE',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_CONVEYANCE_METHOD = fields.index('CONVEYANCE_METHOD')
        GDB_LSTATION_OVERBANK = fields.index('LSTATION_OVERBANK')
        GDB_RSTATION_OVERBANK = fields.index('RSTATION_OVERBANK')
        GDB_XSECT_TYPE = fields.index('XSECT_TYPE')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create Channel dict
        ChanDict = {}
        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_ConveyanceMethod = header_row.index("ConveyanceMethod")
                    CSV_LeftOverbankStation = header_row.index("LeftOverbankStation")
                    CSV_RightOverbankStation = header_row.index("RightOverbankStation")   
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_ConveyanceMethod] = int(data[CSV_ConveyanceMethod])
                    data[CSV_LeftOverbankStation] = float(data[CSV_LeftOverbankStation])
                    data[CSV_RightOverbankStation] = float(data[CSV_RightOverbankStation])
                    
                    
                    #Create where clause
                    expression = "ICPR_GUID" + " = " + "'" + data[CSV_ParentID] + "'"
                                
                    cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
         
                    #Determine is cursor is empty
                    i = 0
                    for row in cursorUpdate:
                        i = i + 1
                        if i >=1:
                            break
                            
                    #Reset cursor
                    cursorUpdate.reset()

                    #If cursor has data update data
                    if i!=0:

                        for row in cursorUpdate:
                            
                            row[GDB_CONVEYANCE_METHOD] = data[CSV_ConveyanceMethod]
                            row[GDB_LSTATION_OVERBANK] = data[CSV_LeftOverbankStation]
                            row[GDB_RSTATION_OVERBANK] = data[CSV_RightOverbankStation]

                            #Update Channel Data
                            if row[GDB_XSECT_TYPE] == 71:                                                      
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                ChanDict[data[CSV_ID]]= row[GDB_NAME]
                            
                        del cursorUpdate                     
    except:

        arcpy.GetMessages()


    #Create Weir Dict
    WeirDict = {}

    try:
        
        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Weir.csv"

                #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")  
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Populate Weir dictionary
                    if data[CSV_ParentID] in AddDict:
                        
                        WeirDict[data[CSV_ID]] = AddDict[data[CSV_ParentID]][1]
                        
                    else:
                        
                        WeirDict[data[CSV_ID]] = UpDict[data[CSV_ParentID]][1]

    except:
        arcpy.GetMessages()       

        

##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:            
        #Output
        outfc = "ICPR_XSECT"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Shape_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:

           #Flags for feature geometry data
            Pnts_done = False
            Pnts = []
            Guid_Old = None
            GeomDict = {}#geometry dicationary
            
            
            with open(infc,'r') as csv_file:
                first = True
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex = header_row.index("Vertex")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        Guid_New = data[CSV_ParentID]
                        
                        #Initialize old GUID.  Only happens during the first pass.
                        if Guid_Old == None:
                            Guid_Old = data[CSV_ParentID]
                        
                        #Check if point array is done
                        if Guid_Old != Guid_New:                                                     
                            
                            GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                            Guid_Old = Guid_New #Reset old GUID
                            Pnts = [] #Empty array
                            
                            
                        
                        #Create point
                        pnt = (data[CSV_X],data[CSV_Y])
                        Pnts.append(pnt)                                
        
            #Add last record to dictionary
            GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.              
            
        except:
        
            arcpy.GetMessages()
        
        #Write geometry data to feature class           
        fields = ['ICPR_GUID',
                  'Shape@']

        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPE = fields.index('Shape@')
        
        cursorUpdate = arcpy.da.UpdateCursor(outfc,fields) 
        
        for row in cursorUpdate:
            try:
                Guid = row[GDB_ICPR_GUID]
                Geom = GeomDict[Guid]
                
                #add geometry
                row[GDB_SHAPE] = Geom
                cursorUpdate.updateRow(row)
                
            except:
                continue

        del cursorUpdate
        

    except:
        arcpy.GetMessages()

##########################################################################################################################
#Update channel cross section station elevation data
##########################################################################################################################

    try:
                
        #Output
        outfc = "ICPR_XSECT_STATIONS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Channel_Bottom_Point.csv"        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete data in table
        arcpy.DeleteRows_management(outfc)

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'STATION',
                  'ELEV',
                  'MANNINGS_N',
                  'ISSTATION',
                  'PT_ORDER',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_STATION = fields.index('STATION')
        GDB_ELEV = fields.index('ELEV')
        GDB_MANNINGS_N = fields.index('MANNINGS_N')
        GDB_ISSTATION = fields.index('ISSTATION')
        GDB_PT_ORDER = fields.index('PT_ORDER')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')  
        cursorInsert = arcpy.da.InsertCursor(outfc, fields)        

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Order = header_row.index("Order")
                    CSV_Station = header_row.index("Station")
                    CSV_Elevation = header_row.index("Elevation")
                    CSV_ManningsN = header_row.index("ManningsN")                    
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_Order] = int(data[CSV_Order])
                    data[CSV_Station] = float(data[CSV_Station])
                    data[CSV_Elevation] = float(data[CSV_Elevation])
                    data[CSV_ManningsN] = float(data[CSV_ManningsN])                    
                        
                    
                    
                    NAME = ChanDict[data[CSV_ParentID]]
                    STATION = data[CSV_Station]
                    ELEV = data[CSV_Elevation]
                    MANNINGS_N = data[CSV_ManningsN]
                    ISSTATION = 1
                    PT_ORDER = data[CSV_Order]
                    ICPR_GUID = data[CSV_ID]

                    In_Data = (NAME,
                               STATION,
                               ELEV,
                               MANNINGS_N,
                               ISSTATION,
                               PT_ORDER,
                               ICPR_GUID)   

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)                                                             
                    
        del cursorInsert
                    
    except:

        arcpy.GetMessages()

##########################################################################################################################
#Update Channel Lids cross section station elevation data
##########################################################################################################################

    try:
        
        #Output
        outfc = "ICPR4_XSECT_CHANNEL_LID_POINTS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Channel_Lid_Point.csv"        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete data in table
        arcpy.DeleteRows_management(outfc)

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'STATION',
                  'ELEV',
                  'MANNINGS_N',
                  'PT_ORDER',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_STATION = fields.index('STATION')
        GDB_ELEV = fields.index('ELEV')
        GDB_MANNINGS_N = fields.index('MANNINGS_N')
        GDB_PT_ORDER = fields.index('PT_ORDER')
        GDB_ICPR_GUID = fields.index('ICPR_GUID') 
        cursorInsert = arcpy.da.InsertCursor(outfc, fields)        

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Order = header_row.index("Order")
                    CSV_Station = header_row.index("Station")
                    CSV_Elevation = header_row.index("Elevation")
                    CSV_ManningsN = header_row.index("ManningsN")                    
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_Order] = int(data[CSV_Order])
                    data[CSV_Station] = float(data[CSV_Station])
                    data[CSV_Elevation] = float(data[CSV_Elevation])
                    data[CSV_ManningsN] = float(data[CSV_ManningsN])  
                    
                    NAME = ChanDict[data[CSV_ParentID]]
                    STATION = data[CSV_Station]
                    ELEV = data[CSV_Elevation]
                    MANNINGS_N = data[CSV_ManningsN]
                    PT_ORDER = data[CSV_Order]
                    ICPR_GUID = data[CSV_ID]

                    In_Data = (NAME,
                               STATION,
                               ELEV,
                               MANNINGS_N,
                               PT_ORDER,
                               ICPR_GUID)   

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)                                         
                                                
        del cursorInsert
                    
    except:

        arcpy.GetMessages()

##########################################################################################################################
#Update weirs cross section station elevation data
##########################################################################################################################

    try:
        
        #Output
        outfc = "ICPR_XSECT_STATIONS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Weir_Bottom_Point.csv"        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'STATION',
                  'ELEV',
                  'ISSTATION',
                  'PT_ORDER',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_STATION = fields.index('STATION')
        GDB_ELEV = fields.index('ELEV')
        GDB_ISSTATION = fields.index('ISSTATION')
        GDB_PT_ORDER = fields.index('PT_ORDER')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        cursorInsert = arcpy.da.InsertCursor(outfc, fields)        

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Order = header_row.index("Order")
                    CSV_Station = header_row.index("Station")
                    CSV_Elevation = header_row.index("Elevation")                  
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_Order] = int(data[CSV_Order])
                    data[CSV_Station] = float(data[CSV_Station])
                    data[CSV_Elevation] = float(data[CSV_Elevation])                   
                    
                    NAME = WeirDict[data[CSV_ParentID]]
                    STATION = data[CSV_Station]
                    ELEV = data[CSV_Elevation]                    
                    ISSTATION = 1
                    PT_ORDER = data[CSV_Order]
                    ICPR_GUID = data[CSV_ID]

                    In_Data = (NAME,
                               STATION,
                               ELEV,
                               ISSTATION,
                               PT_ORDER,
                               ICPR_GUID)   

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)                                         
                                        
        del cursorInsert
                    
    except:

        arcpy.GetMessages()


##########################################################################################################################
#Update weir lids cross section station elevation data
##########################################################################################################################

    try:
        
        #Output
        outfc = "ICPR4_XSECT_WEIR_LID_POINTS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "CrossSection_Weir_Lid_Point.csv"        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'STATION',
                  'ELEV',
                  'PT_ORDER',
                  'ICPR_GUID']                  
                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_STATION = fields.index('STATION')
        GDB_ELEV = fields.index('ELEV')
        GDB_PT_ORDER = fields.index('PT_ORDER')
        GDB_ICPR_GUID = fields.index('ICPR_GUID') 
        
        cursorInsert = arcpy.da.InsertCursor(outfc, fields)        

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False                
                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Order = header_row.index("Order")
                    CSV_Station = header_row.index("Station")
                    CSV_Elevation = header_row.index("Elevation")                  
                    
                else:

                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_Order] = int(data[CSV_Order])
                    data[CSV_Station] = float(data[CSV_Station])
                    data[CSV_Elevation] = float(data[CSV_Elevation])  
                    
                    NAME = WeirDict[data[CSV_ParentID]]
                    STATION = data[CSV_Station]
                    ELEV = data[CSV_Elevation]
                    PT_ORDER = data[CSV_Order]
                    ICPR_GUID = data[CSV_ID]

                    In_Data = (NAME,
                               STATION,
                               ELEV,
                               PT_ORDER,
                               ICPR_GUID)   

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)                                         
                                        
        del cursorInsert
                    
    except:

        arcpy.GetMessages()

