#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Weir module
##########################################################################################################################
def UpdateWeir(infc1, Merge, Filestem, LAddDict, LUpDict,PipeGeomCode,WeirOrienDict,WeirGeomDict):


##########################################################################################################################
#Update attribute table data and no geometry data - Weirs
##########################################################################################################################
    try:

        #Output
        outfc = "WEIR"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_Weir.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['WEIR_SHAPE_DESC',
                  'WEIR_TYPE_DESC',
                  'WEIR_SPAN_MS',
                  'WEIR_RISE_MS',
                  'WEIR_INVERT_ELEVATION_MS',
                  'CONTROL_ELEVATION_MS',
                  'WEIR_BOTTOMCLIP_MS',
                  'BOTTOMCLIP_OPTABLE',
                  'BOTTOMCLIP_NODE',
                  'WEIR_TOPCLIP_MS',
                  'TOPCLIP_OPTABLE',
                  'TOPCLIP_NODE',
                  'WEIR_DISCHARGE_COEF_VAL',
                  'WEIRCOEF_OPTABLE',
                  'ORIFICE_DISCHARGE_COEF_VAL',
                  'ORIFICECOEF_OPTABLE',
                  'DROPSTRUCTURE_ID',
                  'SECTION_NAME',
                  'LEFTSIDE_SLOPE_VAL',
                  'RIGHTSIDE_SLOPE_VAL',
                  'WEIR_BOTTOM_WIDTH_MS',
                  'WEIR_ORIENTATION_DESC',
                  'SUBELEMENT_INDEX_CNT',
                  'ICPR_LINK_NAME',
                  'DAMPENING_THRESHOLD',
                  'EXTRAPOLATION_METHOD',
                  'FILLET',
                  'ICPR_GUID']
        
        #List index
        GDB_WEIR_SHAPE_DESC = fields.index('WEIR_SHAPE_DESC')
        GDB_WEIR_TYPE_DESC = fields.index('WEIR_TYPE_DESC')
        GDB_WEIR_SPAN_MS = fields.index('WEIR_SPAN_MS')
        GDB_WEIR_RISE_MS = fields.index('WEIR_RISE_MS')
        GDB_WEIR_INVERT_ELEVATION_MS = fields.index('WEIR_INVERT_ELEVATION_MS')
        GDB_CONTROL_ELEVATION_MS = fields.index('CONTROL_ELEVATION_MS')
        GDB_WEIR_BOTTOMCLIP_MS = fields.index('WEIR_BOTTOMCLIP_MS')
        GDB_BOTTOMCLIP_OPTABLE = fields.index('BOTTOMCLIP_OPTABLE')
        GDB_BOTTOMCLIP_NODE = fields.index('BOTTOMCLIP_NODE')
        GDB_WEIR_TOPCLIP_MS = fields.index('WEIR_TOPCLIP_MS')
        GDB_TOPCLIP_OPTABLE = fields.index('TOPCLIP_OPTABLE')
        GDB_TOPCLIP_NODE = fields.index('TOPCLIP_NODE')
        GDB_WEIR_DISCHARGE_COEF_VAL = fields.index('WEIR_DISCHARGE_COEF_VAL')
        GDB_WEIRCOEF_OPTABLE = fields.index('WEIRCOEF_OPTABLE')
        GDB_ORIFICE_DISCHARGE_COEF_VAL = fields.index('ORIFICE_DISCHARGE_COEF_VAL')
        GDB_ORIFICECOEF_OPTABLE = fields.index('ORIFICECOEF_OPTABLE')
        GDB_DROPSTRUCTURE_ID = fields.index('DROPSTRUCTURE_ID')
        GDB_SECTION_NAME = fields.index('SECTION_NAME')
        GDB_LEFTSIDE_SLOPE_VAL = fields.index('LEFTSIDE_SLOPE_VAL')
        GDB_RIGHTSIDE_SLOPE_VAL = fields.index('RIGHTSIDE_SLOPE_VAL')
        GDB_WEIR_BOTTOM_WIDTH_MS = fields.index('WEIR_BOTTOM_WIDTH_MS')
        GDB_WEIR_ORIENTATION_DESC = fields.index('WEIR_ORIENTATION_DESC')
        GDB_SUBELEMENT_INDEX_CNT = fields.index('SUBELEMENT_INDEX_CNT')
        GDB_ICPR_LINK_NAME = fields.index('ICPR_LINK_NAME')
        GDB_DAMPENING_THRESHOLD = fields.index('DAMPENING_THRESHOLD')
        GDB_EXTRAPOLATION_METHOD = fields.index('EXTRAPOLATION_METHOD')
        GDB_FILLET = fields.index('FILLET')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_WeirType = header_row.index("WeirType")
                        CSV_Geometry = header_row.index("Geometry")
                        CSV_Invert = header_row.index("Invert")
                        CSV_ControlElevation = header_row.index("ControlElevation")
                        CSV_CrossSection = header_row.index("CrossSection")
                        CSV_ExtrapolationMethod = header_row.index("ExtrapolationMethod")
                        CSV_MaxDepth = header_row.index("MaxDepth")
                        CSV_MaxWidth = header_row.index("MaxWidth")
                        CSV_Fillet = header_row.index("Fillet")
                        CSV_BottomWidth = header_row.index("BottomWidth")
                        CSV_LeftSideSlope = header_row.index("LeftSideSlope")
                        CSV_RightSideSlope = header_row.index("RightSideSlope")
                        CSV_BottomClip = header_row.index("BottomClip")
                        CSV_TopClip = header_row.index("TopClip")
                        CSV_WeirDischargeCoef = header_row.index("WeirDischargeCoef")
                        CSV_OrificeDischargeCoef = header_row.index("OrificeDischargeCoef")
                        CSV_BottomClipTable = header_row.index("BottomClipTable")
                        CSV_TopClipTable = header_row.index("TopClipTable")
                        CSV_WeirDischargeCoefTable = header_row.index("WeirDischargeCoefTable")
                        CSV_OrificeDischargeCoefTable = header_row.index("OrificeDischargeCoefTable")
                        CSV_Node_BottomClip = header_row.index("Node_BottomClip")
                        CSV_Node_TopClip = header_row.index("Node_TopClip")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_WeirType] = int(data[CSV_WeirType])
                        data[CSV_Geometry] = int(data[CSV_Geometry])
                        data[CSV_Invert] = float(data[CSV_Invert])
                        data[CSV_ControlElevation] = float(data[CSV_ControlElevation])
                        data[CSV_ExtrapolationMethod] = int(data[CSV_ExtrapolationMethod])
                        data[CSV_MaxDepth] = float(data[CSV_MaxDepth])
                        data[CSV_MaxWidth] = float(data[CSV_MaxWidth])
                        data[CSV_Fillet] = float(data[CSV_Fillet])
                        data[CSV_BottomWidth] = float(data[CSV_BottomWidth])
                        data[CSV_LeftSideSlope] = float(data[CSV_LeftSideSlope])
                        data[CSV_RightSideSlope] = float(data[CSV_RightSideSlope])
                        data[CSV_BottomClip] = float(data[CSV_BottomClip])
                        data[CSV_TopClip] = float(data[CSV_TopClip])
                        data[CSV_WeirDischargeCoef] = float(data[CSV_WeirDischargeCoef])
                        data[CSV_OrificeDischargeCoef] = float(data[CSV_OrificeDischargeCoef])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                        
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:

                            i = i + 1
                            if i >=1:
                                break
                        
                        #Reset cursor
                        cursorUpdate.reset()                

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ########################
                                #Determine Span
                                ########################
                                #Cirular
                                if WeirGeomDict[data[CSV_Geometry]] == 0:

                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Horizontal Ellipse
                                elif WeirGeomDict[data[CSV_Geometry]] == 1:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1.56

                                #Vertical Ellipse
                                elif WeirGeomDict[data[CSV_Geometry]] == 2:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*(1/1.56)

                                #Arch No Plate
                                elif WeirGeomDict[data[CSV_Geometry]] == 3:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*(1.607)

                                #Egg Shaped
                                elif WeirGeomDict[data[CSV_Geometry]] == 8:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*(2/3)

                                #Horseshoe
                                elif WeirGeomDict[data[CSV_Geometry]] == 9:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Gothic
                                elif WeirGeomDict[data[CSV_Geometry]] == 10:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.84

                                #Catenary
                                elif WeirGeomDict[data[CSV_Geometry]] == 11:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.9

                                #Basket Handle
                                elif WeirGeomDict[data[CSV_Geometry]] == 12:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.944

                                #Semi-Circular
                                elif WeirGeomDict[data[CSV_Geometry]] == 13:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1.64

                                #Semi-Elliptical
                                elif WeirGeomDict[data[CSV_Geometry]] == 14:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Con Span
                                elif WeirGeomDict[data[CSV_Geometry]] == 18:
                                    row[GDB_WEIR_RISE_MS] = None
                                    row[GDB_WEIR_SPAN_MS] = None

                                #Arch/Rectangular/V-Notch/Parabolic
                                else:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxWidth]*12


                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_ICPR_LINK_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_ICPR_LINK_NAME] = LAddDict[data[CSV_ParentID]][1]

                                ##################################
                                #Process data for direct transfer
                                ##################################

                                row[GDB_WEIR_SHAPE_DESC] = WeirGeomDict[data[CSV_Geometry]]
                                row[GDB_WEIR_TYPE_DESC] = WeirOrienDict[data[CSV_WeirType]][1]
                                row[GDB_WEIR_INVERT_ELEVATION_MS] = data[CSV_Invert]
                                row[GDB_CONTROL_ELEVATION_MS] = data[CSV_ControlElevation]
                                row[GDB_WEIR_BOTTOMCLIP_MS] = data[CSV_BottomClip]*12
                                row[GDB_BOTTOMCLIP_OPTABLE] = data[CSV_BottomClipTable]
                                row[GDB_BOTTOMCLIP_NODE] = data[CSV_Node_BottomClip]
                                row[GDB_WEIR_TOPCLIP_MS] = data[CSV_TopClip]*12
                                row[GDB_TOPCLIP_OPTABLE] = data[CSV_TopClipTable]
                                row[GDB_TOPCLIP_NODE] = data[CSV_Node_TopClip]
                                row[GDB_WEIR_DISCHARGE_COEF_VAL] = data[CSV_WeirDischargeCoef]
                                row[GDB_WEIRCOEF_OPTABLE] = data[CSV_WeirDischargeCoefTable]
                                row[GDB_ORIFICE_DISCHARGE_COEF_VAL] = data[CSV_OrificeDischargeCoef]
                                row[GDB_ORIFICECOEF_OPTABLE] = data[CSV_OrificeDischargeCoefTable]
                                row[GDB_SECTION_NAME] = data[CSV_CrossSection]
                                row[GDB_LEFTSIDE_SLOPE_VAL] = data[CSV_LeftSideSlope]
                                row[GDB_RIGHTSIDE_SLOPE_VAL] = data[CSV_RightSideSlope]
                                row[GDB_WEIR_BOTTOM_WIDTH_MS] = data[CSV_BottomWidth]
                                row[GDB_WEIR_ORIENTATION_DESC] = WeirOrienDict[data[CSV_WeirType]][0]
                                row[GDB_SUBELEMENT_INDEX_CNT] = 1
                                row[GDB_DAMPENING_THRESHOLD] = data[CSV_DampeningThreshold]
                                row[GDB_EXTRAPOLATION_METHOD] = data[CSV_ExtrapolationMethod]
                                row[GDB_FILLET] = data[CSV_Fillet]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]
                                
                            del cursorUpdate                       

                        ###############
                        #Add new data
                        ###############
                        else:
                            
                            ########################
                            #Determine Span
                            ########################
                            #Cirular
                            if WeirGeomDict[data[CSV_Geometry]] == 0:

                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Horizontal Ellipse
                            elif WeirGeomDict[data[CSV_Geometry]] == 1:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1.56

                            #Vertical Ellipse
                            elif WeirGeomDict[data[CSV_Geometry]] == 2:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*(1/1.56)

                            #Arch No Plate
                            elif WeirGeomDict[data[CSV_Geometry]] == 3:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*(1.607) 

                            #Egg Shaped
                            elif WeirGeomDict[data[CSV_Geometry]] == 8:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*(2/3)

                            #Horseshoe
                            elif WeirGeomDict[data[CSV_Geometry]] == 9:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Gothic
                            elif WeirGeomDict[data[CSV_Geometry]] == 10:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.84

                            #Catenary
                            elif WeirGeomDict[data[CSV_Geometry]] == 11:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.9

                            #Basket Handle
                            elif WeirGeomDict[data[CSV_Geometry]] == 12:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.944

                            #Semi-Circular
                            elif WeirGeomDict[data[CSV_Geometry]] == 13:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1.64

                            #Semi-Elliptical
                            elif WeirGeomDict[data[CSV_Geometry]] == 14:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Con Span
                            elif WeirGeomDict[data[CSV_Geometry]] == 18:
                                WEIR_RISE_MS = None
                                WEIR_SPAN_MS = None

                            #Arch/Rectangular/V-Notch/Parabolic
                            else:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxWidth]*12


                            #################################
                            #Assign Link name
                            #################################
                            try:
                                ICPR_LINK_NAME = LUpDict[data[CSV_ParentID]][1]
                            except:
                                ICPR_LINK_NAME = LAddDict[data[CSV_ParentID]][1]

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            WEIR_SHAPE_DESC = WeirGeomDict[data[CSV_Geometry]]
                            WEIR_TYPE_DESC = WeirOrienDict[data[CSV_WeirType]][1]
                            WEIR_INVERT_ELEVATION_MS = data[CSV_Invert]
                            CONTROL_ELEVATION_MS = data[CSV_ControlElevation]
                            WEIR_BOTTOMCLIP_MS = data[CSV_BottomClip]*12
                            BOTTOMCLIP_OPTABLE = data[CSV_BottomClipTable]
                            BOTTOMCLIP_NODE = data[CSV_Node_BottomClip]
                            WEIR_TOPCLIP_MS = data[CSV_TopClip]*12
                            TOPCLIP_OPTABLE = data[CSV_TopClipTable]
                            TOPCLIP_NODE = data[CSV_Node_TopClip]
                            WEIR_DISCHARGE_COEF_VAL = data[CSV_WeirDischargeCoef]
                            WEIRCOEF_OPTABLE = data[CSV_WeirDischargeCoefTable]
                            ORIFICE_DISCHARGE_COEF_VAL = data[CSV_OrificeDischargeCoef]
                            ORIFICECOEF_OPTABLE = data[CSV_OrificeDischargeCoefTable]
                            SECTION_NAME = data[CSV_CrossSection]
                            LEFTSIDE_SLOPE_VAL = data[CSV_LeftSideSlope]
                            RIGHTSIDE_SLOPE_VAL = data[CSV_RightSideSlope]
                            WEIR_BOTTOM_WIDTH_MS = data[CSV_BottomWidth]
                            WEIR_ORIENTATION_DESC = WeirOrienDict[data[CSV_WeirType]][0]
                            SUBELEMENT_INDEX_CNT = 1
                            DAMPENING_THRESHOLD = data[CSV_DampeningThreshold]
                            EXTRAPOLATION_METHOD = data[CSV_ExtrapolationMethod]
                            FILLET = data[CSV_Fillet]
                            ICPR_GUID = data[CSV_ID]
                            DROPSTRUCTURE_ID = None
                           
                            #New Record Data
                            In_Data = [WEIR_SHAPE_DESC,
                                       WEIR_TYPE_DESC,
                                       WEIR_SPAN_MS,
                                       WEIR_RISE_MS,
                                       WEIR_INVERT_ELEVATION_MS,
                                       CONTROL_ELEVATION_MS,
                                       WEIR_BOTTOMCLIP_MS,
                                       BOTTOMCLIP_OPTABLE,
                                       BOTTOMCLIP_NODE,
                                       WEIR_TOPCLIP_MS,
                                       TOPCLIP_OPTABLE,
                                       TOPCLIP_NODE,
                                       WEIR_DISCHARGE_COEF_VAL,
                                       WEIRCOEF_OPTABLE,
                                       ORIFICE_DISCHARGE_COEF_VAL,
                                       ORIFICECOEF_OPTABLE,
                                       DROPSTRUCTURE_ID,
                                       SECTION_NAME,
                                       LEFTSIDE_SLOPE_VAL,
                                       RIGHTSIDE_SLOPE_VAL,
                                       WEIR_BOTTOM_WIDTH_MS,
                                       WEIR_ORIENTATION_DESC,
                                       SUBELEMENT_INDEX_CNT,
                                       ICPR_LINK_NAME,
                                       DAMPENING_THRESHOLD,
                                       EXTRAPOLATION_METHOD,
                                       FILLET,
                                       ICPR_GUID]

                            #Insert new record
                            cursorInsert.insertRow(In_Data)                                           

                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in AddDict:
                    if row[GDB_ICPR_GUID] not in UpDict:
                        if row[GDB_ICPR_LINK_NAME] is not None:
                            if len(row[GDB_ICPR_LINK_NAME])>0:
                                if row[GDB_DROPSTRUCTURE_ID] is not None:
                                    if row[GDB_DROPSTRUCTURE_ID] < 0:
                                        cursorUpdate.deleteRow()
                                if row[GDB_DROPSTRUCTURE_ID] is None:
                                    cursorUpdate.deleteRow()

            del cursorUpdate
    except:
        arcpy.GetMessages()
