#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_WeirDischargeCoeff(infc1, Merge, Filestem, ScenDict):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_WeirCoefOpTable"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "WeirDischargeCoefTable.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Name',
                  'Comment',
                  'Scenario',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Comment = fields.index('Comment')
        GDB_Scenario = fields.index('Scenario')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_Scenario]=ScenDict[data[CSV_ParentID]][1]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            Comment = data[CSV_Comment]
                            Scenario = ScenDict[data[CSV_ParentID]][1]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (Name,
                                       Comment,
                                       Scenario,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                            
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_WeirCoefOpTable_PTs"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "WeirDischargeCoefTable_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['NAME',
                      'UpstreamDepth',
                      'DischargeCoef',
                      'ICPR_GUID']

            GDB_NAME = fields.index('NAME')
            GDB_UpstreamDepth = fields.index('UpstreamDepth')
            GDB_DischargeCoef = fields.index('DischargeCoef')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:
                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_UpstreamDepth = header_row.index("UpstreamDepth")
                        CSV_DischargeCoef = header_row.index("DischargeCoef")                
                        
                    else:

                        data = iccsv.csv_parseline(line)

                        #Date
                        data[CSV_UpstreamDepth] = float(data[CSV_UpstreamDepth])
                        data[CSV_DischargeCoef] = float(data[CSV_DischargeCoef])
                        
                        #Populate Name
                        try:                    
                            NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            NAME = UpDict[data[CSV_ParentID]][1]
                            
                        UpstreamDepth = data[CSV_UpstreamDepth]
                        DischargeCoef = data[CSV_DischargeCoef]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (NAME,
                                   UpstreamDepth,
                                   DischargeCoef,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursor.insertRow(In_Data)       
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
