#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase


import arcpy
import iccsv

#Scenario module
######################################################################################################
######################################################################################################

def UpdateScenario(infc, Merge, Filestem):

    try:

        #Output
        outfc = "ICPR4_SCENARIO"

        #Input
        infc = infc + "\\" + Filestem + "_" + "Scenario.csv"

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'IID',
                  'COMMENT',
                  'ICPR_GUID']
        
        #List index
        GDB_Name = fields.index('NAME')
        GDB_Iid = fields.index('IID')
        GDB_Comment = fields.index('COMMENT')
        ICPR_GUID = fields.index('ICPR_GUID')

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass


        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)                
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")
                        CSV_IID = header_row.index("IID")         
                        
                    else:
                        data = iccsv.csv_parseline(line)

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                            
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Iid] = data[CSV_IID]
                                row[GDB_Comment] = data[CSV_Comment]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                                del cursorUpdate

                        #Add new data
                        else:
                            #Insert new record
                            cursorInsert.insertRow([data[CSV_Name],
                                             data[CSV_IID],
                                             data[CSV_Comment],
                                             data[CSV_ID]])
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert  
                
    except:
        arcpy.GetMessages()


    #Cycle through and delete values if required
    try:
            ScenDict = {}
            
            if Merge == False:
                
                cursor = arcpy.da.UpdateCursor(outfc, fields)
                for row in cursor:
                    
                    if row[ICPR_GUID] not in AddDict and row[ICPR_GUID] not in UpDict:
                        
                        cursor.deleteRow()

                    else:

                        ScenDict[row[ICPR_GUID]] = [row[ICPR_GUID],row[GDB_Name]]

                del cursor

            if Merge == True:
                
                cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
                
                for row in cursorUpdate:
                    
                    ScenDict[row[ICPR_GUID]] = [row[ICPR_GUID],row[GDB_Name]]

                del cursorUpdate
                    

            #Scenario Dictionary
            return ScenDict


    except:
        
        arcpy.GetMessages()
            
    
