#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_RefPoint(infc1, Merge, Filestem, ScenDict):

##########################################################################################################################
#Update attribute table data and geometry for Node Points
##########################################################################################################################

    try:
        
        #Output
        outfc = "Reference_Element_Point"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RE_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass


        #Fields for update of existing elements/features
        fields = ['Name',
                  'Comment',
                  'ICPR_GUID',
                  'Scenario',
                  'Shape@']
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_Comment = fields.index('Comment')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Scenario = fields.index('Scenario')
        GDB_Shape = fields.index('Shape@')


        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Name = header_row.index("Name")
                    CSV_Comment = header_row.index("Comment")
                    CSV_ShapeX = header_row.index("ShapeX")
                    CSV_ShapeY = header_row.index("ShapeY")        
                    
                else:
                    
                    data = iccsv.csv_parseline(line)                        
                                   
                    data[CSV_ShapeX] = float(data[CSV_ShapeX])
                    data[CSV_ShapeY] = float(data[CSV_ShapeY])

                    #Create where clause
                    expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                
                    cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
         
                    #Determine is cursor is empty
                    i = 0
                    for row in cursorUpdate:
                        i = i + 1
                        if i >=1:
                            break
                        
                    #Reset cursor
                    cursorUpdate.reset()

                    #If cursor has data update data
                    if i!=0:

                        for row in cursorUpdate:
                            
                            row[GDB_Name] = data[CSV_Name]
                            row[GDB_Scenario] = ScenDict[data[CSV_ParentID]][1]                                
                            row[GDB_Comment] = data[CSV_Comment]
                            row[GDB_ICPR_GUID] = data[CSV_ID]

                            XY_Point = (data[CSV_ShapeX],data[CSV_ShapeY])
                            row[GDB_Shape] = XY_Point
                                
                            #update row if geometry is valid
                            try:
                                cursorUpdate.updateRow(row)
                            except:
                                pass
                            
                            #Updated Features
                            UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                        del cursorUpdate

                    #Add new data
                    else:                                                                            
                        
                        Name =  data[CSV_Name]
                        Comment = data[CSV_Comment]
                        Scenario = ScenDict[data[CSV_ParentID]][1]
                        ICPR_GUID = data[CSV_ID]
                        Shape = (data[CSV_ShapeX],data[CSV_ShapeY])

                        In_Data =  (Name,
                                   Comment,
                                   ICPR_GUID,
                                   Scenario,
                                   Shape)

                        #Insert new record if geometry is valid
                        try:
                            cursorInsert.insertRow(In_Data)                                             
                        except:
                            pass
                        
                        #Added features/data
                        AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
            del cursorInsert

                     
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()
