#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_RatingCurveTable(infc1, Merge, Filestem, ScenDict):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_RatingCurveOpTable"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RatingCurveTable.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass
        
        #Code Changes for rating curves (Description, GDB Domain, ICPR4 Code)
        Rating_Dict = {}
        #Upstream Stage
        Rating_Dict[0]=0
        #Family of Curves
        Rating_Dict[3]=1
        #Time
        Rating_Dict[1]=2
        #Head
        Rating_Dict[2]=3

        #Fields for update of existing elements/features
        fields = ['Name',
                  'Type',
                  'Comment',
                  'Scenario',
                  'ICPR_GUID']
        
        #List index
        GDB_Name = fields.index('Name')
        GDB_Type = fields.index('Type')
        GDB_Comment = fields.index('Comment')
        GDB_Scenario = fields.index('Scenario')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)  
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Type = header_row.index("Type")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        #data
                        data[CSV_Type] = int(data[CSV_Type])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:                        
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Type] = Rating_Dict[data[CSV_Type]]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_Scenario]=ScenDict[data[CSV_ParentID]][1]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:        
                                              
                            Name = data[CSV_Name]
                            Type = Rating_Dict[data[CSV_Type]]
                            Comment = data[CSV_Comment]
                            Scenario=ScenDict[data[CSV_ParentID]][1]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (Name,
                                       Type,
                                       Comment,
                                       Scenario,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_RatingCurveOpTable_PTS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RatingCurveTable_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['NAME',
                      'X',
                      'Y',
                      'Z',
                      'DAY',
                      'MONTH',
                      'YEAR',
                      'ICPR_GUID']

            GDB_NAME = fields.index('NAME')
            GDB_X = fields.index('X')
            GDB_Y = fields.index('Y')
            GDB_Z = fields.index('Z')
            GDB_DAY = fields.index('DAY')
            GDB_MONTH = fields.index('MONTH')
            GDB_YEAR = fields.index('YEAR')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')          
            
            with open(infc,'r') as csv_file:
                                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    
                    if first== True:
                        
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Year = header_row.index("Year")
                        CSV_Month = header_row.index("Month")
                        CSV_Day = header_row.index("Day")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        CSV_Z = header_row.index("Z")
                       
                    else:
                        

                        data = iccsv.csv_parseline(line)

                        #Date
                        data[CSV_Year] = int(data[CSV_Year])
                        data[CSV_Month] = int(data[CSV_Month])
                        data[CSV_Day] = int(data[CSV_Day])
                        data[CSV_X] = float(data[CSV_X])
                        data[CSV_Y] = float(data[CSV_Y])
                        data[CSV_Z] = float(data[CSV_Z])       
                        
                        #Populate Name
                        try:                    
                            NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            NAME = UpDict[data[CSV_ParentID]][1]                        
                            
                        X = data[CSV_X]
                        Y = data[CSV_Y]
                        Z = data[CSV_Z]
                        DAY = data[CSV_Day]
                        MONTH = data[CSV_Month]
                        YEAR = data[CSV_Year]
                        ICPR_GUID = data[CSV_ID]                            

                        In_Data = (NAME,
                                   X,
                                   Y,
                                   Z,
                                   DAY,
                                   MONTH,
                                   YEAR,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert


        except:
            arcpy.AddMessage(arcpy.GetMessages())

    except:
        arcpy.GetMessages()    
