#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Percolation module
##########################################################################################################################
def UpdateRatingCurve(infc1, Merge, Filestem, LAddDict, LUpDict):


##########################################################################################################################
#Create List for names
##########################################################################################################################
    try: 

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_RatingCurve.csv" 

        #Create data dictionaries
        ID_List = {}

        #Read CSV Data
            
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)

                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")

                else:
                    
                    data = iccsv.csv_parseline(line)

                    #Determine Name
                    try: 
                        NAME = LAddDict[data[CSV_ParentID]][1]
                    except:
                        NAME = LUpDict[data[CSV_ParentID]][1]

                    #Populate dict
                    ID_List[data[CSV_ID]] = NAME
                
    except:
        arcpy.GetMessages()

##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_RATINGCURVE"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_RatingCurve_RatingCurveTable.csv"        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete rows
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            arcpy.GetMessages()

        #Fields for update of existing elements/features
        fields = ['RATINGCURVE',
                  'ELEV_ON',
                  'ELEV_ON_NODE',
                  'ELEV_OFF',
                  'ELEV_OFF_NODE',
                  'NAME',
                  'ICPR_GUID']                  

        #Read CSV Data            
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)

                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_RatingCurveTable = header_row.index("RatingCurveTable")
                    CSV_ElevationOn = header_row.index("ElevationOn")
                    CSV_Node_ElevationOn = header_row.index("Node_ElevationOn")
                    CSV_ElevationOff = header_row.index("ElevationOff")
                    CSV_Node_ElevationOff = header_row.index("Node_ElevationOff")

                else:
                    
                    data = iccsv.csv_parseline(line)
                    
                    #Set data formats for non-text used fields
                    data[CSV_ElevationOn] = float(data[CSV_ElevationOn])
                    data[CSV_ElevationOff] = float(data[CSV_ElevationOff])

                    #################################
                    #Assign Link name
                    #################################
                    try:
                        NAME = ID_List[data[CSV_ParentID]]
                    except:
                        NAME = ID_List[data[CSV_ParentID]]
                        
                    ##################################    
                    #Process data for direct transfer
                    ##################################

                    RATINGCURVE = data[CSV_RatingCurveTable]
                    ELEV_ON = data[CSV_ElevationOn]
                    ELEV_ON_NODE = data[CSV_Node_ElevationOn]
                    ELEV_OFF = data[CSV_ElevationOff]
                    ELEV_OFF_NODE = data[CSV_Node_ElevationOff]
                    ICPR_GUID = data[CSV_ID]

                    #New Record Data
                    In_Data = (RATINGCURVE,
                               ELEV_ON,
                               ELEV_ON_NODE,
                               ELEV_OFF,
                               ELEV_OFF_NODE,
                               NAME,
                               ICPR_GUID)

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)           
            del cursorInsert

                
    except:
        arcpy.GetMessages()
