#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Percolation module
##########################################################################################################################
def UpdatePerc(infc1, Merge, Filestem, LAddDict, LUpDict):


##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR_PERCOLATION"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_Percolation.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'SURFAREA_OPTION_DESC',
                  'BOTTOMELEV_MS',
                  'SURFAREA_MS',
                  'VERTFLOW_TERMINATION_DESC',
                  'PERCENT_RATE_VAL',
                  'CONSTANT_RATE_VAL',
                  'AQUIFER_BASE_ELEV_MS',
                  'WATERTABLE_ELEV_MS',
                  'ANNUALRECHARGE_RATE_VAL',
                  'HORIZ_CONDUCTIVITY_VAL',
                  'VERT_CONDUCTIVITY_VAL',
                  'EFFECTIVEPOROSITY_VAL',
                  'LAYERTHICKNESS_VAL',
                  'PERIMETER1_MS',
                  'PERIMETER2_MS',
                  'PERIMETER3_MS',
                  'DISTANCE_1TO2_MS',
                  'DISTANCE_2TO3_MS',
                  'NUMCELLS_1TO2_CNT',
                  'NUMCELLS_2TO3_CNT',
                  'ICPR_GUID']
                  
        #List index 
        GDB_NAME = fields.index('NAME')
        GDB_SURFAREA_OPTION_DESC = fields.index('SURFAREA_OPTION_DESC')
        GDB_BOTTOMELEV_MS = fields.index('BOTTOMELEV_MS')
        GDB_SURFAREA_MS = fields.index('SURFAREA_MS')        
        GDB_VERTFLOW_TERMINATION_DESC = fields.index('VERTFLOW_TERMINATION_DESC')
        GDB_PERCENT_RATE_VAL = fields.index('PERCENT_RATE_VAL')
        GDB_CONSTANT_RATE_VAL = fields.index('CONSTANT_RATE_VAL')
        GDB_AQUIFER_BASE_ELEV_MS = fields.index('AQUIFER_BASE_ELEV_MS')
        GDB_WATERTABLE_ELEV_MS = fields.index('WATERTABLE_ELEV_MS')
        GDB_ANNUALRECHARGE_RATE_VAL = fields.index('ANNUALRECHARGE_RATE_VAL')
        GDB_HORIZ_CONDUCTIVITY_VAL = fields.index('HORIZ_CONDUCTIVITY_VAL')
        GDB_VERT_CONDUCTIVITY_VAL = fields.index('VERT_CONDUCTIVITY_VAL')
        GDB_EFFECTIVEPOROSITY_VAL = fields.index('EFFECTIVEPOROSITY_VAL')
        GDB_LAYERTHICKNESS_VAL = fields.index('LAYERTHICKNESS_VAL')
        GDB_PERIMETER1_MS = fields.index('PERIMETER1_MS')
        GDB_PERIMETER2_MS = fields.index('PERIMETER2_MS')
        GDB_PERIMETER3_MS = fields.index('PERIMETER3_MS')
        GDB_DISTANCE_1TO2_MS = fields.index('DISTANCE_1TO2_MS')
        GDB_DISTANCE_2TO3_MS = fields.index('DISTANCE_2TO3_MS')
        GDB_NUMCELLS_1TO2_CNT = fields.index('NUMCELLS_1TO2_CNT')
        GDB_NUMCELLS_2TO3_CNT = fields.index('NUMCELLS_2TO3_CNT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')     

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_AquiferBaseElev = header_row.index("AquiferBaseElev")
                        CSV_WaterTableElev = header_row.index("WaterTableElev")
                        CSV_AnnualRechargeRate = header_row.index("AnnualRechargeRate")
                        CSV_HorizConductivity = header_row.index("HorizConductivity")
                        CSV_VertConductivity = header_row.index("VertConductivity")
                        CSV_FillablePorosity = header_row.index("FillablePorosity")
                        CSV_LayerThickness = header_row.index("LayerThickness")
                        CSV_SurfAreaOption = header_row.index("SurfAreaOption")
                        CSV_BottomElevation = header_row.index("BottomElevation")
                        CSV_SurfaceArea = header_row.index("SurfaceArea")
                        CSV_VertFlowTermination = header_row.index("VertFlowTermination")
                        CSV_Perimeter1 = header_row.index("Perimeter1")
                        CSV_Perimeter2 = header_row.index("Perimeter2")
                        CSV_Perimeter3 = header_row.index("Perimeter3")
                        CSV_Distance_P1P2 = header_row.index("Distance_P1P2")
                        CSV_Distance_P2P3 = header_row.index("Distance_P2P3")
                        CSV_Cells_P1P2 = header_row.index("Cells_P1P2")
                        CSV_Cells_P2P3 = header_row.index("Cells_P2P3")
                        CSV_PctFinalRate = header_row.index("PctFinalRate")
                        CSV_ConstantRate = header_row.index("ConstantRate")

                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_AquiferBaseElev] = float(data[CSV_AquiferBaseElev])
                        data[CSV_WaterTableElev] = float(data[CSV_WaterTableElev])
                        data[CSV_AnnualRechargeRate] = float(data[CSV_AnnualRechargeRate])
                        data[CSV_HorizConductivity] = float(data[CSV_HorizConductivity])
                        data[CSV_VertConductivity] = float(data[CSV_VertConductivity])
                        data[CSV_FillablePorosity] = float(data[CSV_FillablePorosity])
                        data[CSV_LayerThickness] = float(data[CSV_LayerThickness])
                        data[CSV_SurfAreaOption] = int(data[CSV_SurfAreaOption])
                        data[CSV_BottomElevation] = float(data[CSV_BottomElevation])
                        data[CSV_SurfaceArea] = float(data[CSV_SurfaceArea])
                        data[CSV_VertFlowTermination] = int(data[CSV_VertFlowTermination])
                        data[CSV_Perimeter1] = float(data[CSV_Perimeter1])
                        data[CSV_Perimeter2] = float(data[CSV_Perimeter2])
                        data[CSV_Perimeter3] = float(data[CSV_Perimeter3])
                        data[CSV_Distance_P1P2] = float(data[CSV_Distance_P1P2])
                        data[CSV_Distance_P2P3] = float(data[CSV_Distance_P2P3])
                        data[CSV_Cells_P1P2] = int(data[CSV_Cells_P1P2])
                        data[CSV_Cells_P2P3] = int(data[CSV_Cells_P2P3])
                        data[CSV_PctFinalRate] = float(data[CSV_PctFinalRate])
                        data[CSV_ConstantRate] = float(data[CSV_ConstantRate])

                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                            
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_NAME] = LAddDict[data[CSV_ParentID]][1]
                                    
                                ##################################    
                                #Process data for direct transfer
                                ##################################                           
                                row[GDB_SURFAREA_OPTION_DESC] = data[CSV_SurfAreaOption]
                                row[GDB_BOTTOMELEV_MS] = data[CSV_BottomElevation]
                                row[GDB_SURFAREA_MS] = data[CSV_SurfaceArea]
                                row[GDB_VERTFLOW_TERMINATION_DESC] = data[CSV_VertFlowTermination]
                                row[GDB_PERCENT_RATE_VAL] = data[CSV_PctFinalRate]
                                row[GDB_CONSTANT_RATE_VAL] = data[CSV_ConstantRate]
                                row[GDB_AQUIFER_BASE_ELEV_MS] = data[CSV_AquiferBaseElev]
                                row[GDB_WATERTABLE_ELEV_MS] = data[CSV_WaterTableElev]
                                row[GDB_ANNUALRECHARGE_RATE_VAL] = data[CSV_AnnualRechargeRate]
                                row[GDB_HORIZ_CONDUCTIVITY_VAL] = data[CSV_HorizConductivity]
                                row[GDB_VERT_CONDUCTIVITY_VAL] = data[CSV_VertConductivity]
                                row[GDB_EFFECTIVEPOROSITY_VAL] = data[CSV_FillablePorosity]
                                row[GDB_LAYERTHICKNESS_VAL] = data[CSV_LayerThickness]
                                row[GDB_PERIMETER1_MS] = data[CSV_Perimeter1]
                                row[GDB_PERIMETER2_MS] = data[CSV_Perimeter2]
                                row[GDB_PERIMETER3_MS] = data[CSV_Perimeter3]
                                row[GDB_DISTANCE_1TO2_MS] = data[CSV_Distance_P1P2]
                                row[GDB_DISTANCE_2TO3_MS] = data[CSV_Distance_P2P3]
                                row[GDB_NUMCELLS_1TO2_CNT] = data[CSV_Cells_P1P2]
                                row[GDB_NUMCELLS_2TO3_CNT] = data[CSV_Cells_P2P3]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]
                                
                            del cursorUpdate                           
                                
                        ###############
                        #Add new data
                        ###############
                        else:

                            #################################
                            #Assign Link name
                            #################################
                            try:
                                NAME = LUpDict[data[CSV_ParentID]][1]
                            except:
                                NAME = LAddDict[data[CSV_ParentID]][1]
                                
                            ##################################    
                            #Process data for direct transfer
                            ##################################

                            SURFAREA_OPTION_DESC = data[CSV_SurfAreaOption]
                            BOTTOMELEV_MS = data[CSV_BottomElevation]
                            SURFAREA_MS = data[CSV_SurfaceArea]
                            VERTFLOW_TERMINATION_DESC = data[CSV_VertFlowTermination]
                            PERCENT_RATE_VAL = data[CSV_PctFinalRate]
                            CONSTANT_RATE_VAL = data[CSV_ConstantRate]
                            AQUIFER_BASE_ELEV_MS = data[CSV_AquiferBaseElev]
                            WATERTABLE_ELEV_MS = data[CSV_WaterTableElev]
                            ANNUALRECHARGE_RATE_VAL = data[CSV_AnnualRechargeRate]
                            HORIZ_CONDUCTIVITY_VAL = data[CSV_HorizConductivity]
                            VERT_CONDUCTIVITY_VAL = data[CSV_VertConductivity]
                            EFFECTIVEPOROSITY_VAL = data[CSV_FillablePorosity]
                            LAYERTHICKNESS_VAL = data[CSV_LayerThickness]
                            PERIMETER1_MS = data[CSV_Perimeter1]
                            PERIMETER2_MS = data[CSV_Perimeter2]
                            PERIMETER3_MS = data[CSV_Perimeter3]
                            DISTANCE_1TO2_MS = data[CSV_Distance_P1P2]
                            DISTANCE_2TO3_MS = data[CSV_Distance_P2P3]
                            NUMCELLS_1TO2_CNT = data[CSV_Cells_P1P2]
                            NUMCELLS_2TO3_CNT = data[CSV_Cells_P2P3]
                            ICPR_GUID = data[CSV_ID]


                            #New Record Data
                            In_Data = (NAME,
                                       SURFAREA_OPTION_DESC,
                                       BOTTOMELEV_MS,
                                       SURFAREA_MS,
                                       VERTFLOW_TERMINATION_DESC,
                                       PERCENT_RATE_VAL,
                                       CONSTANT_RATE_VAL,
                                       AQUIFER_BASE_ELEV_MS,
                                       WATERTABLE_ELEV_MS,
                                       ANNUALRECHARGE_RATE_VAL,
                                       HORIZ_CONDUCTIVITY_VAL,
                                       VERT_CONDUCTIVITY_VAL,
                                       EFFECTIVEPOROSITY_VAL,
                                       LAYERTHICKNESS_VAL,
                                       PERIMETER1_MS,
                                        PERIMETER2_MS,
                                       PERIMETER3_MS,
                                       DISTANCE_1TO2_MS,
                                       DISTANCE_2TO3_MS,
                                       NUMCELLS_1TO2_CNT,
                                       NUMCELLS_2TO3_CNT,
                                       ICPR_GUID)

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]            
                del cursorInsert

                    
    except:
        arcpy.GetMessages()
        
    #Cycle through all data to delete values if required
    try:

        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and len(row[GDB_NAME])>0:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:        
        arcpy.GetMessages()
