#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Channel module
##########################################################################################################################
def UpdateChannel(infc1, Merge, Filestem, LAddDict, LUpDict,ChanGeom):

##########################################################################################################################
#Update attribute table data and no geometry data - Weirs
##########################################################################################################################
    try:

        #Output
        outfc = "CHANNEL"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_Channel.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass       

            
        #Fields for update of existing elements/features
        fields = ['CHANNEL_LENGTH_MS',
                  'UPSTREAM_SHAPE_DESC',
                  'UPSTREAM_INVERT_ELEVATION_MS',
                  'UPSTREAM_MANNINGSN_VAL',
                  'UPSTREAM_TOPCLIP_MS',
                  'UPSTREAM_TOPCLIP_MANNINGSN',
                  'UPSTREAM_TOPCLIP_OPTABLE',
                  'UPSTREAM_TOPCLIP_NODE',
                  'UPSTREAM_BOTTOMCLIP_MS',
                  'UPSTREAM_BOTTOMCLIP_MANNINGSN',
                  'UPSTREAM_BOTTOMCLIP_OPTABLE',
                  'UPSTREAM_BOTTOMCLIP_NODE',
                  'UPSTREAM_LEFTSIDE_SLOPE_MS',
                  'UPSTREAM_RIGHTSIDE_SLOPE_MS',
                  'UPSTREAM_BOTTOM_WIDTH_MS',
                  'UPSTREAM_EXTRAPOLATION_METHOD',
                  'UPSTREAM_MAX_DEPTH',
                  'UPSTREAM_MAX_WIDTH',
                  'DOWNSTREAM_SHAPE_DESC',
                  'DOWNSTREAM_INVERT_ELEVATION_MS',
                  'DOWNSTREAM_MANNINGSN_VAL',
                  'DOWNSTREAM_TOPCLIP_MS',
                  'DOWNSTREAM_TOPCLIP_MANNINGSN',
                  'DOWNSTREAM_TOPCLIP_OPTABLE',
                  'DOWNSTREAM_TOPCLIP_NODE',
                  'DOWNSTREAM_BOTTOMCLIP_MS',
                  'DS_BOTTOMCLIP_MANNINGSN',
                  'DOWNSTREAM_BOTTOMCLIP_OPTABLE',
                  'DOWNSTREAM_BOTTOMCLIP_NODE',
                  'DOWNSTREAM_LEFTSIDE_SLOPE_MS',
                  'DOWNSTREAM_RIGHTSIDE_SLOPE_MS',
                  'DOWNSTREAM_BOTTOM_WIDTH_MS',
                  'DS_EXTRAPOLATION_METHOD',
                  'DOWNSTREAM_MAX_DEPTH',
                  'DOWNSTREAM_MAX_WIDTH',
                  'ENTRANCE_LOSS_VAL',
                  'EXIT_LOSS_VAL',
                  'CONTRACTION_COEF_VAL',
                  'EXPANSION_COEF_VAL',
                  'BEND_LOSS_VAL',
                  'BEND_LOCATION',
                  'DAMPENING_THRESHOLD',
                  'ENERGY_SWITCH',
                  'US_MAIN_XS_NAME',
                  'US_AUX1_ELEV',
                  'US_AUX1_XS_NAME',
                  'US_AUX2_ELEV',
                  'US_AUX2_XS_NAME',              
                  'DS_MAIN_XS_NAME',
                  'DS_AUX1_ELEV',
                  'DS_AUX1_XS_NAME',
                  'DS_AUX2_ELEV',
                  'DS_AUX2_XS_NAME',              
                  'ICPR_LINK_NAME',
                  'ICPR_GUID']


        #List index
        GDB_CHANNEL_LENGTH_MS = fields.index('CHANNEL_LENGTH_MS')
        GDB_UPSTREAM_SHAPE_DESC = fields.index('UPSTREAM_SHAPE_DESC')
        GDB_UPSTREAM_INVERT_ELEVATION_MS = fields.index('UPSTREAM_INVERT_ELEVATION_MS')
        GDB_UPSTREAM_MANNINGSN_VAL = fields.index('UPSTREAM_MANNINGSN_VAL')
        GDB_UPSTREAM_TOPCLIP_MS = fields.index('UPSTREAM_TOPCLIP_MS')
        GDB_UPSTREAM_TOPCLIP_MANNINGSN = fields.index('UPSTREAM_TOPCLIP_MANNINGSN')
        GDB_UPSTREAM_TOPCLIP_OPTABLE = fields.index('UPSTREAM_TOPCLIP_OPTABLE')
        GDB_UPSTREAM_TOPCLIP_NODE = fields.index('UPSTREAM_TOPCLIP_NODE')
        GDB_UPSTREAM_BOTTOMCLIP_MS = fields.index('UPSTREAM_BOTTOMCLIP_MS')
        GDB_UPSTREAM_BOTTOMCLIP_MANNINGSN = fields.index('UPSTREAM_BOTTOMCLIP_MANNINGSN')
        GDB_UPSTREAM_BOTTOMCLIP_OPTABLE = fields.index('UPSTREAM_BOTTOMCLIP_OPTABLE')
        GDB_UPSTREAM_BOTTOMCLIP_NODE = fields.index('UPSTREAM_BOTTOMCLIP_NODE')
        GDB_UPSTREAM_LEFTSIDE_SLOPE_MS = fields.index('UPSTREAM_LEFTSIDE_SLOPE_MS')
        GDB_UPSTREAM_RIGHTSIDE_SLOPE_MS = fields.index('UPSTREAM_RIGHTSIDE_SLOPE_MS')
        GDB_UPSTREAM_BOTTOM_WIDTH_MS = fields.index('UPSTREAM_BOTTOM_WIDTH_MS')
        GDB_UPSTREAM_EXTRAPOLATION_METHOD = fields.index('UPSTREAM_EXTRAPOLATION_METHOD')
        GDB_UPSTREAM_MAX_DEPTH = fields.index('UPSTREAM_MAX_DEPTH')
        GDB_UPSTREAM_MAX_WIDTH = fields.index('UPSTREAM_MAX_WIDTH')
        GDB_DOWNSTREAM_SHAPE_DESC = fields.index('DOWNSTREAM_SHAPE_DESC')
        GDB_DOWNSTREAM_INVERT_ELEVATION_MS = fields.index('DOWNSTREAM_INVERT_ELEVATION_MS')
        GDB_DOWNSTREAM_MANNINGSN_VAL = fields.index('DOWNSTREAM_MANNINGSN_VAL')
        GDB_DOWNSTREAM_TOPCLIP_MS = fields.index('DOWNSTREAM_TOPCLIP_MS')
        GDB_DOWNSTREAM_TOPCLIP_MANNINGSN = fields.index('DOWNSTREAM_TOPCLIP_MANNINGSN')
        GDB_DOWNSTREAM_TOPCLIP_OPTABLE = fields.index('DOWNSTREAM_TOPCLIP_OPTABLE')
        GDB_DOWNSTREAM_TOPCLIP_NODE = fields.index('DOWNSTREAM_TOPCLIP_NODE')
        GDB_DOWNSTREAM_BOTTOMCLIP_MS = fields.index('DOWNSTREAM_BOTTOMCLIP_MS')
        GDB_DS_BOTTOMCLIP_MANNINGSN = fields.index('DS_BOTTOMCLIP_MANNINGSN')
        GDB_DOWNSTREAM_BOTTOMCLIP_OPTABLE = fields.index('DOWNSTREAM_BOTTOMCLIP_OPTABLE')
        GDB_DOWNSTREAM_BOTTOMCLIP_NODE = fields.index('DOWNSTREAM_BOTTOMCLIP_NODE')
        GDB_DOWNSTREAM_LEFTSIDE_SLOPE_MS = fields.index('DOWNSTREAM_LEFTSIDE_SLOPE_MS')
        GDB_DOWNSTREAM_RIGHTSIDE_SLOPE_MS = fields.index('DOWNSTREAM_RIGHTSIDE_SLOPE_MS')
        GDB_DOWNSTREAM_BOTTOM_WIDTH_MS = fields.index('DOWNSTREAM_BOTTOM_WIDTH_MS')
        GDB_DS_EXTRAPOLATION_METHOD = fields.index('DS_EXTRAPOLATION_METHOD')
        GDB_DOWNSTREAM_MAX_DEPTH = fields.index('DOWNSTREAM_MAX_DEPTH')
        GDB_DOWNSTREAM_MAX_WIDTH = fields.index('DOWNSTREAM_MAX_WIDTH')
        GDB_ENTRANCE_LOSS_VAL = fields.index('ENTRANCE_LOSS_VAL')
        GDB_EXIT_LOSS_VAL = fields.index('EXIT_LOSS_VAL')
        GDB_CONTRACTION_COEF_VAL = fields.index('CONTRACTION_COEF_VAL')
        GDB_EXPANSION_COEF_VAL = fields.index('EXPANSION_COEF_VAL')
        GDB_BEND_LOSS_VAL = fields.index('BEND_LOSS_VAL')
        GDB_BEND_LOCATION = fields.index('BEND_LOCATION')
        GDB_DAMPENING_THRESHOLD = fields.index('DAMPENING_THRESHOLD')
        GDB_ENERGY_SWITCH = fields.index('ENERGY_SWITCH')
        GDB_US_MAIN_XS_NAME = fields.index('US_MAIN_XS_NAME')
        GDB_US_AUX1_ELEV = fields.index('US_AUX1_ELEV')
        GDB_US_AUX1_XS_NAME = fields.index('US_AUX1_XS_NAME')
        GDB_US_AUX2_ELEV = fields.index('US_AUX2_ELEV')
        GDB_US_AUX2_XS_NAME = fields.index('US_AUX2_XS_NAME')
        GDB_DS_MAIN_XS_NAME = fields.index('DS_MAIN_XS_NAME')
        GDB_DS_AUX1_ELEV = fields.index('DS_AUX1_ELEV')
        GDB_DS_AUX1_XS_NAME = fields.index('DS_AUX1_XS_NAME')
        GDB_DS_AUX2_ELEV = fields.index('DS_AUX2_ELEV')
        GDB_DS_AUX2_XS_NAME = fields.index('DS_AUX2_XS_NAME')
        GDB_ICPR_LINK_NAME = fields.index('ICPR_LINK_NAME')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_Length = header_row.index("Length")
                        CSV_ContractionCoef = header_row.index("ContractionCoef")
                        CSV_ExpansionCoef = header_row.index("ExpansionCoef")
                        CSV_EntranceLossCoef = header_row.index("EntranceLossCoef")
                        CSV_ExitLossCoef = header_row.index("ExitLossCoef")
                        CSV_BendLossCoef = header_row.index("BendLossCoef")
                        CSV_BendLocation = header_row.index("BendLocation")
                        CSV_EnergySwitch = header_row.index("EnergySwitch")
                        CSV_UsInvert = header_row.index("UsInvert")
                        CSV_UsManningsN = header_row.index("UsManningsN")
                        CSV_UsGeometry = header_row.index("UsGeometry")
                        CSV_UsMaxDepth = header_row.index("UsMaxDepth")
                        CSV_UsMaxWidth = header_row.index("UsMaxWidth")
                        CSV_UsExtrapolationMethod = header_row.index("UsExtrapolationMethod")
                        CSV_UsBottomWidth = header_row.index("UsBottomWidth")
                        CSV_UsLeftSideSlope = header_row.index("UsLeftSideSlope")
                        CSV_UsRightSideSlope = header_row.index("UsRightSideSlope")
                        CSV_UsMainCrossSection = header_row.index("UsMainCrossSection")
                        CSV_UsAuxCrossSection1 = header_row.index("UsAuxCrossSection1")
                        CSV_UsAuxElevation1 = header_row.index("UsAuxElevation1")
                        CSV_UsAuxCrossSection2 = header_row.index("UsAuxCrossSection2")
                        CSV_UsAuxElevation2 = header_row.index("UsAuxElevation2")
                        CSV_UsBottomClip = header_row.index("UsBottomClip")
                        CSV_UsBottomClipTable = header_row.index("UsBottomClipTable")
                        CSV_UsNode_BottomClip = header_row.index("UsNode_BottomClip")
                        CSV_UsBottomClipManningsN = header_row.index("UsBottomClipManningsN")
                        CSV_UsTopClip = header_row.index("UsTopClip")
                        CSV_UsTopClipTable = header_row.index("UsTopClipTable")
                        CSV_UsNode_TopClip = header_row.index("UsNode_TopClip")
                        CSV_UsTopClipManningsN = header_row.index("UsTopClipManningsN")
                        CSV_DsInvert = header_row.index("DsInvert")
                        CSV_DsManningsN = header_row.index("DsManningsN")
                        CSV_DsGeometry = header_row.index("DsGeometry")
                        CSV_DsMaxDepth = header_row.index("DsMaxDepth")
                        CSV_DsMaxWidth = header_row.index("DsMaxWidth")
                        CSV_DsExtrapolationMethod = header_row.index("DsExtrapolationMethod")
                        CSV_DsBottomWidth = header_row.index("DsBottomWidth")
                        CSV_DsLeftSideSlope = header_row.index("DsLeftSideSlope")
                        CSV_DsRightSideSlope = header_row.index("DsRightSideSlope")
                        CSV_DsMainCrossSection = header_row.index("DsMainCrossSection")
                        CSV_DsAuxCrossSection1 = header_row.index("DsAuxCrossSection1")
                        CSV_DsAuxElevation1 = header_row.index("DsAuxElevation1")
                        CSV_DsAuxCrossSection2 = header_row.index("DsAuxCrossSection2")
                        CSV_DsAuxElevation2 = header_row.index("DsAuxElevation2")
                        CSV_DsBottomClip = header_row.index("DsBottomClip")
                        CSV_DsBottomClipTable = header_row.index("DsBottomClipTable")
                        CSV_DsNode_BottomClip = header_row.index("DsNode_BottomClip")
                        CSV_DsBottomClipManningsN = header_row.index("DsBottomClipManningsN")
                        CSV_DsTopClip = header_row.index("DsTopClip")
                        CSV_DsTopClipTable = header_row.index("DsTopClipTable")
                        CSV_DsNode_TopClip = header_row.index("DsNode_TopClip")
                        CSV_DsTopClipManningsN = header_row.index("DsTopClipManningsN")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_Length] = float(data[CSV_Length])
                        data[CSV_ContractionCoef] = float(data[CSV_ContractionCoef])
                        data[CSV_ExpansionCoef] = float(data[CSV_ExpansionCoef])
                        data[CSV_EntranceLossCoef] = float(data[CSV_EntranceLossCoef])
                        data[CSV_ExitLossCoef] = float(data[CSV_ExitLossCoef])
                        data[CSV_BendLossCoef] = float(data[CSV_BendLossCoef])
                        data[CSV_BendLocation] = float(data[CSV_BendLocation])
                        data[CSV_EnergySwitch] = int(data[CSV_EnergySwitch])
                        data[CSV_UsInvert] = float(data[CSV_UsInvert])
                        data[CSV_UsManningsN] = float(data[CSV_UsManningsN])
                        data[CSV_UsGeometry] = int(data[CSV_UsGeometry])
                        data[CSV_UsMaxDepth] = float(data[CSV_UsMaxDepth])
                        data[CSV_UsMaxWidth] = float(data[CSV_UsMaxWidth])
                        data[CSV_UsExtrapolationMethod] = int(data[CSV_UsExtrapolationMethod])
                        data[CSV_UsBottomWidth] = float(data[CSV_UsBottomWidth])
                        data[CSV_UsLeftSideSlope] = float(data[CSV_UsLeftSideSlope])
                        data[CSV_UsRightSideSlope] = float(data[CSV_UsRightSideSlope])
                        data[CSV_UsAuxElevation1] = float(data[CSV_UsAuxElevation1])
                        data[CSV_UsAuxElevation2] = float(data[CSV_UsAuxElevation2])
                        data[CSV_UsBottomClip] = float(data[CSV_UsBottomClip])
                        data[CSV_UsBottomClipManningsN] = float(data[CSV_UsBottomClipManningsN])
                        data[CSV_UsTopClip] = float(data[CSV_UsTopClip])
                        data[CSV_UsTopClipManningsN] = float(data[CSV_UsTopClipManningsN])
                        data[CSV_DsInvert] = float(data[CSV_DsInvert])
                        data[CSV_DsManningsN] = float(data[CSV_DsManningsN])
                        data[CSV_DsGeometry] = int(data[CSV_DsGeometry])
                        data[CSV_DsMaxDepth] = float(data[CSV_DsMaxDepth])
                        data[CSV_DsMaxWidth] = float(data[CSV_DsMaxWidth])
                        data[CSV_DsExtrapolationMethod] = int(data[CSV_DsExtrapolationMethod])
                        data[CSV_DsBottomWidth] = float(data[CSV_DsBottomWidth])
                        data[CSV_DsLeftSideSlope] = float(data[CSV_DsLeftSideSlope])
                        data[CSV_DsRightSideSlope] = float(data[CSV_DsRightSideSlope])
                        data[CSV_DsAuxElevation1] = float(data[CSV_DsAuxElevation1])
                        data[CSV_DsAuxElevation2] = float(data[CSV_DsAuxElevation2])
                        data[CSV_DsBottomClip] = float(data[CSV_DsBottomClip])
                        data[CSV_DsBottomClipManningsN] = float(data[CSV_DsBottomClipManningsN])
                        data[CSV_DsTopClip] = float(data[CSV_DsTopClip])
                        data[CSV_DsTopClipManningsN] = float(data[CSV_DsTopClipManningsN])

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:

                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ##################################
                                #Process data for direct transfer
                                ##################################

                                row[GDB_CHANNEL_LENGTH_MS] = data[CSV_Length]
                                row[GDB_UPSTREAM_SHAPE_DESC] = ChanGeom[data[CSV_UsGeometry]]
                                row[GDB_UPSTREAM_INVERT_ELEVATION_MS] = data[CSV_UsInvert]
                                row[GDB_UPSTREAM_MANNINGSN_VAL] = data[CSV_UsManningsN]
                                row[GDB_UPSTREAM_TOPCLIP_MS] = data[CSV_UsTopClip]
                                row[GDB_UPSTREAM_TOPCLIP_MANNINGSN] = data[CSV_UsTopClipManningsN]
                                row[GDB_UPSTREAM_TOPCLIP_OPTABLE] = data[CSV_UsTopClipTable]
                                row[GDB_UPSTREAM_TOPCLIP_NODE] = data[CSV_UsNode_TopClip]
                                row[GDB_UPSTREAM_BOTTOMCLIP_MS] = data[CSV_UsBottomClip]
                                row[GDB_UPSTREAM_BOTTOMCLIP_MANNINGSN] = data[CSV_UsBottomClipManningsN]
                                row[GDB_UPSTREAM_BOTTOMCLIP_OPTABLE] = data[CSV_UsBottomClipTable]
                                row[GDB_UPSTREAM_BOTTOMCLIP_NODE] = data[CSV_UsNode_BottomClip]
                                row[GDB_UPSTREAM_LEFTSIDE_SLOPE_MS] = data[CSV_UsLeftSideSlope]
                                row[GDB_UPSTREAM_RIGHTSIDE_SLOPE_MS] = data[CSV_UsRightSideSlope]
                                row[GDB_UPSTREAM_BOTTOM_WIDTH_MS] = data[CSV_UsBottomWidth]
                                row[GDB_UPSTREAM_EXTRAPOLATION_METHOD] = data[CSV_UsExtrapolationMethod]
                                row[GDB_UPSTREAM_MAX_DEPTH] = data[CSV_UsMaxDepth]
                                row[GDB_UPSTREAM_MAX_WIDTH] = data[CSV_UsMaxWidth]
                                row[GDB_DOWNSTREAM_SHAPE_DESC] = ChanGeom[data[CSV_DsGeometry]]
                                row[GDB_DOWNSTREAM_INVERT_ELEVATION_MS] = data[CSV_DsInvert]
                                row[GDB_DOWNSTREAM_MANNINGSN_VAL] = data[CSV_DsManningsN]
                                row[GDB_DOWNSTREAM_TOPCLIP_MS] = data[CSV_DsTopClip]
                                row[GDB_DOWNSTREAM_TOPCLIP_MANNINGSN] = data[CSV_DsTopClipManningsN]
                                row[GDB_DOWNSTREAM_TOPCLIP_OPTABLE] = data[CSV_DsTopClipTable]
                                row[GDB_DOWNSTREAM_TOPCLIP_NODE] = data[CSV_DsNode_TopClip]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_MS] = data[CSV_DsBottomClip]
                                row[GDB_DS_BOTTOMCLIP_MANNINGSN] = data[CSV_DsBottomClipManningsN]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_OPTABLE] = data[CSV_DsBottomClipTable]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_NODE] = data[CSV_DsNode_BottomClip]
                                row[GDB_DOWNSTREAM_LEFTSIDE_SLOPE_MS] = data[CSV_DsLeftSideSlope]
                                row[GDB_DOWNSTREAM_RIGHTSIDE_SLOPE_MS] = data[CSV_DsRightSideSlope]
                                row[GDB_DOWNSTREAM_BOTTOM_WIDTH_MS] = data[CSV_DsBottomWidth]
                                row[GDB_DS_EXTRAPOLATION_METHOD] = data[CSV_DsExtrapolationMethod]
                                row[GDB_DOWNSTREAM_MAX_DEPTH] = data[CSV_DsMaxDepth]
                                row[GDB_DOWNSTREAM_MAX_WIDTH] = data[CSV_DsMaxWidth]
                                row[GDB_ENTRANCE_LOSS_VAL] = data[CSV_EntranceLossCoef]
                                row[GDB_EXIT_LOSS_VAL] = data[CSV_ExitLossCoef]
                                row[GDB_CONTRACTION_COEF_VAL] = data[CSV_ContractionCoef]
                                row[GDB_EXPANSION_COEF_VAL] = data[CSV_ExpansionCoef]
                                row[GDB_BEND_LOSS_VAL] = data[CSV_BendLossCoef]
                                row[GDB_BEND_LOCATION] = data[CSV_BendLocation]
                                row[GDB_DAMPENING_THRESHOLD] = data[CSV_DampeningThreshold]
                                row[GDB_ENERGY_SWITCH] = data[CSV_EnergySwitch]
                                row[GDB_US_MAIN_XS_NAME] = data[CSV_UsMainCrossSection]
                                row[GDB_US_AUX1_ELEV] = data[CSV_UsAuxElevation1]
                                row[GDB_US_AUX1_XS_NAME] = data[CSV_UsAuxCrossSection1]
                                row[GDB_US_AUX2_ELEV] = data[CSV_UsAuxElevation2]
                                row[GDB_US_AUX2_XS_NAME] = data[CSV_UsAuxCrossSection2]
                                row[GDB_DS_MAIN_XS_NAME] = data[CSV_DsMainCrossSection]
                                row[GDB_DS_AUX1_ELEV] = data[CSV_DsAuxElevation1]
                                row[GDB_DS_AUX1_XS_NAME] = data[CSV_DsAuxCrossSection1]
                                row[GDB_DS_AUX2_ELEV] = data[CSV_DsAuxElevation2]
                                row[GDB_DS_AUX2_XS_NAME] = data[CSV_DsAuxCrossSection2]                            
                                row[GDB_ICPR_GUID] = data[CSV_ID]


                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_ICPR_LINK_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_ICPR_LINK_NAME] = LAddDict[data[CSV_ParentID]][1]

                                ##################################
                                #Process data for direct transfer
                                ##################################
                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]

                            del cursorUpdate

                        ###############
                        #Add new data
                        ###############
                        else:

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            CHANNEL_LENGTH_MS = data[CSV_Length]
                            UPSTREAM_SHAPE_DESC = ChanGeom[data[CSV_UsGeometry]]
                            UPSTREAM_INVERT_ELEVATION_MS = data[CSV_UsInvert]
                            UPSTREAM_MANNINGSN_VAL = data[CSV_UsManningsN]
                            UPSTREAM_TOPCLIP_MS = data[CSV_UsTopClip]
                            UPSTREAM_TOPCLIP_MANNINGSN = data[CSV_UsTopClipManningsN]
                            UPSTREAM_TOPCLIP_OPTABLE = data[CSV_UsTopClipTable]
                            UPSTREAM_TOPCLIP_NODE = data[CSV_UsNode_TopClip]
                            UPSTREAM_BOTTOMCLIP_MS = data[CSV_UsBottomClip]
                            UPSTREAM_BOTTOMCLIP_MANNINGSN = data[CSV_UsBottomClipManningsN]
                            UPSTREAM_BOTTOMCLIP_OPTABLE = data[CSV_UsBottomClipTable]
                            UPSTREAM_BOTTOMCLIP_NODE = data[CSV_UsNode_BottomClip]
                            UPSTREAM_LEFTSIDE_SLOPE_MS = data[CSV_UsLeftSideSlope]
                            UPSTREAM_RIGHTSIDE_SLOPE_MS = data[CSV_UsRightSideSlope]
                            UPSTREAM_BOTTOM_WIDTH_MS = data[CSV_UsBottomWidth]
                            UPSTREAM_EXTRAPOLATION_METHOD = data[CSV_UsExtrapolationMethod]
                            UPSTREAM_MAX_DEPTH = data[CSV_UsMaxDepth]
                            UPSTREAM_MAX_WIDTH = data[CSV_UsMaxWidth]
                            DOWNSTREAM_SHAPE_DESC = ChanGeom[data[CSV_DsGeometry]]
                            DOWNSTREAM_INVERT_ELEVATION_MS = data[CSV_DsInvert]
                            DOWNSTREAM_MANNINGSN_VAL = data[CSV_DsManningsN]
                            DOWNSTREAM_TOPCLIP_MS = data[CSV_DsTopClip]
                            DOWNSTREAM_TOPCLIP_MANNINGSN = data[CSV_DsTopClipManningsN]
                            DOWNSTREAM_TOPCLIP_OPTABLE = data[CSV_DsTopClipTable]
                            DOWNSTREAM_TOPCLIP_NODE = data[CSV_DsNode_TopClip]
                            DOWNSTREAM_BOTTOMCLIP_MS = data[CSV_DsBottomClip]
                            DS_BOTTOMCLIP_MANNINGSN = data[CSV_DsBottomClipManningsN]
                            DOWNSTREAM_BOTTOMCLIP_OPTABLE = data[CSV_DsBottomClipTable]
                            DOWNSTREAM_BOTTOMCLIP_NODE = data[CSV_DsNode_BottomClip]
                            DOWNSTREAM_LEFTSIDE_SLOPE_MS = data[CSV_DsLeftSideSlope]
                            DOWNSTREAM_RIGHTSIDE_SLOPE_MS = data[CSV_DsRightSideSlope]
                            DOWNSTREAM_BOTTOM_WIDTH_MS = data[CSV_DsBottomWidth]
                            DS_EXTRAPOLATION_METHOD = data[CSV_DsExtrapolationMethod]
                            DOWNSTREAM_MAX_DEPTH = data[CSV_DsMaxDepth]
                            DOWNSTREAM_MAX_WIDTH = data[CSV_DsMaxWidth]
                            ENTRANCE_LOSS_VAL = data[CSV_EntranceLossCoef]
                            EXIT_LOSS_VAL = data[CSV_ExitLossCoef]
                            CONTRACTION_COEF_VAL = data[CSV_ContractionCoef]
                            EXPANSION_COEF_VAL = data[CSV_ExpansionCoef]
                            BEND_LOSS_VAL = data[CSV_BendLossCoef]
                            BEND_LOCATION = data[CSV_BendLocation]
                            DAMPENING_THRESHOLD = data[CSV_DampeningThreshold]
                            ENERGY_SWITCH = data[CSV_EnergySwitch]
                            US_MAIN_XS_NAME = data[CSV_UsMainCrossSection]
                            US_AUX1_ELEV = data[CSV_UsAuxElevation1]
                            US_AUX1_XS_NAME = data[CSV_UsAuxCrossSection1]
                            US_AUX2_ELEV = data[CSV_UsAuxElevation2]
                            US_AUX2_XS_NAME = data[CSV_UsAuxCrossSection2]
                            DS_MAIN_XS_NAME = data[CSV_DsMainCrossSection]
                            DS_AUX1_ELEV = data[CSV_DsAuxElevation1]
                            DS_AUX1_XS_NAME = data[CSV_DsAuxCrossSection1]
                            DS_AUX2_ELEV = data[CSV_DsAuxElevation2]
                            DS_AUX2_XS_NAME = data[CSV_DsAuxCrossSection2]                            
                            ICPR_GUID = data[CSV_ID]


                            #################################
                            #Assign Link name
                            #################################
                            try:
                                ICPR_LINK_NAME = LUpDict[data[CSV_ParentID]][1]
                            except:
                                ICPR_LINK_NAME = LAddDict[data[CSV_ParentID]][1]
                                    

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            #New Record Data
                            In_Data = [CHANNEL_LENGTH_MS,
                                       UPSTREAM_SHAPE_DESC,
                                       UPSTREAM_INVERT_ELEVATION_MS,
                                       UPSTREAM_MANNINGSN_VAL,
                                       UPSTREAM_TOPCLIP_MS,
                                       UPSTREAM_TOPCLIP_MANNINGSN,
                                       UPSTREAM_TOPCLIP_OPTABLE,
                                       UPSTREAM_TOPCLIP_NODE,
                                       UPSTREAM_BOTTOMCLIP_MS,
                                       UPSTREAM_BOTTOMCLIP_MANNINGSN,
                                       UPSTREAM_BOTTOMCLIP_OPTABLE,
                                       UPSTREAM_BOTTOMCLIP_NODE,
                                       UPSTREAM_LEFTSIDE_SLOPE_MS,
                                       UPSTREAM_RIGHTSIDE_SLOPE_MS,
                                       UPSTREAM_BOTTOM_WIDTH_MS,
                                       UPSTREAM_EXTRAPOLATION_METHOD,
                                       UPSTREAM_MAX_DEPTH,
                                       UPSTREAM_MAX_WIDTH,
                                       DOWNSTREAM_SHAPE_DESC,
                                       DOWNSTREAM_INVERT_ELEVATION_MS,
                                       DOWNSTREAM_MANNINGSN_VAL,
                                       DOWNSTREAM_TOPCLIP_MS,
                                       DOWNSTREAM_TOPCLIP_MANNINGSN,
                                       DOWNSTREAM_TOPCLIP_OPTABLE,
                                       DOWNSTREAM_TOPCLIP_NODE,
                                       DOWNSTREAM_BOTTOMCLIP_MS,
                                       DS_BOTTOMCLIP_MANNINGSN,
                                       DOWNSTREAM_BOTTOMCLIP_OPTABLE,
                                       DOWNSTREAM_BOTTOMCLIP_NODE,
                                       DOWNSTREAM_LEFTSIDE_SLOPE_MS,
                                       DOWNSTREAM_RIGHTSIDE_SLOPE_MS,
                                       DOWNSTREAM_BOTTOM_WIDTH_MS,
                                       DS_EXTRAPOLATION_METHOD,
                                       DOWNSTREAM_MAX_DEPTH,
                                       DOWNSTREAM_MAX_WIDTH,
                                       ENTRANCE_LOSS_VAL,
                                       EXIT_LOSS_VAL,
                                       CONTRACTION_COEF_VAL,
                                       EXPANSION_COEF_VAL,
                                       BEND_LOSS_VAL,
                                       BEND_LOCATION,
                                       DAMPENING_THRESHOLD,
                                       ENERGY_SWITCH,
                                       US_MAIN_XS_NAME,
                                       US_AUX1_ELEV,
                                       US_AUX1_XS_NAME,
                                       US_AUX2_ELEV,
                                       US_AUX2_XS_NAME,              
                                       DS_MAIN_XS_NAME,
                                       DS_AUX1_ELEV,
                                       DS_AUX1_XS_NAME,
                                       DS_AUX2_ELEV,
                                       DS_AUX2_XS_NAME,              
                                       ICPR_LINK_NAME,
                                       ICPR_GUID]

                            #Insert new record
                            cursorInsert.insertRow(In_Data)                        

                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]
                            
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:
                if row[GDB_ICPR_GUID] not in AddDict:
                    if row[GDB_ICPR_GUID] not in UpDict:
                        if row[GDB_ICPR_LINK_NAME] is not None:
                            if len(row[GDB_ICPR_LINK_NAME])>0:
                                cursorUpdate.deleteRow()

            del cursorUpdate
    except:
        arcpy.GetMessages()

