#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def ExternalHydrograph_write_file(outpath, stem):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_EXTERNAL_HYDROGRAPH_SET"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_ExternalHydrographSet.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ID",'Name',
             'Comment']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            SetDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Define Comment
                    Comment = row.COMMENT
                        
                    a = [row.ICPR_GUID, row.Name,
                        Comment]

                    Set_Data = (row.ICPR_GUID, row.Name)
                    SetDict[row.Name]=Set_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows
        
    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_EXTERNAL_HYDROGRAPH"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_ExternalHydrograph.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID",'Name',
             'Comment']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Initial tuple        
            EH_TableDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = SetDict[row.SET_NAME][0]

                    #Define Comment
                    Comment = row.COMMENT
                    
                    a = [GUID, row.ICPR_GUID, row.NAME,
                        Comment]

                    #Create Tuple
                    EH_Data = (row.ICPR_GUID, row.NAME, row.SET_NAME)
                    EH_TableDict[row.SET_NAME + '~~~~~' + row.NAME]=EH_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows
        
    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table point data to CSV          
    ####################################################################


    try:
        infc = "ICPR4_EXTERNAL_HYDROGRAPH_PTS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_ExternalHydrograph_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc, sort_fields="SET_NAME; NAME; YEAR; MONTH; DAY; HOUR")

        # Write headers to CSV
        a = ["ParentID","ID",'Year',
             'Month', 'Day', 'Hour',
             'Flow']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
       
            # Enter for loop for each feature/row
            for row in rows:
                try:
                    #Assign GUID
                    nm=row.SET_NAME + '~~~~~' + row.NAME
                    if nm in EH_TableDict:
                        GUID=EH_TableDict[nm][0]
                        a = [GUID, row.ICPR_GUID, row.YEAR,
                            row.MONTH, row.DAY, row.HOUR,
                            row.FLOW]
                        csv_writerow(f,a)
                    
                except Exception as e:
                    arcpy.AddMessage(e)

        del rows
        
    except:
        arcpy.GetMessages()

######################################################################################################
######################################################################################################
