#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB


#           Top Clip Table module
######################################################################################################
######################################################################################################

def Simulations_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_Simulation"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Simulation.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
        
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "RunMode",
             "HotStartSimulation",
             "StartTime_Year",
             "StartTime_Month",
             "StartTime_Day",
             "StartTime_Hour",
             "EndTime_Year",
             "EndTime_Month",
             "EndTime_Day",
             "EndTime_Hour",
             "HotStartTime_Year",
             "HotStartTime_Month",
             "HotStartTime_Day",
             "HotStartTime_Hour",
             "MinCalcTime_Hydrology",
             "MinCalcTime_SurfHydraulics",
             "MinCalcTime_Groundwater",
             "MaxCalcTime_SurfHydraulics",
             "Comment",
             "SaveRestart",
             "RainfallSet",
             "PM_ReferenceETSet",
             "UnitHydrographSet",
             "BoundaryStageSet",
             "ExternalHydrographSet",
             "CurveNumberSet",
             "GreenAmptSet",
             "RichardsEquationSet",
             "ImperviousSet",
             "RoughnessSet",
             "PM_CropCoefSet",
             "FillablePorositySet",
             "ConductivitySet",
             "LeakageSet",
             "TimeMarching",
             "MaxIterations",
             "OverRelaxWeightFactor",
             "dZTolerance",
             "Max_dZ",
             "LinkOptimizerTolerance",
             "EdgeLengthOption",
             "EdgeLengthFactor",
             "DefaultDampThresh_2D",
             "MinNodeSurfaceArea_2D",
             "EnergySwitch_2D",
             "IARecoveryTime",
             "IncludeETManualBasins",
             "RainfallOption_ManualBasin",
             "RainfallOption_OFRegion",
             "RainfallName",
             "RainfallAmount",
             "StormDuration",
             "DefaultDampThresh_1D",
             "MinNodeSurfaceArea_1D",
             "EnergySwitch_1D",
             "IID",
             "EMCConstituentSet",
             "Ia_S"]
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            Dict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = ScDict[row.SCENARIO][0]

                    #Define Comment
                    Comment = row.Comment
                        
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         row.RunMode,
                         row.HotStartSimulation,
                         row.StartTime_Year,
                         row.StartTime_Month,
                         row.StartTime_Day,
                         row.StartTime_Hour,
                         row.EndTime_Year,
                         row.EndTime_Month,
                         row.EndTime_Day,
                         row.EndTime_Hour,
                         row.HotStartTime_Year,
                         row.HotStartTime_Month,
                         row.HotStartTime_Day,
                         row.HotStartTime_Hour,
                         row.MinCalcTime_Hydrology,
                         row.MinCalcTime_SurfHydraulics,
                         row.MinCalcTime_Groundwater,
                         row.MaxCalcTime_SurfHydraulics,
                         row.Comment,
                         row.SaveRestart,
                         row.RainfallSet,
                         row.PM_ReferenceETSet,
                         row.UnitHydrographSet,
                         row.BoundaryStageSet,
                         row.ExternalHydrographSet,
                         row.CurveNumberSet,
                         row.GreenAmptSet,
                         row.RichardsEquationSet,
                         row.ImperviousSet,
                         row.RoughnessSet,
                         row.PM_CropCoefSet,
                         row.FillablePorositySet,
                         row.ConductivitySet,
                         row.LeakageSet,
                         row.TimeMarching,
                         row.MaxIterations,
                         row.OverRelaxWeightFactor,
                         row.dZTolerance,
                         row.Max_dZ,
                         row.LinkOptimizerTolerance,
                         row.EdgeLengthOption,
                         row.EdgeLengthFactor,
                         row.DefaultDampThresh_2D,
                         row.MinNodeSurfaceArea_2D,
                         row.EnergySwitch_2D,
                         row.IARecoveryTime,
                         row.IncludeETManualBasins,
                         row.RainfallOption_ManualBasin,
                         row.RainfallOption_OFRegion,
                         row.RainfallName,
                         row.RainfallAmount,
                         row.StormDuration,
                         row.DefaultDampThresh_1D,
                         row.MinNodeSurfaceArea_1D,
                         row.EnergySwitch_1D,
                         row.IID,
                         row.EMCConstituentSet,
                         row.Ia_S]

                    Dict[row.NAME] = row.ICPR_GUID
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
        
    ####################################################################
    #Groundwater          
    ####################################################################

    try:
        infc = "ICPR4_SimOutputGroundwater"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Sim_Output_TInc_Groundwater.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'Hour',
             'TimeIncrement']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = Dict[row.Simulation]                

                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.Hour,
                         row.TimeIncrement]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

    ####################################################################
    #Hydrology          
    ####################################################################

    try:
        infc = "ICPR4_SimOutputHydrology"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Sim_Output_TInc_Hydrology.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'Hour',
             'TimeIncrement']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = Dict[row.Simulation]                

                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.Hour,
                         row.TimeIncrement]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

    ####################################################################
    #Restart          
    ####################################################################

    try:
        infc = "ICPR4_SimOutputRestart"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Sim_Output_TInc_RestartFile.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'Hour',
             'TimeIncrement']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = Dict[row.Simulation]                

                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.Hour,
                         row.TimeIncrement]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

    ####################################################################
    #Hydaraulics          
    ####################################################################

    try:
        infc = "ICPR4_SimOutputSurfHydraulics"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Sim_Output_TInc_SurfHydraulics.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'Hour',
             'TimeIncrement']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = Dict[row.Simulation]                

                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.Hour,
                         row.TimeIncrement]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
