#Copyright 2019 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def SimpleBasin_write_file(outpath, ScDict, stem, BasinDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        
        infc = "ICPR_BASIN"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
  

        # Enter for loop for each feature/row
        BasinInfo = {}
        for row in rows:

            #Assign ID and ParentID
            GUID = ScDict[row.SCENARIO][0]

            BasinType = BasinDict[row.Name][3]

            #Define Comment
            Comment = row.COMMENT

            #Check if has geometry
            try:
                if row.ShapeX is None or row.ShapeY is None:
                    pnts = row.getValue(shapeName)
                    pnt = pnts.labelPoint
                    
                    PntX = pnt.X
                    PntY = pnt.Y

                else:
                    
                    PntX = row.ShapeX
                    PntY = row.ShapeY
                    
                IsPlaced = row.ISPLACED

            #If geometry doesn't exist
            except:

                PntX = row.ShapeX
                PntY = row.ShapeY
                IsPlaced = row.ISPLACED              

            #Write out data for mapped basins only
            if BasinType == int(2):
            
                a = (GUID,
                     row.ICPR_GUID,
                     row.NAME,
                     row.NODENAME,
                     row.TYPE,
                     row.INFILTRATION_METHOD,
                     row.TC,
                     row.MAXQ,
                     row.TIMESHIFT,
                     row.UNITHYD,
                     row.PEAKFACTOR,
                     Comment,
                     PntX,
                     PntY,
                     "",
                     PntX,
                     PntY,
                     "",
                     IsPlaced)
                
                #List Data in dicationary
                BasinInfo[row.NAME] = a


        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
    try:
        
        infc = "ICPR4_Simple_Basin"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Dictionary Index
        GUID_Index = int(0)
        ICPR_GUID_Index = int(1)
        NAME_Index = int(2)
        NODENAME_Index = int(3)
        TYPE_Index = int(4)
        INFILTRATION_METHOD_Index = int(5)
        TC_Index = int(6)
        MAXQ_Index = int(7)
        TIMESHIFT_Index = int(8)
        UNITHYD_Index = int(9)
        PEAKFACTOR_Index = int(10)
        Comment_Index = int(11)
        ShapeX_Index = int(12)
        ShapeY_Index = int(13)
        ShapeZ_Index = int(14)
        TextX_Index = int(15)
        TextY_Index = int(16)
        TextZ_Index = int(17)
        ISPLACED_Index = int(18)

        #Define output location.
        outfc = outpath + slash +stem +  "_SimpleBasin.csv"

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Node",
             "HydrographMethod",
             "InfiltrationMethod",
             "TimeOfConcentration",
             "MaxAllowableQ",
             "TimeShift",
             "UnitHydrograph",
             "PeakingFactor",
             "Comment",
             "Area",
             "CurveNumber",
             "PctImpervious",
             "PctDCIA",
             "PctDirect",
             "RainfallName",
             "ShapeX",
             "ShapeY",
             "ShapeZ",
             "TextX",
             "TextY",
             "TextZ",
             "ISPLACED"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:


                a =[BasinInfo[row.Name][GUID_Index],
                    BasinInfo[row.Name][ICPR_GUID_Index],
                    BasinInfo[row.Name][NAME_Index],
                    BasinInfo[row.Name][NODENAME_Index],
                    BasinInfo[row.Name][TYPE_Index],
                    BasinInfo[row.Name][INFILTRATION_METHOD_Index],
                    BasinInfo[row.Name][TC_Index],
                    BasinInfo[row.Name][MAXQ_Index],
                    BasinInfo[row.Name][TIMESHIFT_Index],
                    BasinInfo[row.Name][UNITHYD_Index],
                    BasinInfo[row.Name][PEAKFACTOR_Index],
                    BasinInfo[row.Name][Comment_Index],
                    row.Area,
                    row.CurveNumber,
                    row.PctImpervious,
                    row.PctDCIA,
                    row.PctDirect,
                    row.Rainfall_Name,
                    BasinInfo[row.Name][ShapeX_Index],
                    BasinInfo[row.Name][ShapeY_Index],
                    BasinInfo[row.Name][ShapeZ_Index],
                    BasinInfo[row.Name][TextX_Index],
                    BasinInfo[row.Name][TextY_Index],
                    BasinInfo[row.Name][TextZ_Index],                    
                    BasinInfo[row.Name][ISPLACED_Index]]
                    
                    
                csv_writerow(f,a)

        del rows
    except:
        arcpy.GetMessages()

######################################################################################################
######################################################################################################
