#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Scenario_write_file(outpath, stem):    
    #Add forward slash for file path   
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow

    #Make scenario parameters global
    ScDict = {}
    
    
    ####################################################################
    #Create attribute table CSV
    ####################################################################

    try:        
        #Define output location
        outfc = outpath + slash + stem + "_Scenario.csv"

        #Define input file
        infc = "ICPR4_SCENARIO"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        # Create new search cursor
        rows = arcpy.SearchCursor(infc)
       
        # Write headers to CSV
        a = ["ID",
             "IID",
             "Comment",
             "Name"]

        with open(outfc,'wb') as f:
            csv_writerow(f,a)   
        
            # Enter for loop for each feature/row
            for row in rows:

                #Define Comment
                Comment = row.COMMENT
                        
                a = [row.ICPR_GUID,row.IID, Comment,row.NAME]
                csv_writerow(f,a)

                #Append to tuple
                sc_value = (row.ICPR_GUID, row.NAME)
                ScDict[row.NAME]=sc_value

        del rows            

    except:
        
        arcpy.GetMessages()

    ####################################################################
    #Return Scenario Information(row.ICPR_GUID, row.Name)
    ####################################################################

    try:

        return ScDict
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
