#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def ReferenceLine_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write attribute table data to CSV          
    ####################################################################
    
    try:
                
        infc = "Reference_Element_Line"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem+ "_RE_Polyline.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Comment",
             "TextX",
             "TextY",
             "TextZ"]
             
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = ScDict[row.SCENARIO][0]

                    #Calculate text location at midpoint of link
                    midpoint = row.shape.positionAlongLine(0.50,True).firstPoint
                    TextX = midpoint.X
                    TextY = midpoint.Y

                    #Define Comment
                    Comment = row.Comment                

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         Comment,
                         TextX,
                         TextY,
                         ""]

                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()

        del rows
                        
    except:

        arcpy.GetMessages()

    ####################################################################
    #Create CSV for coordinates
    ####################################################################

    try:
        
        infc = "Reference_Element_Line"
        outfc = outpath + slash + stem + "_RE_Polyline_Shape_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)
        
        shapefieldname = desc.ShapeFieldName

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                #Verify OF region exists in GDB before writing out data
                flag=False
                if row.Scenario in ScDict:          
                    flag = True

                if flag == True:
                
                    # Create the geometry object
                    #
                    feat = row.getValue(shapefieldname)
                    partnum = 0

                    # Count the number of points in the current multipart feature
                    #
                    partcount = feat.partCount

                    # Enter while loop for each part in the feature (if a singlepart feature
                    # this will occur only once)
                    #
                    while partnum < partcount:
                        # Print the part number
                        #
                        part = feat.getPart(partnum)
                        pnt = part.next()
                        pntcount = 0
                
                        # Enter while loop for each vertex
                        #
                        while pnt:
                            #Write x, y coordinates of current point to CSV
                            #
                            a = [row.ICPR_GUID,
                                 "{"+str(uuid.uuid4())+"}",
                                 pntcount,
                                 pnt.X,
                                 pnt.Y,
                                 ""]
                            
                            csv_writerow(f,a)
                                        
                            pnt = part.next()
                            pntcount = pntcount + 1
                
                            # If pnt is null, either the part is finished or there is an 
                            #   interior ring
                            #
                            if not pnt: 
                                pnt = part.next()
                                if pnt:
                                    print("Interior Ring:")
                        partnum = partnum + 1

        del rows
                    
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
