#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def OrificeDischargeCoefTable_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_OrificeCoefOpTable"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_OrificeDischargeCoefTable.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID",'Name',
             'Comment']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            RatingCurveDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = ScDict[row.Scenario][0]

                    #Define Comment
                    Comment = row.Comment
                        
                    a = [GUID, row.ICPR_GUID, row.Name,
                        Comment]

                    Rating_Data = (row.ICPR_GUID, row.Name)
                    RatingCurveDict[row.NAME]=Rating_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table point data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_OrificeCoefOpTable_PTs"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_OrificeDischargeCoefTable_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID",'UpstreamDepth',
             'DischargeCoef']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = RatingCurveDict[row.NAME][0]
                    
                    a = [GUID, row.ICPR_GUID, row.UpstreamDepth,
                        row.DischargeCoef]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
