#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

#           OF_Channel Feature module
######################################################################################################
######################################################################################################

def OF_Weir_write_file(outpath, stem, OFRegionDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write attribute table data to CSV          
    ####################################################################
    try:
            
        infc = "ICPR4_OF_Weir"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem+ "_Feature_OF_Weir.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Dictionary
        Dict = {}
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "WeirType",
             "WeirDischargeCoef",
             "HorizontalOffset",
             "Comment",
             "IsUpstreamRight",
             "TextX",
             "TextY",
             "TextZ",
             "IsClosed",
             "IsIntersectionChecked"]             
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = OFRegionDict[row.OverlandFlowRegion][0]

                    #Define Comment
                    Comment = row.Comment

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         row.WeirType,
                         row.WeirDischargeCoef,
                         row.HorizontalOffset,
                         row.Comment,
                         row.IsUpstreamRight,
                         row.TextX,
                         row.TextY,
                         row.TextZ,
                         "",
                         ""]

                    csv_writerow(f,a)

                    Dict[row.Name] = row.ICPR_GUID

                except:
                    arcpy.GetMessages()

            del rows
                        
    except:

        arcpy.GetMessages()

    ####################################################################
    #Center Child Table
    ####################################################################

    try:
        
        infc = "ICPR4_OF_Weir_Point"
        outfc = outpath + slash + stem + "_Feature_OF_Weir_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Vertex",
             "X",
             "Y",
             "VerticalOffset",
             "ElevCalcMethod",
             "Z"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = Dict[row.Name]              

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,                         
                         row.Vertex,
                         row.X,
                         row.Y,
                         row.VerticalOffset,
                         row.ElevCalcMethod,
                         0]

                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()

            del rows
                    
    except:
        arcpy.GetMessages()
        

    ####################################################################
    #Right Child Table
    ####################################################################

    try:
        
        infc = "ICPR4_OF_Weir_RightPoint"
        outfc = outpath + slash + stem + "_Feature_OF_Weir_RightPoint.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Vertex",
             "X",
             "Y",
             "Z"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = Dict[row.Name]              

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,                         
                         row.Vertex,
                         row.X,
                         row.Y,
                         0]

                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()

            del rows
                    
    except:
        arcpy.GetMessages()

    ####################################################################
    #left Child Table
    ####################################################################

    try:
        
        infc = "ICPR4_OF_Weir_LeftPoint"
        outfc = outpath + slash + stem + "_Feature_OF_Weir_LeftPoint.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Vertex",
             "X",
             "Y",
             "Z"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = Dict[row.Name]              

                    #Write results to file
                    a = [GUID,
                         row.ICPR_GUID,                         
                         row.Vertex,
                         row.X,
                         row.Y,0]

                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()

            del rows
                    
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
        
