#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def OF_MappedBasin_write_file(outpath, stem, OFRegionDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Create OF Pond Control Volume attribute table CSV
    ####################################################################

    try:

        infc = "OF_MappedBasin"
        
        #Define output location
        outfc = outpath + slash + stem + "_Feature_OF_MappedBasin.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        #Add XY Data for label
        shapeName = arcpy.Describe(infc).shapeFieldName

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             'Comment',
             'TextX',
             'TextY',
             'TextZ']
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   
       
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = OFRegionDict[row.OverlandFlowRegion][0]

                    #Define Comment
                    Comment = row.Comment

                    #Determine Label Position
                    pnts = row.getValue(shapeName)
                    pnt = pnts.labelPoint
                    
                    PntX = pnt.X
                    PntY = pnt.Y 


                    ##Write data
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         Comment,
                         PntX,
                         PntY,
                         ""]
                        
                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()
                
        del rows

    except:
        arcpy.GetMessages()  
    
    ####################################################################
    #Create OF Pond CV coordinates CSV
    ####################################################################
        
    try:
        
        
        infc = "OF_MappedBasin"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem + "_Feature_OF_MappedBasin_Point.csv"
       

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)
        shapefieldname = desc.ShapeFieldName
        
        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)        

            # Enter for loop for each feature/row
            for row in rows:

                #only write out spatial data for items with overland flow regions in GDB
                flag = False
                if row.OverlandFlowRegion in OFRegionDict:
                    flag = True

                if flag is True:                

                    # Create the geometry object
                    #
                    feat = row.getValue(shapefieldname)
                    partnum = 0

                    # Count the number of points in the current multipart feature
                    #
                    partcount = feat.partCount

                    #Total number of points in feature    
                    pointcount = feat.pointCount
                    
                    # Enter while loop for each part in the feature (if a singlepart feature
                    # this will occur only once)
                    #
                    while partnum < partcount:
                        # Print the part number
                        #
                        part = feat.getPart(partnum)
                        pnt = part.next()
                        pntcount = 0
                
                        # Enter while loop for each vertex
                        #
                        while pnt:
                            #Write x, y coordinates of current point to CSV
                            a = [row.ICPR_GUID, "{"+str(uuid.uuid4())+"}", pntcount, pnt.X, pnt.Y, ""]

                            #Only write points up the last point, which is excluded            
                            if pntcount < pointcount-1:
                                csv_writerow(f,a)
                                        
                            pnt = part.next()
                            pntcount = pntcount + 1
                
                            # If pnt is null, either the part is finished or there is an 
                            #   interior ring
                            #
                            if not pnt: 
                                pnt = part.next()
                                if pnt:
                                    print("Interior Ring:")
                        partnum = partnum + 1

        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
