#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Checks Model Version Before Import

import arcpy
import iccsv

##########################################################################################################################
#Model Info Module
##########################################################################################################################
def VersionCheck(infc1, Filestem):

##########################################################################################################################
#Read Current Version from GDB if data table exists
##########################################################################################################################

    infc = "ICPR4_ModelVersionInfo"
    
    if arcpy.Exists(infc):
        
        Flag = True #GDB Check
        
    else:
    
        arcpy.AddMessage(infc + " data table does no exist in GDB")
        arcpy.AddMessage("Required: ICPR4 database version 214")
        arcpy.AddMessage("Process Aborted")
        arcpy.AddMessage("Go to 'Help > Check for Updates' in ICPR4 to download latest GWIS GDB Schema")

        Flag = False

##########################################################################################################################
    #Read ICPR4 CSV version info in CSV file
##########################################################################################################################
#If model info table exists in GDB, proceed to process info in CSV if it exists
    if Flag == True:

        #Output
        outfc = "ICPR4_ModelVersionInfo"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "exportinfo.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['Version',
                  'Format',
                  'Date',
                  'Time']

        #List index
        GDB_Version = fields.index('Version')
        GDB_Format = fields.index('Format')
        GDB_Date = fields.index('Date')
        GDB_Time = fields.index('Time')

        #Read CSV Data
        with open(infc,'r') as csv_file:
            first = True
            for line in csv_file:
                if first== True:
                    first = False
                    header_row = iccsv.csv_parseline(line)

                    CSV_version = header_row.index("version")
                    CSV_format = header_row.index("format")
                    CSV_date = header_row.index("date")
                    CSV_time = header_row.index("time")

                else:

                    data = iccsv.csv_parseline(line)

                    #Set data formats for non-text used fields
                    data[CSV_format] = int(data[CSV_format])
                    
                    #CSV data
                    V_New = data[CSV_version]
                    F_New = data[CSV_format]
                    Date = data[CSV_date]
                    Time = data[CSV_time]

                    if F_New == 214:#Update database version for each release.
                        
                        #Empty Table
                        arcpy.DeleteRows_management(outfc)
                        a = [V_New,
                             F_New,
                             Date,
                             Time]
                             
                        cursor = arcpy.da.InsertCursor(outfc, fields)
                        cursor.insertRow(a)
                        del cursor
                        
                    else:
                    
                        arcpy.AddMessage("Required: ICPR4 database version 214")
                        arcpy.AddMessage("Process Aborted")
     
    else:
        arcpy.AddMessage(infc + " does no exist in CSV folder")
        arcpy.AddMessage("ICPR4 to GWIS process aborted")
        arcpy.AddMessage("Required: ICPR4 database version 214")
        arcpy.AddMessage("Process Aborted")
        Flag = False
       

            
    return Flag        
        
            
