#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_Weir_write_file(outpath, stem, LinkDict,WeirGeomCode,WeirOrienCode):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
        
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "WEIR"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location.
        outfc = outpath + slash + stem+ "_Link_Weir.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "DampeningThreshold",
             "WeirType",
             "Geometry",
             "Invert",
             "ControlElevation",
             "CrossSection",
             "ExtrapolationMethod",
             "MaxDepth",
             "MaxWidth",
             "Fillet",
             "BottomWidth",
             "LeftSideSlope",
             "RightSideSlope",
             "BottomClip",
             "TopClip",
             "WeirDischargeCoef",
             "OrificeDischargeCoef",
             "BottomClipTable",
             "TopClipTable",
             "WeirDischargeCoefTable",
             "OrificeDischargeCoefTable",
             "Node_BottomClip",
             "Node_TopClip"]

        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                #Only write data where link name is populated
                if row.ICPR_LINK_NAME is not None:

                    try:

                        #Check link code
                        LinkCode = LinkDict[row.ICPR_LINK_NAME][2]

                        if int(LinkCode) == int(24):

                            #Determine Parent GUID for child table
                            GUID = LinkDict[row.ICPR_LINK_NAME][1]

                            #Set geometry code for ICPR4
                            Weir_Geom_Index = [x[1] for x in WeirGeomCode].index(row.WEIR_SHAPE_DESC)
                            Weir_Geom = WeirGeomCode[Weir_Geom_Index][2]

                            #Determine Weir Type
                            Weir_Type_Index = [x[1] for x in WeirOrienCode].index(row.WEIR_ORIENTATION_DESC)
                            Weir_Type = WeirOrienCode[Weir_Type_Index][2]

                            #Strip out null where calculations are performed and set to 0
                            #Span
                            try:
                                MaxWidth = round(row.WEIR_SPAN_MS/12.,4)
                            except:
                                MaxWidth = 0                        
                            #Rise
                            try:
                                MaxDepth = round(row.WEIR_RISE_MS/12.,4)
                            except:
                                MaxDepth = 0
                            #Top Clip
                            try:
                                TopClip = round(row.WEIR_TOPCLIP_MS/12.,4)
                            except:
                                TopClip = 0
                            #Bottom Clip
                            try:
                                BottomClip = round(row.WEIR_BOTTOMCLIP_MS/12.,4)
                            except:
                                BottomClip = 0                   

                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.DAMPENING_THRESHOLD,
                                 Weir_Type,
                                 Weir_Geom,
                                 row.WEIR_INVERT_ELEVATION_MS,
                                 row.CONTROL_ELEVATION_MS,
                                 row.SECTION_NAME,
                                 row.EXTRAPOLATION_METHOD,
                                 MaxDepth,
                                 MaxWidth,
                                 row.FILLET,
                                 row.WEIR_BOTTOM_WIDTH_MS,
                                 row.LEFTSIDE_SLOPE_VAL,
                                 row.RIGHTSIDE_SLOPE_VAL,
                                 BottomClip,
                                 TopClip,
                                 row.WEIR_DISCHARGE_COEF_VAL,
                                 row.ORIFICE_DISCHARGE_COEF_VAL,
                                 row.BOTTOMCLIP_OPTABLE,
                                 row.TOPCLIP_OPTABLE,
                                 row.WEIRCOEF_OPTABLE,
                                 row.ORIFICECOEF_OPTABLE,
                                 row.BOTTOMCLIP_NODE,
                                 row.TOPCLIP_NODE]
                        
                            csv_writerow(f,a)

                    except:
                        arcpy.GetMessages()

        del rows
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
