#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_Pipe_write_file(outpath, stem, LinkDict, PipeGeomCode):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "PIPE_BARREL"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Link_Pipe.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "DampeningThreshold",
             "Length",
             "FHWACulvertCode",
             "EntranceLossCoef",
             "ExitLossCoef",
             "BendLossCoef",
             "BendLocation",
             "EnergySwitch",
             "UsInvert",
             "UsManningsN",
             "UsGeometry",
             "UsMaxDepth",
             "UsMaxWidth",
             "UsFillet",
             "UsCrossSection",
             "UsBottomClip",
             "UsBottomClipTable",
             "UsNode_BottomClip",
             "UsBottomClipManningsN",
             "UsTopClip",
             "UsTopClipTable",
             "UsNode_TopClip",
             "UsTopClipManningsN",
             "DsInvert",
             "DsManningsN",
             "DsGeometry",
             "DsMaxDepth",
             "DsMaxWidth",
             "DsFillet",
             "DsCrossSection",
             "DsBottomClip",
             "DsBottomClipTable",
             "DsNode_BottomClip",
             "DsBottomClipManningsN",
             "DsTopClip",
             "DsTopClipTable",
             "DsNode_TopClip",
             "DsTopClipManningsN"]

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
      
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR link name specified
                if row.ICPR_LINK_NAME is not None:

                    try:
                    
                        #Check link code so drop pipes are skipped
                        LinkCode = LinkDict[row.ICPR_LINK_NAME][2]

                        #Only process non drop pipes
                        if int(LinkCode) == int(21):

                            #Determine Parent GUID for pipe table
                            GUID = LinkDict[row.ICPR_LINK_NAME][1]

                            #Set ICPR4 geometry code
                            US_Geom_index = [x[1] for x in PipeGeomCode].index(row.UPSTREAM_SHAPE_DESC)
                            US_Geom = PipeGeomCode[US_Geom_index][2]
                            
                            DS_Geom_index = [x[1] for x in PipeGeomCode].index(row.DOWNSTREAM_SHAPE_DESC)
                            DS_Geom = PipeGeomCode[DS_Geom_index][2]

                            #Strip out null where calculations are performed and set to 0
                            #US Span
                            try:
                                US_MaxWidth = round(row.UPSTREAM_SPAN_MS/12.,4)
                            except:
                                US_MaxWidth = 0                        
                            #US Rise
                            try:
                                US_MaxDepth = round(row.UPSTREAM_RISE_MS/12.,4)
                            except:
                                US_MaxDepth = 0
                            #US Top Clip
                            try:
                                US_TopClip = round(row.UPSTREAM_TOPCLIP_MS/12.,4)
                            except:
                                US_TopClip = 0
                            #US Bottom Clip
                            try:
                                US_BottomClip = round(row.UPSTREAM_BOTTOMCLIP_MS/12.,4)
                            except:
                                US_BottomClip = 0
                            #DS Rise
                            try:
                                DS_MaxDepth = round(row.DOWNSTREAM_RISE_MS/12.,4)
                            except:
                                DS_MaxDepth = 0
                            #DS Span
                            try:
                                DS_MaxWidth = round(row.DOWNSTREAM_SPAN_MS/12.,4)
                            except:
                                DS_MaxWidth = 0                        
                            #DS Top Clip
                            try:
                                DS_TopClip = round(row.DOWNSTREAM_TOPCLIP_MS/12.,4)
                            except:
                                DS_TopClip = 0
                            #DS Bottom Clip
                            try:
                                DS_BottomClip = round(row.DOWNSTREAM_BOTTOMCLIP_MS/12.,4)
                            except:
                                DS_BottomClip =0
                                

                            a = [GUID,                                 
                                 row.ICPR_GUID,
                                 row.DAMPENING_THRESHOLD,
                                 row.PIPE_BARREL_LENGTH_MS,
                                 row.FHWA_CULVERT_CODE,
                                 row.ENTRANCE_LOSS_VAL,
                                 row.EXIT_LOSS_VAL,
                                 row.BEND_LOSS_VAL,
                                 row.BEND_LOCATION,
                                 row.ENERGY_SWITCH,
                                 row.UPSTREAM_INVERT_ELEVATION_MS,
                                 row.UPSTREAM_MANNINGSN_VAL,
                                 US_Geom,
                                 US_MaxDepth,
                                 US_MaxWidth,
                                 row.UPSTREAM_FILLET,
                                 row.UPSTREAM_CROSS_SECTION,
                                 US_BottomClip,
                                 row.UPSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.UPSTREAM_BOTTOMCLIP_NODE,
                                 row.UPSTREAM_BOTTOMCLIP_MANNINGSN,
                                 US_TopClip,
                                 row.UPSTREAM_TOPCLIP_OPTABLE,
                                 row.UPSTREAM_TOPCLIP_NODE,
                                 row.UPSTREAM_TOPCLIP_MANNINGSN,
                                 row.DOWNSTREAM_INVERT_ELEVATION_MS,
                                 row.DOWNSTREAM_MANNINGSN_VAL,
                                 DS_Geom,
                                 DS_MaxDepth,
                                 DS_MaxWidth,
                                 row.DOWNSTREAM_FILLET,
                                 row.DOWNSTREAM_CROSS_SECTION,
                                 DS_BottomClip,
                                 row.DOWNSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.DOWNSTREAM_BOTTOMCLIP_NODE,
                                 row.DOWNSTREAM_BOTTOMCLIP_MANNINGSN,
                                 DS_TopClip,
                                 row.DOWNSTREAM_TOPCLIP_OPTABLE,
                                 row.DOWNSTREAM_TOPCLIP_NODE,
                                 row.DOWNSTREAM_BOTTOMCLIP_MANNINGSN]
                            
                            csv_writerow(f,a)

                        if int(LinkCode) == int(22):

                            arcpy.AddMessage("Drop Pipe Skipped: " + row.ICPR_LINK_NAME)

                    except:
                        arcpy.GetMessages()

        del rows
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
