#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_Percolation_write_file(outpath, stem, LinkDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_PERCOLATION"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_Link_Percolation.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "AquiferBaseElev",
             "WaterTableElev",
             "AnnualRechargeRate",
             "HorizConductivity",
             "VertConductivity",
             "FillablePorosity",
             "LayerThickness",
             "SurfAreaOption",
             "BottomElevation",
             "SurfaceArea",
             "VertFlowTermination",
             "Perimeter1",
             "Perimeter2",
             "Perimeter3",
             "Distance_P1P2",
             "Distance_P2P3",
             "Cells_P1P2",
             "Cells_P2P3",
             "PctFinalRate",
             "ConstantRate"]
             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
      
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR link name specified
                if row.NAME is not None:

                    try:
                    
                        #Check link code
                        LinkCode = LinkDict[row.NAME][2]

                        #Only process links included in this module
                        if int(LinkCode) == int(33):

                            #Determine Parent GUID
                            GUID = LinkDict[row.NAME][1]

                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.AQUIFER_BASE_ELEV_MS,
                                 row.WATERTABLE_ELEV_MS,
                                 row.ANNUALRECHARGE_RATE_VAL,
                                 row.HORIZ_CONDUCTIVITY_VAL,
                                 row.VERT_CONDUCTIVITY_VAL,
                                 row.EFFECTIVEPOROSITY_VAL,
                                 row.LAYERTHICKNESS_VAL,
                                 row.SURFAREA_OPTION_DESC,
                                 row.BOTTOMELEV_MS,
                                 row.SURFAREA_MS,
                                 row.VERTFLOW_TERMINATION_DESC,
                                 row.PERIMETER1_MS,
                                 row.PERIMETER2_MS,
                                 row.PERIMETER3_MS,
                                 row.DISTANCE_1TO2_MS,
                                 row.DISTANCE_2TO3_MS,
                                 row.NUMCELLS_1TO2_CNT,
                                 row.NUMCELLS_2TO3_CNT,
                                 row.PERCENT_RATE_VAL,
                                 row.CONSTANT_RATE_VAL]
                                
                            
                            csv_writerow(f,a)

                    except:
                        arcpy.GetMessages()

        del rows
        
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
