#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_DropStructure_write_file(outpath, stem, LinkDict,PipeGeomCode,WeirGeomCode,WeirOrienCode):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################
    #Create tuple of solution increments and solution type
    try:
        infc = "DROP_STRUCTURE"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
        DropSolutionDict = {}
        #Create tuple of data (Name, Solution, Increments)
        for row in rows:

            DropSolutionData = (row.ICPR_LINK_NAME, row.Solution, row.Increments)
            DropSolutionDict[row.ICPR_LINK_NAME]=DropSolutionData

    except:

        arcpy.GetMessages()       

    try:
        
        infc = "PIPE_BARREL"
                   
        #Define output location
        outfc = outpath + slash +stem +  "_Link_DropStructure.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Solution",
             "Increments",
             "PipeCount",
             "DampeningThreshold",
             "Length",
             "FHWACulvertCode",
             "EntranceLossCoef",
             "ExitLossCoef",
             "BendLossCoef",
             "BendLocation",
             "EnergySwitch",
             "UsInvert",
             "UsManningsN",
             "UsGeometry",
             "UsMaxDepth",
             "UsMaxWidth",
             "UsFillet",
             "UsCrossSection",
             "UsBottomClip",
             "UsBottomClipTable",
             "UsNode_BottomClip",
             "UsBottomClipManningsN",
             "UsTopClip",
             "UsTopClipTable",
             "UsNode_TopClip",
             "UsTopClipManningsN",
             "DsInvert",
             "DsManningsN",
             "DsGeometry",
             "DsMaxDepth",
             "DsMaxWidth",
             "DsFillet",
             "DsCrossSection",
             "DsBottomClip",
             "DsBottomClipTable",
             "DsNode_BottomClip",
             "DsBottomClipManningsN",
             "DsTopClip",
             "DsTopClipTable",
             "DsNode_TopClip",
             "DsTopClipManningsN",
             "PipeComment"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Empty array for drop pipe GUID
            DropPipeDict = {}

            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR link name specified
                if row.ICPR_LINK_NAME is not None:

                    try:

                        #Check link code so drop pipes are skipped
                        LinkCode = LinkDict[row.ICPR_LINK_NAME][2]
                        
                        #Only process drop pipes
                        if int(LinkCode) == int(22):

                            #Determine Parent GUID for pipe table
                            GUID = LinkDict[row.ICPR_LINK_NAME][1]

                            #Set ICPR4 geometry code
                            US_Geom_index = [x[1] for x in PipeGeomCode].index(row.UPSTREAM_SHAPE_DESC)
                            US_Geom = PipeGeomCode[US_Geom_index][2]
                            
                            DS_Geom_index = [x[1] for x in PipeGeomCode].index(row.DOWNSTREAM_SHAPE_DESC)
                            DS_Geom = PipeGeomCode[DS_Geom_index][2]

                            #Get solution type & solution increments
                            Drop_Solution = DropSolutionDict[row.ICPR_LINK_NAME][1]
                            Drop_Increments = DropSolutionDict[row.ICPR_LINK_NAME][2]                

                            #Strip out null where calculations are performed and set to 0
                            #US Span
                            try:
                                US_MaxWidth = round(row.UPSTREAM_SPAN_MS/12.,4)
                            except:
                                US_MaxWidth = 0                        
                            #US Rise
                            try:
                                US_MaxDepth = round(row.UPSTREAM_RISE_MS/12.,4)
                            except:
                                US_MaxDepth = 0
                            #US Top Clip
                            try:
                                US_TopClip = round(row.UPSTREAM_TOPCLIP_MS/12.,4)
                            except:
                                US_TopClip = 0
                            #US Bottom Clip
                            try:
                                US_BottomClip = round(row.UPSTREAM_BOTTOMCLIP_MS/12.,4)
                            except:
                                US_BottomClip = 0
                            #DS Rise
                            try:
                                DS_MaxDepth = round(row.DOWNSTREAM_RISE_MS/12.,4)
                            except:
                                DS_MaxDepth = 0
                            #DS Span
                            try:
                                DS_MaxWidth = round(row.DOWNSTREAM_SPAN_MS/12.,4)
                            except:
                                DS_MaxWidth = 0                        
                            #DS Top Clip
                            try:
                                DS_TopClip = round(row.DOWNSTREAM_TOPCLIP_MS/12.,4)
                            except:
                                DS_TopClip = 0
                            #DS Bottom Clip
                            try:
                                DS_BottomClip = round(row.DOWNSTREAM_BOTTOMCLIP_MS/12.,4)
                            except:
                                DS_BottomClip =0
                                
                            #Define Comment
                            if str(row.DROP_PIPE_COMMENT)=='None':
                                Comment = ""
                            else:
                                Comment = str(row.DROP_PIPE_COMMENT)
                                

                            a = [GUID,
                                 row.ICPR_GUID,
                                 Drop_Solution,
                                 Drop_Increments,
                                 row.DROP_PIPE_CNT,
                                 row.DAMPENING_THRESHOLD,
                                 row.PIPE_BARREL_LENGTH_MS,
                                 row.FHWA_CULVERT_CODE,
                                 row.ENTRANCE_LOSS_VAL,
                                 row.EXIT_LOSS_VAL,
                                 row.BEND_LOSS_VAL,
                                 row.BEND_LOCATION,
                                 row.ENERGY_SWITCH,
                                 row.UPSTREAM_INVERT_ELEVATION_MS,
                                 row.UPSTREAM_MANNINGSN_VAL,
                                 US_Geom,
                                 US_MaxDepth,
                                 US_MaxWidth,
                                 row.UPSTREAM_FILLET,
                                 row.UPSTREAM_CROSS_SECTION,
                                 US_BottomClip,
                                 row.UPSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.UPSTREAM_BOTTOMCLIP_NODE,
                                 row.UPSTREAM_BOTTOMCLIP_MANNINGSN,
                                 US_TopClip,
                                 row.UPSTREAM_TOPCLIP_OPTABLE,
                                 row.UPSTREAM_TOPCLIP_NODE,
                                 row.UPSTREAM_TOPCLIP_MANNINGSN,
                                 row.DOWNSTREAM_INVERT_ELEVATION_MS,
                                 row.DOWNSTREAM_MANNINGSN_VAL,
                                 DS_Geom,
                                 DS_MaxDepth,
                                 DS_MaxWidth,
                                 row.DOWNSTREAM_FILLET,
                                 row.DOWNSTREAM_CROSS_SECTION,
                                 DS_BottomClip,
                                 row.DOWNSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.DOWNSTREAM_BOTTOMCLIP_NODE,
                                 row.DOWNSTREAM_BOTTOMCLIP_MANNINGSN,
                                 DS_TopClip,
                                 row.DOWNSTREAM_TOPCLIP_OPTABLE,
                                 row.DOWNSTREAM_TOPCLIP_NODE,
                                 row.DOWNSTREAM_TOPCLIP_MANNINGSN,
                                 Comment]

                            #Populate drop pipe tuple for use with drop weir (Link GUID, Drop Pipe GUID, Name)
                            DropData = (GUID, row.ICPR_GUID, row.ICPR_LINK_NAME)
                            DropPipeDict[row.ICPR_LINK_NAME]=DropData
                            
                            csv_writerow(f,a)

                        if int(LinkCode) == int(21):

                            arcpy.AddMessage("Pipe Barrel Skipped: " + row.ICPR_LINK_NAME)

                    except Exception as e:
                        arcpy.AddMessage(e)

        del rows
    except:        
                 
        arcpy.GetMessages()

    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        
        infc = "WEIR"
                   
        #Define output location
        outfc = outpath + slash + stem+  "_Link_DropStructure_Weir.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "WeirCount",
             "DampeningThreshold",
             "WeirType",
             "Geometry",
             "Invert",
             "ControlElevation",
             "CrossSection",
             "ExtrapolationMethod",
             "MaxDepth",
             "MaxWidth",
             "Fillet",
             "BottomWidth",
             "LeftSideSlope",
             "RightSideSlope",
             "BottomClip",
             "TopClip",
             "WeirDischargeCoef",
             "OrificeDischargeCoef",
             "BottomClipTable",
             "TopClipTable",
             "WeirDischargeCoefTable",
             "OrificeDischargeCoefTable",
             "Node_BottomClip",
             "Node_TopClip",
             "Comment",
             "FlowDirection"]
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                #Only write data where link name is populated
                if row.ICPR_LINK_NAME is not None:

                    try:

                        #Check link code so non drop weirs are skipped
                        LinkCode = LinkDict[row.ICPR_LINK_NAME][2]

                        if int(LinkCode) == int(22):                

                            #Determine Parent GUID (Link GUID, Drop Pipe GUID, Name)
                        
                            GUID = DropPipeDict[row.ICPR_LINK_NAME][1]

                            #Set geometry code for ICPR4
                            Weir_Geom_Index = [x[1] for x in WeirGeomCode].index(row.WEIR_SHAPE_DESC)
                            Weir_Geom = WeirGeomCode[Weir_Geom_Index][2]

                            #Determine Weir Type
                            Weir_Type_Index = [x[1] for x in WeirOrienCode].index(row.WEIR_ORIENTATION_DESC)
                            Weir_Type = WeirOrienCode[Weir_Type_Index][2]

                            #Strip out null where calculations are performed and set to 0
                            #Span
                            try:
                                MaxWidth = round(row.WEIR_SPAN_MS/12.,4)
                            except:
                                MaxWidth = 0                        
                            #Rise
                            try:
                                MaxDepth = round(row.WEIR_RISE_MS/12.,4)
                            except:
                                MaxDepth = 0
                            #Top Clip
                            try:
                                TopClip = round(row.WEIR_TOPCLIP_MS/12.,4)
                            except:
                                TopClip = 0
                            #Bottom Clip
                            try:
                                BottomClip = round(row.WEIR_BOTTOMCLIP_MS/12.,4)
                            except:
                                BottomClip = 0                     

                            #Define Comment
                            if str(row.DROP_WEIR_COMMENT)=='None':
                                Comment = ""
                            else:
                                Comment = str(row.DROP_WEIR_COMMENT)


                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.DROP_WEIR_NAME,
                                 row.DROP_WEIR_CNT,
                                 row.DAMPENING_THRESHOLD,
                                 Weir_Type,
                                 Weir_Geom,
                                 row.WEIR_INVERT_ELEVATION_MS,
                                 row.CONTROL_ELEVATION_MS,
                                 row.SECTION_NAME,
                                 row.EXTRAPOLATION_METHOD,
                                 MaxDepth,
                                 MaxWidth,
                                 row.FILLET,
                                 row.WEIR_BOTTOM_WIDTH_MS,
                                 row.LEFTSIDE_SLOPE_VAL,
                                 row.RIGHTSIDE_SLOPE_VAL,
                                 BottomClip,
                                 TopClip,
                                 row.WEIR_DISCHARGE_COEF_VAL,
                                 row.ORIFICE_DISCHARGE_COEF_VAL,
                                 row.BOTTOMCLIP_OPTABLE,
                                 row.TOPCLIP_OPTABLE,
                                 row.WEIRCOEF_OPTABLE,
                                 row.ORIFICECOEF_OPTABLE,
                                 row.BOTTOMCLIP_NODE,
                                 row.TOPCLIP_NODE,
                                 Comment,
                                 row.Drop_Weir_Flow]
                            
                            csv_writerow(f,a)

                    except Exception as e:
                        arcpy.AddMessage(e)

        del rows
                    
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
