#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_Channel_write_file(outpath, stem, LinkDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "CHANNEL"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash +stem+ "_Link_Channel.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "DampeningThreshold",
             "Length",
             "ContractionCoef",
             "ExpansionCoef",
             "EntranceLossCoef",
             "ExitLossCoef",
             "BendLossCoef",
             "BendLocation",
             "EnergySwitch",
             "UsInvert",
             "UsManningsN",
             "UsGeometry",
             "UsMaxDepth",
             "UsMaxWidth",
             "UsExtrapolationMethod",
             "UsBottomWidth",
             "UsLeftSideSlope",
             "UsRightSideSlope",
             "UsMainCrossSection",
             "UsBottomClip",
             "UsBottomClipTable",
             "UsNode_BottomClip",
             "UsBottomClipManningsN",
             "UsTopClip",
             "UsTopClipTable",
             "UsNode_TopClip",
             "UsTopClipManningsN",
             "DsInvert",
             "DsManningsN",
             "DsGeometry",
             "DsMaxDepth",
             "DsMaxWidth",
             "DsExtrapolationMethod",
             "DsBottomWidth",
             "DsLeftSideSlope",
             "DsRightSideSlope",
             "DsMainCrossSection",
             "DsBottomClip",
             "DsBottomClipTable",
             "DsNode_BottomClip",
             "DsBottomClipManningsN",
             "DsTopClip",
             "DsTopClipTable",
             "DsNode_TopClip",
             "DsTopClipManningsN"]

        #Tuple for geometry code revision (Geometry Description, GDB Domain, ICPR4 Code)
        GeomShape = [("Irregular", "IRR", 17),("Trapezoidal", "TRAP", 15),("Parabolic", "PARA",16)]
        
               
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                #only write out data for fields with populated link name
                if row.ICPR_LINK_NAME is not None:

                    try:
                        #Check link code so only links specified as channels in link feature class are written out.  
                        LinkCode = LinkDict[row.ICPR_LINK_NAME][2]

                        if int(LinkCode) == int(23):                 

                            #Determine Parent GUID
                            GUID = LinkDict[row.ICPR_LINK_NAME][1]

                            #Assign geometry codes
                            GeomCode_Index = [x[1] for x in GeomShape].index(row.UPSTREAM_SHAPE_DESC)        
                            GeomCodeUS = GeomShape[GeomCode_Index][2]
                            GeomCode_Index = [x[1] for x in GeomShape].index(row.DOWNSTREAM_SHAPE_DESC)
                            GeomCodeDS = GeomShape[GeomCode_Index][2]                

                            a = [GUID,
                                 row.ICPR_GUID,
                                 row.ICPR_LINK_NAME,
                                 row.DAMPENING_THRESHOLD,
                                 row.CHANNEL_LENGTH_MS,
                                 row.CONTRACTION_COEF_VAL,
                                 row.EXPANSION_COEF_VAL,
                                 row.ENTRANCE_LOSS_VAL,
                                 row.EXIT_LOSS_VAL,
                                 row.BEND_LOSS_VAL,
                                 row.BEND_LOCATION,
                                 row.ENERGY_SWITCH,
                                 row.UPSTREAM_INVERT_ELEVATION_MS,
                                 row.UPSTREAM_MANNINGSN_VAL,GeomCodeUS,
                                 row.UPSTREAM_MAX_DEPTH,
                                 row.UPSTREAM_MAX_WIDTH,
                                 row.UPSTREAM_EXTRAPOLATION_METHOD,
                                 row.UPSTREAM_BOTTOM_WIDTH_MS,
                                 row.UPSTREAM_LEFTSIDE_SLOPE_MS,
                                 row.UPSTREAM_RIGHTSIDE_SLOPE_MS,
                                 row.US_MAIN_XS_NAME,
                                 row.UPSTREAM_BOTTOMCLIP_MS,
                                 row.UPSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.UPSTREAM_BOTTOMCLIP_NODE,
                                 row.UPSTREAM_BOTTOMCLIP_MANNINGSN,
                                 row.UPSTREAM_TOPCLIP_MS,
                                 row.UPSTREAM_TOPCLIP_OPTABLE,
                                 row.UPSTREAM_TOPCLIP_NODE,
                                 row.UPSTREAM_TOPCLIP_MANNINGSN,
                                 row.DOWNSTREAM_INVERT_ELEVATION_MS,
                                 row.DOWNSTREAM_MANNINGSN_VAL, GeomCodeDS,
                                 row.DOWNSTREAM_MAX_DEPTH,
                                 row.DOWNSTREAM_MAX_WIDTH,
                                 row.DS_EXTRAPOLATION_METHOD,
                                 row.DOWNSTREAM_BOTTOM_WIDTH_MS,
                                 row.DOWNSTREAM_LEFTSIDE_SLOPE_MS,
                                 row.DOWNSTREAM_RIGHTSIDE_SLOPE_MS,
                                 row.DS_MAIN_XS_NAME,
                                 row.DOWNSTREAM_BOTTOMCLIP_MS,
                                 row.DOWNSTREAM_BOTTOMCLIP_OPTABLE,
                                 row.DOWNSTREAM_BOTTOMCLIP_NODE,
                                 row.DS_BOTTOMCLIP_MANNINGSN,
                                 row.DOWNSTREAM_TOPCLIP_MS,
                                 row.DOWNSTREAM_TOPCLIP_OPTABLE,
                                 row.DOWNSTREAM_TOPCLIP_NODE,
                                 row.DOWNSTREAM_TOPCLIP_MANNINGSN]
                            
                            csv_writerow(f,a)

                    except Exception as e:
                        arcpy.AddMessage(e)
        del row
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
