#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB
#Date: May 2017

#           Link module
######################################################################################################
######################################################################################################

def LinkPath_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV          
    ####################################################################
    
    try:
                
        infc = "ICPR4_LinkPath"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem+ "_LinkPath.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Empty LinkInfo tuple
        LinkDict = {}
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Line_ARGB",
             "Line_Width",
             "Line_Opacity",
             "Text_ARGB",
             "Text_Font",
             "Text_Size",
             "Text_Bold",
             "Text_Italic",
             "Comment",
             "View_Axis_GridSpacing_X",
             "View_Axis_GridSpacing_Y",
             "View_Axis_ScaleFactor_Y",
             "View_NodeLength",
             "View_MinLinkLength",
             "View_Background_ARGB",
             "View_Axis_ARGB",
             "View_Axis_Text_ARGB",
             "View_Node_ARGB",
             "View_Link_ARGB",
             "View_Water_ARGB",
             "View_Water_Opacity",
             "View_WarningStage",
             "View_WarningStage_ARGB"]

        #Dictionary
        PathDict = {}
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   
                
            # Enter for loop for each feature/row
            for row in rows:

                #Assign ID and ParentID
                ParentID = ScDict[row.SCENARIO][0]

                #Define Comment
                Comment = row.Comment                

                #Write results to file
                a = [ParentID,
                     row.ICPR_GUID,
                     row.Name,
                     row.Line_ARGB,
                     row.Line_Width,
                     row.Line_Opacity,
                     row.Text_ARGB,
                     row.Text_Font,
                     row.Text_Size,
                     row.Text_Bold,
                     row.Text_Italic,
                     row.Comment,
                     row.View_Axis_GridSpacing_X,
                     row.View_Axis_GridSpacing_Y,
                     row.View_Axis_ScaleFactor_Y,
                     row.View_NodeLength,
                     row.View_MinLinkLength,
                     row.View_Background_ARGB,
                     row.View_Axis_ARGB,
                     row.View_Axis_Text_ARGB,
                     row.View_Node_ARGB,
                     row.View_Link_ARGB,
                     row.View_Water_ARGB,
                     row.View_Water_Opacity,
                     row.View_WarningStage,
                     row.View_WarningStage_ARGB]

                PathDict[row.Name] = row.ICPR_GUID

                csv_writerow(f,a)
        del rows                        
    except:

        arcpy.GetMessages()

    ####################################################################
    #Child Table
    ####################################################################

    try:
        
        infc = "ICPR4_LinkPathLink"
        outfc = outpath + slash + stem + "_LinkPath_Link.csv"        

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

             # Enter for loop for each feature/row
            for row in rows:

                #Assign ID and ParentID
                ParentID = PathDict[row.LinkPath]               

                #Write results to file
                a = [ParentID,
                     row.ICPR_GUID,
                     row.LinkName]

                csv_writerow(f,a)
        del rows
            
    except:

        arcpy.GetMessages()
