#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def Link_write_file(outpath, stem, ScDict,LinkTypes):
    #Add forward slash for file path

    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV
    ####################################################################

    try:

        infc = "ICPR_LINK"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        outfc = outpath + slash + stem+ "_Link.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Empty LinkInfo tuple
        LinkDict = {}

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "Type",
             "Node_From",
             "Node_To",
             "LinkCount",
             "FlowDirection",
             "Comment",
             "TextX",
             "TextY",
             "TextZ",
             "TextAngle",
             "IsPlaced",
             "ShapeIsClosed",
             "WQ_WQOption",
             "WQ_Comment",
             "WQ_ShapeX",
             "WQ_ShapeY",
             "WQ_ShapeZ",
             "WQ_IsPlaced"]

        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:

                #Skip if type is filter link
                if row.TYPE != 9:

                    #Assign ID and ParentID
                    GUID = ScDict[row.SCENARIO][0]

                    #Reassign Link Type Code
                    LinkType_Index = [x[1] for x in LinkTypes].index(row.TYPE)
                    LinkCode = LinkTypes[LinkType_Index][2]
                    #flag for links to include
                    LinkFlag = LinkTypes[LinkType_Index][3]

                    #Store Link data in tuple
                    LinkData = (GUID, row.ICPR_GUID, LinkCode, row.NAME)
                    LinkDict[row.NAME]=LinkData

                    if LinkFlag == "true":

                        try:

                            #Check if geometry data exists
                            IsPlaced = row.ISPLACED

                            #Calculate text location at midpoint of link
                            midpoint = row.shape.positionAlongLine(0.50,True).firstPoint
                            TextX = midpoint.X
                            TextY = midpoint.Y

                        except:

                            #If geometry data does not exist do this
                            IsPlaced = 0
                            TextX = 0
                            TextY = 0

                        #Define Comment
                        Comment = row.COMMENT
                        Comment_WQ = row.WQ_Comment

                        #Write results to file
                        a = [GUID,
                             row.ICPR_GUID,
                             row.NAME,
                             LinkCode,
                             row.FROM_NODE,
                             row.TO_NODE,
                             row.LINKCOUNT,
                             row.FLOW,
                             Comment,
                             TextX,
                             TextY, "","",
                             IsPlaced,
                             row.SHAPEISCLOSED,
                             row.WQ_WQOption,
                             Comment_WQ,
                             row.WQ_ShapeX,
                             row.WQ_ShapeY,
                             row.WQ_ShapeZ,
                             row.WQ_IsPlaced]

                        csv_writerow(f,a)
        del rows
    except:

        arcpy.GetMessages()

    ####################################################################
    #Create coordinates
    ####################################################################

    try:

        infc = "ICPR_LINK"
        outfc = outpath + slash + stem + "_Link_Shape_Point.csv"

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)

        shapefieldname = desc.ShapeFieldName

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:
                # Create the geometry object
                #
                feat = row.getValue(shapefieldname)
                partnum = 0

                #Reassign Link Type Code
                LinkType_Index = [x[1] for x in LinkTypes].index(row.TYPE)
                LinkCode = LinkTypes[LinkType_Index][2]

                #flag for links to include
                LinkFlag =LinkTypes[LinkType_Index][3]

                #If coordinate information is not available skip this step
                try:

                    if LinkFlag == "true":

                        #Assign Parent GUID
                        GUID = LinkDict[row.NAME][1]

                        # Count the number of points in the current multipart feature
                        #
                        partcount = feat.partCount

                        # Enter while loop for each part in the feature (if a singlepart feature
                        # this will occur only once)
                        #
                        while partnum < partcount:
                            # Print the part number
                            #
                            part = feat.getPart(partnum)
                            pnt = part.next()
                            pntcount = 0

                            # Enter while loop for each vertex
                            #
                            while pnt:
                                #Write x, y coordinates of current point to CSV
                                a = [GUID, "{"+str(uuid.uuid4())+"}", pntcount,  pnt.X, pnt.Y, ""]
                                csv_writerow(f,a)

                                pnt = part.next()
                                pntcount = pntcount + 1

                                # If pnt is null, either the part is finished or there is an
                                #   interior ring
                                #
                                if not pnt:
                                    pnt = part.next()
                                    if pnt:
                                        print("Interior Ring:")
                            partnum = partnum + 1

                except:
                    arcpy.GetMessages()


        del rows

    except:
        arcpy.GetMessages()

    #############################################################################################
    #Write out returned values (GUID, row.ICPR_GUID, LinkCode, row.NAME)
    #############################################################################################
    try:

        return LinkDict


    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
