#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def GW_Region_write_file(outpath, stem, ScDict, GW_Processed):
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Create table 
    ####################################################################

    #Region Info Tuple
    GWRegionDict = {}

    try:

        infc = "GW_Region"
        
        #Define output location
        outfc = outpath + slash + stem + "_GroundwaterRegion.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        #Add XY Data for label
        shapeName = arcpy.Describe(infc).shapeFieldName

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Name",
             "TextX",
             "TextY",
             "TextZ",
             "Comment",
             "MinTriangulationAngle",
             'MinTriangulationArea',
             'CellSize_HoneycombLayer',
             'Surface_Ground',
             'Ground_UseSingleElevation',
             'GroundElevation',
             'MapLayer_FillablePorosityZone',
             'UseSingleFillablePorosityZone',
             'FillablePorosityZone',
             'MapLayer_ConductivityZone',
             'UseSingleConductivityZone',
             'ConductivityZone',
             'Surface_InitialWaterTable',
             'InitialWaterTable_UseSingleElevation',
             'InitialWaterTableElevation',
             'Surface_ConfiningLayerTop',
             'ConfiningLayerTop_UseSingleElevation',
             'ConfiningLayerTopElevation',
             'LeakageOption',
             'PotentiometricOption',
             'MapLayer_LeakageZone',
             'UseSingleLeakageZone',
             'LeakageZone',
             'Surface_ConfiningLayerBottom',
             'ConfiningLayerBottom_UseSingleElevation',
             'ConfiningLayerBottomElevation',
             'MaxTriangulationArea',
             'BoundaryPointSpacing']

        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    GUID = ScDict[row.Scenario][0]

                    #Define Comment
                    Comment = row.Comment

                    #Determine Label Position
                    pnts = row.getValue(shapeName)
                    pnt = pnts.labelPoint
                    
                    PntX = pnt.X
                    PntY = pnt.Y
                    
                    a = [GUID,
                         row.ICPR_GUID,
                         row.Name,
                         PntX,
                         PntY,
                         "",
                         Comment,
                         row.MinTriangulationAngle,
                         row.MinTriangulationArea,
                         row.CellSize_HoneycombLayer,
                         row.Surface_Ground,
                         row.Ground_UseSingleElevation,
                         row.GroundElevation,
                         row.MapLayer_FillablePorosityZone,
                         row.UseSingleFillablePorosityZone,
                         row.FillablePorosityZone,
                         row.MapLayer_ConductivityZone,
                         row.UseSingleConductivityZone,
                         row.ConductivityZone,
                         row.Surface_InitialWaterTable,
                         row.InitialWaterTable_UseSingleElevation,
                         row.InitialWaterTableElevation,
                         row.Surface_ConfiningLayerTop,
                         row.ConfiningLayerTop_UseSingleElevation,
                         row.ConfiningLayerTopElevation,
                         row.LeakageOption,
                         row.PotentiometricOption,
                         row.MapLayer_LeakageZone,
                         row.UseSingleLeakageZone,
                         row.LeakageZone,
                         row.Surface_ConfiningLayerBottom,
                         row.ConfiningLayerBottom_UseSingleElevation,
                         row.ConfiningLayerBottomElevation,
                         row.MaxTriangulationArea,
                         row.BoundaryPointSpacing]
                    
                    #Store region data in tuple
                    GW_Region_Data = (row.ICPR_GUID, row.Name)
                    GWRegionDict[row.Name]=GW_Region_Data
                        
                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()               

        del rows
        
    except:
        arcpy.GetMessages()

    ####################################################################
    #Create Potentiometric Data 
    ####################################################################
    #Region Info Tuple
    try:

        infc = "ICPR4_Potentiometric"
        
        #Define output location
        outfc = outpath + slash + stem + "_GroundwaterRegion_Potentiometric_Point.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)
       
        # Write headers to CSV
        a = ["ParentID",
             "ID",
             "Year",
             "Month",
             "Day",
             "Hour",
             "Surface",
             "Offset",
             "Elevation"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign ID and ParentID
                    ParentID = GWRegionDict[row.GroundwaterRegion][0]                
                    
                    a = [ParentID,
                         row.ICPR_GUID,
                         row.Year,
                         row.Month,
                         row.Day,
                         row.Hour,
                         row.Surface,
                         row.Offset,
                         row.Elevation]
                        
                    csv_writerow(f,a)

                except:
                    arcpy.GetMessages()               

        del rows
    
    except:
        arcpy.GetMessages()
    
    
    ####################################################################
    #Create coordinates 
    ####################################################################

    if GW_Processed == True:
        
        try:
            
            infc = "GW_Region"
            
            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
            except:            
                pass
            
            outfc = outpath + slash + stem + "_GroundwaterRegion_Point.csv"
           

            # Identify the input feature class to describe
            #
            desc = arcpy.Describe(infc)
            shapefieldname = desc.ShapeFieldName
           
            # Create search cursor
            #
            rows = arcpy.SearchCursor(infc)

            # Write headers to CSV
            a = ["ParentID",
                 "ID",
                 "Vertex",
                 "X",
                 "Y",
                 "Z"]
            
            with open(outfc,'wb') as f:
                csv_writerow(f,a)   

                # Enter for loop for each feature/row
                for row in rows:

                    try:

                        #Determine Parent ID
                        GUID = GWRegionDict[row.Name][0]
                    
                        # Create the geometry object
                        #
                        feat = row.getValue(shapefieldname)
                        partnum = 0

                        # Count the number of points in the current multipart feature
                        #
                        partcount = feat.partCount

                        #Total number of points in feature    
                        pointcount = feat.pointCount
                        
                        # Enter while loop for each part in the feature (if a singlepart feature
                        # this will occur only once)
                        #
                        while partnum < partcount:
                            # Print the part number
                            #
                            part = feat.getPart(partnum)
                            pnt = part.next()
                            pntcount = 0
                    
                            # Enter while loop for each vertex
                            #
                            while pnt:
                                #Write x, y coordinates of current point to CSV
                                a = [GUID, "{"+str(uuid.uuid4())+"}", pntcount, pnt.X, pnt.Y, ""]

                                #Only write points up the last point, which is excluded            
                                if pntcount < pointcount-1:
                                    csv_writerow(f,a)
                                            
                                pnt = part.next()
                                pntcount = pntcount + 1
                    
                                # If pnt is null, either the part is finished or there is an 
                                #   interior ring
                                #
                                if not pnt: 
                                    pnt = part.next()
                                    if pnt:
                                        print("Interior Ring:")
                            partnum = partnum + 1

                    except:
                        arcpy.GetMessages()
            del rows
            
        except:
            arcpy.GetMessages()


    #############################################################################################
    #Write out returned values (row.ICPR_GUID, row.Name)         
    #############################################################################################
    try:

        return GWRegionDict

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
