#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_Richards(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
            
        #Output
        outfc = "ICPR4_VERTICAL_LAYERS_SET"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RichardsEquationSet.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'COMMENT',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            NAME = data[CSV_Name]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       COMMENT,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                            
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_VERTICAL_LAYERS_ZONES"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RichardsEquationSet_RichardsEquation.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['SoilZone',
                      'AllowRecharge',
                      'WTInitial',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_SoilZone = fields.index('SoilZone')
            GDB_AllowRecharge = fields.index('AllowRecharge')
            GDB_WTInitial = fields.index('WTInitial')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Create new Dictionary
            Dict = {}
            
            with open(infc,'r') as csv_file:                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")                        
                        CSV_SoilZone = header_row.index("SoilZone")
                        CSV_AllowRecharge = header_row.index("AllowRecharge")
                        CSV_WTInitial = header_row.index("WTInitial")
                        
                    else:

                        data = iccsv.csv_parseline(line)

                        data[CSV_AllowRecharge] = int(data[CSV_AllowRecharge])
                        data[CSV_WTInitial] = float(data[CSV_WTInitial])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]
                            
                        SoilZone = data[CSV_SoilZone]
                        AllowRecharge = data[CSV_AllowRecharge]
                        WTInitial = data[CSV_WTInitial]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (SoilZone,
                                   AllowRecharge,
                                   WTInitial,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)                               
                        Dict[ICPR_GUID] = [SoilZone,SET_NAME]
                        
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    


##########################################################################################################################
#Populated Child Table 2
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_VERTICAL_LAYERS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "RichardsEquationSet_RichardsEquation_Layer.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['LayerOrder',
                      'KvSaturated',
                      'MCSaturated',
                      'MCResidual',
                      'MCInitial',
                      'MCField',
                      'MCWilting',
                      'PoreSizeIndex',
                      'BubblePressure',
                      'LayerThickness',
                      'CellsPerLayer',
                      'SoilZone',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_LayerOrder = fields.index('LayerOrder')
            GDB_KvSaturated = fields.index('KvSaturated')
            GDB_MCSaturated = fields.index('MCSaturated')
            GDB_MCResidual = fields.index('MCResidual')
            GDB_MCInitial = fields.index('MCInitial')
            GDB_MCField = fields.index('MCField')
            GDB_MCWilting = fields.index('MCWilting')
            GDB_PoreSizeIndex = fields.index('PoreSizeIndex')
            GDB_BubblePressure = fields.index('BubblePressure')
            GDB_LayerThickness = fields.index('LayerThickness')
            GDB_CellsPerLayer = fields.index('CellsPerLayer')
            GDB_SoilZone = fields.index('SoilZone')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_LayerOrder = header_row.index("LayerOrder")
                        CSV_KvSaturated = header_row.index("KvSaturated")
                        CSV_MCSaturated = header_row.index("MCSaturated")
                        CSV_MCResidual = header_row.index("MCResidual")
                        CSV_MCInitial = header_row.index("MCInitial")
                        CSV_MCField = header_row.index("MCField")
                        CSV_MCWilting = header_row.index("MCWilting")
                        CSV_PoreSizeIndex = header_row.index("PoreSizeIndex")
                        CSV_BubblePressure = header_row.index("BubblePressure")
                        CSV_LayerThickness = header_row.index("LayerThickness")
                        CSV_CellsPerLayer = header_row.index("CellsPerLayer")

                    else:

                        data = iccsv.csv_parseline(line)
                        
                        #Data
                        data[CSV_LayerOrder] = int(data[CSV_LayerOrder])
                        data[CSV_KvSaturated] = float(data[CSV_KvSaturated])
                        data[CSV_MCSaturated] = float(data[CSV_MCSaturated])
                        data[CSV_MCResidual] = float(data[CSV_MCResidual])
                        data[CSV_MCInitial] = float(data[CSV_MCInitial])
                        data[CSV_MCField] = float(data[CSV_MCField])
                        data[CSV_MCWilting] = float(data[CSV_MCWilting])
                        data[CSV_PoreSizeIndex] = float(data[CSV_PoreSizeIndex])
                        data[CSV_BubblePressure] = float(data[CSV_BubblePressure])
                        data[CSV_LayerThickness] = float(data[CSV_LayerThickness])
                        data[CSV_CellsPerLayer] = int(data[CSV_CellsPerLayer])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            SoilZone = Dict[data[CSV_ParentID]][0]
                        except:
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            SoilZone = Dict[data[CSV_ParentID]][0]
                                
                        LayerOrder = data[CSV_LayerOrder]
                        KvSaturated = data[CSV_KvSaturated]
                        MCSaturated = data[CSV_MCSaturated]
                        MCResidual = data[CSV_MCResidual]
                        MCInitial = data[CSV_MCInitial]
                        MCField = data[CSV_MCField]
                        MCWilting = data[CSV_MCWilting]
                        PoreSizeIndex = data[CSV_PoreSizeIndex]
                        BubblePressure = data[CSV_BubblePressure]
                        LayerThickness = data[CSV_LayerThickness]
                        CellsPerLayer = data[CSV_CellsPerLayer]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (LayerOrder,
                                   KvSaturated,
                                   MCSaturated,
                                   MCResidual,
                                   MCInitial,
                                   MCField,
                                   MCWilting,
                                   PoreSizeIndex,
                                   BubblePressure,
                                   LayerThickness,
                                   CellsPerLayer,
                                   SoilZone,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
