#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_LinkPath(infc1, Merge, Filestem, ScenDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
    
        #Output
        outfc = "ICPR4_LinkPath"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "LinkPath.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['ICPR_GUID',
                  'Line_ARGB',
                  'Line_Width',
                  'Line_Opacity',
                  'Text_ARGB',
                  'Text_Font',
                  'Text_Size',
                  'Text_Bold',
                  'Text_Italic',
                  'Comment',
                  'View_Axis_GridSpacing_X',
                  'View_Axis_GridSpacing_Y',
                  'View_Axis_ScaleFactor_Y',
                  'View_NodeLength',
                  'View_MinLinkLength',
                  'View_Background_ARGB',
                  'View_Axis_ARGB',
                  'View_Axis_Text_ARGB',
                  'View_Node_ARGB',
                  'View_Link_ARGB',
                  'View_Water_ARGB',
                  'View_Water_Opacity',
                  'View_WarningStage',
                  'View_WarningStage_ARGB',
                  'Scenario',
                  'Name']                 

                  
        #List index
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Line_ARGB = fields.index('Line_ARGB')
        GDB_Line_Width = fields.index('Line_Width')
        GDB_Line_Opacity = fields.index('Line_Opacity')
        GDB_Text_ARGB = fields.index('Text_ARGB')
        GDB_Text_Font = fields.index('Text_Font')
        GDB_Text_Size = fields.index('Text_Size')
        GDB_Text_Bold = fields.index('Text_Bold')
        GDB_Text_Italic = fields.index('Text_Italic')
        GDB_Comment = fields.index('Comment')
        GDB_View_Axis_GridSpacing_X = fields.index('View_Axis_GridSpacing_X')
        GDB_View_Axis_GridSpacing_Y = fields.index('View_Axis_GridSpacing_Y')
        GDB_View_Axis_ScaleFactor_Y = fields.index('View_Axis_ScaleFactor_Y')
        GDB_View_NodeLength = fields.index('View_NodeLength')
        GDB_View_MinLinkLength = fields.index('View_MinLinkLength')
        GDB_View_Background_ARGB = fields.index('View_Background_ARGB')
        GDB_View_Axis_ARGB = fields.index('View_Axis_ARGB')
        GDB_View_Axis_Text_ARGB = fields.index('View_Axis_Text_ARGB')
        GDB_View_Node_ARGB = fields.index('View_Node_ARGB')
        GDB_View_Link_ARGB = fields.index('View_Link_ARGB')
        GDB_View_Water_ARGB = fields.index('View_Water_ARGB')
        GDB_View_Water_Opacity = fields.index('View_Water_Opacity')
        GDB_View_WarningStage = fields.index('View_WarningStage')
        GDB_View_WarningStage_ARGB = fields.index('View_WarningStage_ARGB')
        GDB_Scenario = fields.index('Scenario')
        GDB_Name = fields.index('Name')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Line_ARGB = header_row.index("Line_ARGB")
                        CSV_Line_Width = header_row.index("Line_Width")
                        CSV_Line_Opacity = header_row.index("Line_Opacity")
                        CSV_Text_ARGB = header_row.index("Text_ARGB")
                        CSV_Text_Font = header_row.index("Text_Font")
                        CSV_Text_Size = header_row.index("Text_Size")
                        CSV_Text_Bold = header_row.index("Text_Bold")
                        CSV_Text_Italic = header_row.index("Text_Italic")
                        CSV_Text_Background = header_row.index("Text_Background")
                        CSV_Text_Background_ARGB = header_row.index("Text_Background_ARGB")
                        CSV_Text_Background_Opacity = header_row.index("Text_Background_Opacity")
                        CSV_Comment = header_row.index("Comment")
                        CSV_View_Axis_GridSpacing_X = header_row.index("View_Axis_GridSpacing_X")
                        CSV_View_Axis_GridSpacing_Y = header_row.index("View_Axis_GridSpacing_Y")
                        CSV_View_Axis_ScaleFactor_Y = header_row.index("View_Axis_ScaleFactor_Y")
                        CSV_View_NodeLength = header_row.index("View_NodeLength")
                        CSV_View_MinLinkLength = header_row.index("View_MinLinkLength")
                        CSV_View_Background_ARGB = header_row.index("View_Background_ARGB")
                        CSV_View_Axis_ARGB = header_row.index("View_Axis_ARGB")
                        CSV_View_Axis_Text_ARGB = header_row.index("View_Axis_Text_ARGB")
                        CSV_View_Node_ARGB = header_row.index("View_Node_ARGB")
                        CSV_View_Link_ARGB = header_row.index("View_Link_ARGB")
                        CSV_View_Water_ARGB = header_row.index("View_Water_ARGB")
                        CSV_View_Water_Opacity = header_row.index("View_Water_Opacity")
                        CSV_View_WarningStage = header_row.index("View_WarningStage")
                        CSV_View_WarningStage_ARGB = header_row.index("View_WarningStage_ARGB")              

                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_Line_ARGB] = int(data[CSV_Line_ARGB])
                        data[CSV_Line_Width] = float(data[CSV_Line_Width])
                        data[CSV_Line_Opacity] = int(data[CSV_Line_Opacity])
                        data[CSV_Text_ARGB] = int(data[CSV_Text_ARGB])
                        data[CSV_Text_Size] = float(data[CSV_Text_Size])
                        data[CSV_Text_Bold] = int(data[CSV_Text_Bold])
                        data[CSV_Text_Italic] = int(data[CSV_Text_Italic])
                        data[CSV_Text_Background] = int(data[CSV_Text_Background])
                        data[CSV_Text_Background_ARGB] = int(data[CSV_Text_Background_ARGB])
                        data[CSV_Text_Background_Opacity] = int(data[CSV_Text_Background_Opacity])
                        data[CSV_View_Axis_GridSpacing_X] = float(data[CSV_View_Axis_GridSpacing_X])
                        data[CSV_View_Axis_GridSpacing_Y] = float(data[CSV_View_Axis_GridSpacing_Y])
                        data[CSV_View_Axis_ScaleFactor_Y] = float(data[CSV_View_Axis_ScaleFactor_Y])
                        data[CSV_View_NodeLength] = float(data[CSV_View_NodeLength])
                        data[CSV_View_MinLinkLength] = float(data[CSV_View_MinLinkLength])
                        data[CSV_View_Background_ARGB] = int(data[CSV_View_Background_ARGB])
                        data[CSV_View_Axis_ARGB] = int(data[CSV_View_Axis_ARGB])
                        data[CSV_View_Axis_Text_ARGB] = int(data[CSV_View_Axis_Text_ARGB])
                        data[CSV_View_Node_ARGB] = int(data[CSV_View_Node_ARGB])
                        data[CSV_View_Link_ARGB] = int(data[CSV_View_Link_ARGB])
                        data[CSV_View_Water_ARGB] = int(data[CSV_View_Water_ARGB])
                        data[CSV_View_Water_Opacity] = int(data[CSV_View_Water_Opacity])
                        data[CSV_View_WarningStage] = int(data[CSV_View_WarningStage])
                        data[CSV_View_WarningStage_ARGB] = int(data[CSV_View_WarningStage_ARGB])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Line_ARGB] = data[CSV_Line_ARGB]
                                row[GDB_Line_Width] = data[CSV_Line_Width]
                                row[GDB_Line_Opacity] = data[CSV_Line_Opacity]
                                row[GDB_Text_ARGB] = data[CSV_Text_ARGB]
                                row[GDB_Text_Font] = data[CSV_Text_Font]
                                row[GDB_Text_Size] = data[CSV_Text_Size]
                                row[GDB_Text_Bold] = data[CSV_Text_Bold]
                                row[GDB_Text_Italic] = data[CSV_Text_Italic]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_View_Axis_GridSpacing_X] = data[CSV_View_Axis_GridSpacing_X]
                                row[GDB_View_Axis_GridSpacing_Y] = data[CSV_View_Axis_GridSpacing_Y]
                                row[GDB_View_Axis_ScaleFactor_Y] = data[CSV_View_Axis_ScaleFactor_Y]
                                row[GDB_View_NodeLength] = data[CSV_View_NodeLength]
                                row[GDB_View_MinLinkLength] = data[CSV_View_MinLinkLength]
                                row[GDB_View_Background_ARGB] = data[CSV_View_Background_ARGB]
                                row[GDB_View_Axis_ARGB] = data[CSV_View_Axis_ARGB]
                                row[GDB_View_Axis_Text_ARGB] = data[CSV_View_Axis_Text_ARGB]
                                row[GDB_View_Node_ARGB] = data[CSV_View_Node_ARGB]
                                row[GDB_View_Link_ARGB] = data[CSV_View_Link_ARGB]
                                row[GDB_View_Water_ARGB] = data[CSV_View_Water_ARGB]
                                row[GDB_View_Water_Opacity] = data[CSV_View_Water_Opacity]
                                row[GDB_View_WarningStage] = data[CSV_View_WarningStage]
                                row[GDB_View_WarningStage_ARGB] = data[CSV_View_WarningStage_ARGB]
                                row[GDB_Scenario] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_Name] = data[CSV_Name]
                                                                                  
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                              
                            ICPR_GUID = data[CSV_ID]
                            Line_ARGB = data[CSV_Line_ARGB]
                            Line_Width = data[CSV_Line_Width]
                            Line_Opacity = data[CSV_Line_Opacity]
                            Text_ARGB = data[CSV_Text_ARGB]
                            Text_Font = data[CSV_Text_Font]
                            Text_Size = data[CSV_Text_Size]
                            Text_Bold = data[CSV_Text_Bold]
                            Text_Italic = data[CSV_Text_Italic]
                            Comment = data[CSV_Comment]
                            View_Axis_GridSpacing_X = data[CSV_View_Axis_GridSpacing_X]
                            View_Axis_GridSpacing_Y = data[CSV_View_Axis_GridSpacing_Y]
                            View_Axis_ScaleFactor_Y = data[CSV_View_Axis_ScaleFactor_Y]
                            View_NodeLength = data[CSV_View_NodeLength]
                            View_MinLinkLength = data[CSV_View_MinLinkLength]
                            View_Background_ARGB = data[CSV_View_Background_ARGB]
                            View_Axis_ARGB = data[CSV_View_Axis_ARGB]
                            View_Axis_Text_ARGB = data[CSV_View_Axis_Text_ARGB]
                            View_Node_ARGB = data[CSV_View_Node_ARGB]
                            View_Link_ARGB = data[CSV_View_Link_ARGB]
                            View_Water_ARGB = data[CSV_View_Water_ARGB]
                            View_Water_Opacity = data[CSV_View_Water_Opacity]
                            View_WarningStage = data[CSV_View_WarningStage]
                            View_WarningStage_ARGB = data[CSV_View_WarningStage_ARGB]
                            Scenario = ScenDict[data[CSV_ParentID]][1]
                            Name = data[CSV_Name]

                            In_Data = (ICPR_GUID,
                                       Line_ARGB,
                                       Line_Width,
                                       Line_Opacity,
                                       Text_ARGB,
                                       Text_Font,
                                       Text_Size,
                                       Text_Bold,
                                       Text_Italic,
                                       Comment,
                                       View_Axis_GridSpacing_X,
                                       View_Axis_GridSpacing_Y,
                                       View_Axis_ScaleFactor_Y,
                                       View_NodeLength,
                                       View_MinLinkLength,
                                       View_Background_ARGB,
                                       View_Axis_ARGB,
                                       View_Axis_Text_ARGB,
                                       View_Node_ARGB,
                                       View_Link_ARGB,
                                       View_Water_ARGB,
                                       View_Water_Opacity,
                                       View_WarningStage,
                                       View_WarningStage_ARGB,
                                       Scenario,
                                       Name)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)                                         
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Link Path Link - Update attribute table data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR4_LinkPathLink"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "LinkPath_Link.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass
        
        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass
        
        #Fields for update of existing elements/features
        fields = ['LinkPath',
                  'LinkName',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_LinkPath = fields.index('LinkPath')
        GDB_LinkName = fields.index('LinkName')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Read CSV Data           
        with open(infc,'r') as csv_file:
            first = True
            cursorInsert = arcpy.da.InsertCursor(outfc, fields)
            for line in csv_file:
                if first== True:
                    first = False

                    header_row = iccsv.csv_parseline(line)
                    
                    CSV_ID = header_row.index("ID")
                    CSV_ParentID = header_row.index("ParentID")
                    CSV_Name = header_row.index("Name")
                    
                else:
                    
                    data = iccsv.csv_parseline(line)                   
                        
                    #Assign Name
                    try:                                
                        LinkPath = AddDict[data[CSV_ParentID]][1]

                    except:
                        LinkPath = UpDict[data[CSV_ParentID]][1]
                        
                    LinkName = data[CSV_Name]                                                           
                    ICPR_GUID = data[CSV_ID]

                    In_Data = (LinkPath,
                               LinkName,
                               ICPR_GUID)     

                    #Insert new record                        
                    cursorInsert.insertRow(In_Data)          
            del cursorInsert
                    
    except:

        arcpy.GetMessages()
