#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def UpdateGWRegion(infc1, Merge, Filestem, ScenDict):

##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "GW_Region"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "GroundwaterRegion.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Scenario',
                  'Comment',
                  'Name',
                  'ICPR_GUID',
                  'MinTriangulationAngle',
                  'MinTriangulationArea',
                  'CellSize_HoneycombLayer',
                  'Surface_Ground',
                  'Ground_UseSingleElevation',
                  'GroundElevation',
                  'MapLayer_FillablePorosityZone',
                  'UseSingleFillablePorosityZone',
                  'FillablePorosityZone',
                  'MapLayer_ConductivityZone',
                  'UseSingleConductivityZone',
                  'ConductivityZone',
                  'Surface_InitialWaterTable',
                  'InitialWaterTable_UseSingleElevation',
                  'InitialWaterTableElevation',
                  'Surface_ConfiningLayerTop',
                  'ConfiningLayerTop_UseSingleElevation',
                  'ConfiningLayerTopElevation',
                  'LeakageOption',
                  'PotentiometricOption',
                  'MapLayer_LeakageZone',
                  'UseSingleLeakageZone',
                  'LeakageZone',
                  'Surface_ConfiningLayerBottom',
                  'ConfiningLayerBottom_UseSingleElevation',
                  'ConfiningLayerBottomElevation',
                  'MaxTriangulationArea',
                  'BoundaryPointSpacing']  
                  
        #List index
        GDB_Scenario = fields.index('Scenario')
        GDB_Comment = fields.index('Comment')
        GDB_Name = fields.index('Name')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_MinTriangulationAngle = fields.index('MinTriangulationAngle')
        GDB_MinTriangulationArea = fields.index('MinTriangulationArea')
        GDB_CellSize_HoneycombLayer = fields.index('CellSize_HoneycombLayer')
        GDB_Surface_Ground = fields.index('Surface_Ground')
        GDB_Ground_UseSingleElevation = fields.index('Ground_UseSingleElevation')
        GDB_GroundElevation = fields.index('GroundElevation')
        GDB_MapLayer_FillablePorosityZone = fields.index('MapLayer_FillablePorosityZone')
        GDB_UseSingleFillablePorosityZone = fields.index('UseSingleFillablePorosityZone')
        GDB_FillablePorosityZone = fields.index('FillablePorosityZone')
        GDB_MapLayer_ConductivityZone = fields.index('MapLayer_ConductivityZone')
        GDB_UseSingleConductivityZone = fields.index('UseSingleConductivityZone')
        GDB_ConductivityZone = fields.index('ConductivityZone')
        GDB_Surface_InitialWaterTable = fields.index('Surface_InitialWaterTable')
        GDB_InitialWaterTable_UseSingleElevation = fields.index('InitialWaterTable_UseSingleElevation')
        GDB_InitialWaterTableElevation = fields.index('InitialWaterTableElevation')
        GDB_Surface_ConfiningLayerTop = fields.index('Surface_ConfiningLayerTop')
        GDB_ConfiningLayerTop_UseSingleElevation = fields.index('ConfiningLayerTop_UseSingleElevation')
        GDB_ConfiningLayerTopElevation = fields.index('ConfiningLayerTopElevation')
        GDB_LeakageOption = fields.index('LeakageOption')
        GDB_PotentiometricOption = fields.index('PotentiometricOption')
        GDB_MapLayer_LeakageZone = fields.index('MapLayer_LeakageZone')
        GDB_UseSingleLeakageZone = fields.index('UseSingleLeakageZone')
        GDB_LeakageZone = fields.index('LeakageZone')
        GDB_Surface_ConfiningLayerBottom = fields.index('Surface_ConfiningLayerBottom')
        GDB_ConfiningLayerBottom_UseSingleElevation = fields.index('ConfiningLayerBottom_UseSingleElevation')
        GDB_ConfiningLayerBottomElevation = fields.index('ConfiningLayerBottomElevation')
        GDB_MaxTriangulationArea = fields.index('MaxTriangulationArea')
        GDB_BoundaryPointSpacing = fields.index('BoundaryPointSpacing')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:        

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")
                        CSV_MinTriangulationAngle = header_row.index("MinTriangulationAngle")
                        CSV_MinTriangulationArea = header_row.index("MinTriangulationArea")
                        CSV_CellSize_HoneycombLayer = header_row.index("CellSize_HoneycombLayer")
                        CSV_Surface_Ground = header_row.index("Surface_Ground")
                        CSV_Ground_UseSingleElevation = header_row.index("Ground_UseSingleElevation")
                        CSV_GroundElevation = header_row.index("GroundElevation")
                        CSV_MapLayer_FillablePorosityZone = header_row.index("MapLayer_FillablePorosityZone")
                        CSV_UseSingleFillablePorosityZone = header_row.index("UseSingleFillablePorosityZone")
                        CSV_FillablePorosityZone = header_row.index("FillablePorosityZone")
                        CSV_MapLayer_ConductivityZone = header_row.index("MapLayer_ConductivityZone")
                        CSV_UseSingleConductivityZone = header_row.index("UseSingleConductivityZone")
                        CSV_ConductivityZone = header_row.index("ConductivityZone")
                        CSV_Surface_InitialWaterTable = header_row.index("Surface_InitialWaterTable")
                        CSV_InitialWaterTable_UseSingleElevation = header_row.index("InitialWaterTable_UseSingleElevation")
                        CSV_InitialWaterTableElevation = header_row.index("InitialWaterTableElevation")
                        CSV_Surface_ConfiningLayerTop = header_row.index("Surface_ConfiningLayerTop")
                        CSV_ConfiningLayerTop_UseSingleElevation = header_row.index("ConfiningLayerTop_UseSingleElevation")
                        CSV_ConfiningLayerTopElevation = header_row.index("ConfiningLayerTopElevation")
                        CSV_LeakageOption = header_row.index("LeakageOption")
                        CSV_PotentiometricOption = header_row.index("PotentiometricOption")
                        CSV_MapLayer_LeakageZone = header_row.index("MapLayer_LeakageZone")
                        CSV_UseSingleLeakageZone = header_row.index("UseSingleLeakageZone")
                        CSV_LeakageZone = header_row.index("LeakageZone")
                        CSV_Surface_ConfiningLayerBottom = header_row.index("Surface_ConfiningLayerBottom")
                        CSV_ConfiningLayerBottom_UseSingleElevation = header_row.index("ConfiningLayerBottom_UseSingleElevation")
                        CSV_ConfiningLayerBottomElevation = header_row.index("ConfiningLayerBottomElevation")
                        CSV_MaxTriangulationArea = header_row.index('MaxTriangulationArea')
                        CSV_BoundaryPointSpacing = header_row.index('BoundaryPointSpacing')
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)

                        #Assign data type for integers, boolean and float
                        data[CSV_MinTriangulationAngle] = float(data[CSV_MinTriangulationAngle])
                        data[CSV_MinTriangulationArea] = float(data[CSV_MinTriangulationArea])
                        data[CSV_CellSize_HoneycombLayer] = float(data[CSV_CellSize_HoneycombLayer])
                        data[CSV_Ground_UseSingleElevation] = int(data[CSV_Ground_UseSingleElevation])
                        data[CSV_GroundElevation] = float(data[CSV_GroundElevation])
                        data[CSV_UseSingleFillablePorosityZone] = int(data[CSV_UseSingleFillablePorosityZone])
                        data[CSV_UseSingleConductivityZone] = int(data[CSV_UseSingleConductivityZone])
                        data[CSV_InitialWaterTable_UseSingleElevation] = int(data[CSV_InitialWaterTable_UseSingleElevation])
                        data[CSV_InitialWaterTableElevation] = float(data[CSV_InitialWaterTableElevation])
                        data[CSV_ConfiningLayerTop_UseSingleElevation] = int(data[CSV_ConfiningLayerTop_UseSingleElevation])
                        data[CSV_ConfiningLayerTopElevation] = float(data[CSV_ConfiningLayerTopElevation])
                        data[CSV_LeakageOption] = int(data[CSV_LeakageOption])
                        data[CSV_PotentiometricOption] = int(data[CSV_PotentiometricOption])
                        data[CSV_ConfiningLayerBottom_UseSingleElevation] = int(data[CSV_ConfiningLayerBottom_UseSingleElevation])
                        data[CSV_ConfiningLayerBottomElevation] = float(data[CSV_ConfiningLayerBottomElevation])
                       
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Scenario] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_MinTriangulationAngle] = data[CSV_MinTriangulationAngle]
                                row[GDB_MinTriangulationArea] = data[CSV_MinTriangulationArea]
                                row[GDB_CellSize_HoneycombLayer] = data[CSV_CellSize_HoneycombLayer]
                                row[GDB_Surface_Ground] = data[CSV_Surface_Ground]
                                row[GDB_Ground_UseSingleElevation] = data[CSV_Ground_UseSingleElevation]
                                row[GDB_GroundElevation] = data[CSV_GroundElevation]
                                row[GDB_MapLayer_FillablePorosityZone] = data[CSV_MapLayer_FillablePorosityZone]
                                row[GDB_UseSingleFillablePorosityZone] = data[CSV_UseSingleFillablePorosityZone]
                                row[GDB_FillablePorosityZone] = data[CSV_FillablePorosityZone]
                                row[GDB_MapLayer_ConductivityZone] = data[CSV_MapLayer_ConductivityZone]
                                row[GDB_UseSingleConductivityZone] = data[CSV_UseSingleConductivityZone]
                                row[GDB_ConductivityZone] = data[CSV_ConductivityZone]
                                row[GDB_Surface_InitialWaterTable] = data[CSV_Surface_InitialWaterTable]
                                row[GDB_InitialWaterTable_UseSingleElevation] = data[CSV_InitialWaterTable_UseSingleElevation]
                                row[GDB_InitialWaterTableElevation] = data[CSV_InitialWaterTableElevation]
                                row[GDB_Surface_ConfiningLayerTop] = data[CSV_Surface_ConfiningLayerTop]
                                row[GDB_ConfiningLayerTop_UseSingleElevation] = data[CSV_ConfiningLayerTop_UseSingleElevation]
                                row[GDB_ConfiningLayerTopElevation] = data[CSV_ConfiningLayerTopElevation]
                                row[GDB_LeakageOption] = data[CSV_LeakageOption]
                                row[GDB_PotentiometricOption] = data[CSV_PotentiometricOption]
                                row[GDB_MapLayer_LeakageZone] = data[CSV_MapLayer_LeakageZone]
                                row[GDB_UseSingleLeakageZone] = data[CSV_UseSingleLeakageZone]
                                row[GDB_LeakageZone] = data[CSV_LeakageZone]
                                row[GDB_Surface_ConfiningLayerBottom] = data[CSV_Surface_ConfiningLayerBottom]
                                row[GDB_ConfiningLayerBottom_UseSingleElevation] = data[CSV_ConfiningLayerBottom_UseSingleElevation]
                                row[GDB_ConfiningLayerBottomElevation] = data[CSV_ConfiningLayerBottomElevation]
                                row[GDB_MaxTriangulationArea] = data[CSV_MaxTriangulationArea]
                                row[GDB_BoundaryPointSpacing] = data[CSV_BoundaryPointSpacing]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            ICPR_GUID = data[CSV_ID]
                            Comment = data[CSV_Comment]
                            Name = data[CSV_Name]
                            Scenario = ScenDict[data[CSV_ParentID]][1]
                            MinTriangulationAngle = data[CSV_MinTriangulationAngle]
                            MinTriangulationArea = data[CSV_MinTriangulationArea]
                            CellSize_HoneycombLayer = data[CSV_CellSize_HoneycombLayer]
                            Surface_Ground = data[CSV_Surface_Ground]
                            Ground_UseSingleElevation = data[CSV_Ground_UseSingleElevation]
                            GroundElevation = data[CSV_GroundElevation]
                            MapLayer_FillablePorosityZone = data[CSV_MapLayer_FillablePorosityZone]
                            UseSingleFillablePorosityZone = data[CSV_UseSingleFillablePorosityZone]
                            FillablePorosityZone = data[CSV_FillablePorosityZone]
                            MapLayer_ConductivityZone = data[CSV_MapLayer_ConductivityZone]
                            UseSingleConductivityZone = data[CSV_UseSingleConductivityZone]
                            ConductivityZone = data[CSV_ConductivityZone]
                            Surface_InitialWaterTable = data[CSV_Surface_InitialWaterTable]
                            InitialWaterTable_UseSingleElevation = data[CSV_InitialWaterTable_UseSingleElevation]
                            InitialWaterTableElevation = data[CSV_InitialWaterTableElevation]
                            Surface_ConfiningLayerTop = data[CSV_Surface_ConfiningLayerTop]
                            ConfiningLayerTop_UseSingleElevation = data[CSV_ConfiningLayerTop_UseSingleElevation]
                            ConfiningLayerTopElevation = data[CSV_ConfiningLayerTopElevation]
                            LeakageOption = data[CSV_LeakageOption]
                            PotentiometricOption = data[CSV_PotentiometricOption]
                            MapLayer_LeakageZone = data[CSV_MapLayer_LeakageZone]
                            UseSingleLeakageZone = data[CSV_UseSingleLeakageZone]
                            LeakageZone = data[CSV_LeakageZone]
                            Surface_ConfiningLayerBottom = data[CSV_Surface_ConfiningLayerBottom]
                            ConfiningLayerBottom_UseSingleElevation = data[CSV_ConfiningLayerBottom_UseSingleElevation]
                            ConfiningLayerBottomElevation = data[CSV_ConfiningLayerBottomElevation]
                            MaxTriangulationArea = data[CSV_MaxTriangulationArea]
                            BoundaryPointSpacing = data[CSV_BoundaryPointSpacing]
                            

                            In_Data = (Scenario,
                                       Comment,
                                       Name,
                                       ICPR_GUID,
                                       MinTriangulationAngle,
                                       MinTriangulationArea,
                                       CellSize_HoneycombLayer,
                                       Surface_Ground,
                                       Ground_UseSingleElevation,
                                       GroundElevation,
                                       MapLayer_FillablePorosityZone,
                                       UseSingleFillablePorosityZone,
                                       FillablePorosityZone,
                                       MapLayer_ConductivityZone,
                                       UseSingleConductivityZone,
                                       ConductivityZone,
                                       Surface_InitialWaterTable,
                                       InitialWaterTable_UseSingleElevation,
                                       InitialWaterTableElevation,
                                       Surface_ConfiningLayerTop,
                                       ConfiningLayerTop_UseSingleElevation,
                                       ConfiningLayerTopElevation,
                                       LeakageOption,
                                       PotentiometricOption,
                                       MapLayer_LeakageZone,
                                       UseSingleLeakageZone,
                                       LeakageZone,
                                       Surface_ConfiningLayerBottom,
                                       ConfiningLayerBottom_UseSingleElevation,
                                       ConfiningLayerBottomElevation,
                                       MaxTriangulationArea,
                                       BoundaryPointSpacing)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]          
                del cursorInsert
                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_Potentiometric"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "GroundwaterRegion_Potentiometric_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['GroundwaterRegion',
                      'Year',
                      'Month',
                      'Day',
                      'Hour',
                      'Surface',
                      'Offset',
                      'Elevation',
                      'ICPR_GUID']

            GDB_GroundwaterRegion = fields.index('GroundwaterRegion')
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_Hour = fields.index('Hour')
            GDB_Surface = fields.index('Surface')
            GDB_Offset = fields.index('Offset')                                     
            GDB_Elevation = fields.index('Elevation')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")                        
                        CSV_Year = header_row.index("Year")
                        CSV_Month = header_row.index("Month")
                        CSV_Day = header_row.index("Day")
                        CSV_Hour = header_row.index("Hour")
                        CSV_Surface = header_row.index("Surface")
                        CSV_Offset = header_row.index("Offset")
                        CSV_Elevation = header_row.index("Elevation")
                                                
                    else:

                        data = iccsv.csv_parseline(line)

                        #Data
                        data[CSV_Year] = int(data[CSV_Year])
                        data[CSV_Month] = int(data[CSV_Month])
                        data[CSV_Day] = int(data[CSV_Day])
                        data[CSV_Hour] = float(data[CSV_Hour])
                        data[CSV_Offset] = float(data[CSV_Offset])
                        data[CSV_Elevation] = float(data[CSV_Elevation])
                        
                        #Populate Name
                        try:                    
                            GroundwaterRegion = AddDict[data[CSV_ParentID]][1]
                        except:
                            GroundwaterRegion = UpDict[data[CSV_ParentID]][1]

                        Year = data[CSV_Year]
                        Month = data[CSV_Month]
                        Day = data[CSV_Day]
                        Hour = data[CSV_Hour]
                        Surface = data[CSV_Surface]
                        Offset = data[CSV_Offset]
                        Elevation = data[CSV_Elevation]                       
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (GroundwaterRegion,
                                   Year,
                                   Month,
                                   Day,
                                   Hour,
                                   Surface,
                                   Offset,
                                   Elevation,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert

        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    

##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:            
        #Output
        outfc = "GW_Region"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "GroundwaterRegion_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:

            #Flags for feature geometry data
            Pnts_done = False
            Pnts = []
            Guid_Old = None
            GeomDict = {}#geometry dicationary
            
            
            with open(infc,'r') as csv_file:
                first = True
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex = header_row.index("Vertex")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        Guid_New = data[CSV_ParentID]
                        
                        #Initialize old GUID.  Only happens during the first pass.
                        if Guid_Old == None:
                            Guid_Old = data[CSV_ParentID]
                        
                        #Check if point array is done
                        if Guid_Old != Guid_New:                                                     
                            
                            GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                            Guid_Old = Guid_New #Reset old GUID
                            Pnts = [] #Empty array
                            
                            
                        
                        #Create point
                        pnt = (data[CSV_X],data[CSV_Y])
                        Pnts.append(pnt)                                
        
            #Add last record to dictionary
            GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.              
            
        except:
        
            arcpy.GetMessages()
        
        #Write geometry data to feature class           
        fields = ['ICPR_GUID',
                  'Shape@']

        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPE = fields.index('Shape@')
        
        cursorUpdate = arcpy.da.UpdateCursor(outfc,fields)       
        for row in cursorUpdate:
            try:
                Guid = row[GDB_ICPR_GUID]
                Geom = GeomDict[Guid]
                
                #add geometry
                row[GDB_SHAPE] = Geom
                cursorUpdate.updateRow(row)
                
            except:
                continue

        del cursorUpdate

    except:
        arcpy.GetMessages()

    #Return values
    try:

        return AddDict, UpDict

    except:
        arcpy.GetMessages()