#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_GWInjection(infc1, Merge, Filestem, GW_AddDict, GW_UpDict):
##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "GW_InjectionWell"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Feature_GW_InjectionWell.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features

        fields = ['Name',
                  'WellDiameter',
                  'MeshScalingFactor',
                  'ShutOffElevation',
                  'Comment',
                  'GroundwaterRegion',
                  'ICPR_GUID',
                  'Shape@'] 
                  
        #List index
        GDB_Name = fields.index('Name')
        GDB_WellDiameter = fields.index('WellDiameter')
        GDB_MeshScalingFactor = fields.index('MeshScalingFactor')
        GDB_ShutOffElevation = fields.index('ShutOffElevation')
        GDB_Comment = fields.index('Comment')
        GDB_GroundwaterRegion = fields.index('GroundwaterRegion')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Shape = fields.index('Shape@')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        
                        header_row = iccsv.csv_parseline(line)                    

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_WellDiameter = header_row.index("WellDiameter")
                        CSV_MeshScalingFactor = header_row.index("MeshScalingFactor")
                        CSV_ShutOffElevation = header_row.index("ShutOffElevation")
                        CSV_Comment = header_row.index("Comment")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y") 
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Data Types
                        data[CSV_WellDiameter] = float(data[CSV_WellDiameter])
                        data[CSV_MeshScalingFactor] = float(data[CSV_MeshScalingFactor])
                        data[CSV_ShutOffElevation] = float(data[CSV_ShutOffElevation])
                        data[CSV_X] = float(data[CSV_X])
                        data[CSV_Y] = float(data[CSV_Y])
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_WellDiameter] = data[CSV_WellDiameter]
                                row[GDB_MeshScalingFactor] = data[CSV_MeshScalingFactor]
                                row[GDB_ShutOffElevation] = data[CSV_ShutOffElevation]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Shape] = (data[CSV_X],data[CSV_Y])

                                #Region Name
                                try:
                                    row[GDB_GroundwaterRegion] = GW_AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_GroundwaterRegion] = GW_UpDict[data[CSV_ParentID]][1]
                                
                                #update row if geometry is valid
                                try:                        
                                    cursorUpdate.updateRow(row)
                                except:
                                    pass
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            Name = data[CSV_Name]
                            WellDiameter = data[CSV_WellDiameter]
                            MeshScalingFactor = data[CSV_MeshScalingFactor]
                            ShutOffElevation = data[CSV_ShutOffElevation]
                            Comment = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]
                            Shape = (data[CSV_X],data[CSV_Y])

                            #Region Name
                            try:
                                GroundwaterRegion = GW_AddDict[data[CSV_ParentID]][1]
                            except:
                                GroundwaterRegion = GW_UpDict[data[CSV_ParentID]][1]

                            In_Data = (Name,
                                       WellDiameter,
                                       MeshScalingFactor,
                                       ShutOffElevation,
                                       Comment,
                                       GroundwaterRegion,
                                       ICPR_GUID,
                                       Shape)   

                            #Insert new record if geometry is valid
                            try:
                                cursorInsert.insertRow(In_Data)
                            except:
                                pass                                         
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]          
                del cursorInsert
            
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()
