#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_EHSet(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
            
        #Output
        outfc = "ICPR4_EXTERNAL_HYDROGRAPH_SET"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "ExternalHydrographSet.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'COMMENT',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            NAME = data[CSV_Name]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       COMMENT,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                        
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_EXTERNAL_HYDROGRAPH"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "ExternalHydrograph.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['NAME',
                      'COMMENT',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_NAME = fields.index('NAME')
            GDB_COMMENT = fields.index('COMMENT')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Create new Dictionary
            Dict = {}
            
            with open(infc,'r') as csv_file:
                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")                 
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        
                        #Populate Name
                        try:                    
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]
                            
                        COMMENT = data[CSV_Comment]
                        NAME = data[CSV_Name]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (NAME,
                                   COMMENT,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)   
                        Dict[ICPR_GUID] = [NAME,SET_NAME]
                        
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    


##########################################################################################################################
#Populated Child Table 2
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_EXTERNAL_HYDROGRAPH_PTS"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "ExternalHydrograph_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['NAME',
                      'YEAR',
                      'MONTH',
                      'DAY',
                      'HOUR',
                      'FLOW',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_NAME = fields.index('NAME')
            GDB_YEAR = fields.index('YEAR')
            GDB_MONTH = fields.index('MONTH')
            GDB_DAY = fields.index('DAY')
            GDB_HOUR = fields.index('HOUR')
            GDB_FLOW = fields.index('FLOW')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:
                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Year = header_row.index("Year")
                        CSV_Month = header_row.index("Month")
                        CSV_Day = header_row.index("Day")
                        CSV_Hour = header_row.index("Hour")
                        CSV_Flow = header_row.index("Flow")

                    else:

                        data = iccsv.csv_parseline(line)
                        #Data
                        data[CSV_Year] = int(data[CSV_Year])
                        data[CSV_Month] = int(data[CSV_Month])
                        data[CSV_Day] = int(data[CSV_Day])
                        data[CSV_Hour] = float(data[CSV_Hour])
                        data[CSV_Flow] = float(data[CSV_Flow])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            NAME = Dict[data[CSV_ParentID]][0]
                        except:
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            NAME = Dict[data[CSV_ParentID]][0]
                            
                        YEAR = data[CSV_Year]
                        MONTH = data[CSV_Month]
                        DAY = data[CSV_Day]
                        HOUR = data[CSV_Hour]
                        FLOW = data[CSV_Flow]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (NAME,
                                   YEAR,
                                   MONTH,
                                   DAY,
                                   HOUR,
                                   FLOW,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
